/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.tools.csv_resource_type_updater.impl;

import com.adobe.acs.tools.csv.impl.CsvUtil;
import com.adobe.acs.tools.csv_resource_type_updater.impl.Parameters;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvResourceTypeUpdateServlet
extends SlingAllMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(CsvResourceTypeUpdateServlet.class);
    private static final int DEFAULT_BATCH_SIZE = 1000;
    private static final int VALID_ROW_LENGTH = 3;

    protected final void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        JSONObject jsonResponse = new JSONObject();
        Parameters params = new Parameters(request);
        if (params.getFile() != null) {
            long start = System.currentTimeMillis();
            Iterator<String[]> rows = CsvUtil.getRowsFromCsv(params);
            try {
                ((Session)request.getResourceResolver().adaptTo(Session.class)).getWorkspace().getObservationManager().setUserData("acs-aem-tools.csv-resource-type-updater");
                Result result = this.update(request.getResourceResolver(), params, rows);
                if (log.isInfoEnabled()) {
                    log.info("Updated as TOTAL of [ {} ] resources in {} ms", (Object)result.getSuccess().size(), (Object)(System.currentTimeMillis() - start));
                }
                try {
                    jsonResponse.put("success", result.getSuccess());
                    jsonResponse.put("failure", result.getFailure());
                }
                catch (JSONException e) {
                    log.error("Could not serialized results into JSON", (Throwable)e);
                    this.addMessage(jsonResponse, "Could not serialized results into JSON");
                    response.setStatus(500);
                }
            }
            catch (Exception e) {
                log.error("Could not process CSV type update replacement", (Throwable)e);
                this.addMessage(jsonResponse, "Could not process CSV type update. " + e.getMessage());
                response.setStatus(500);
            }
        } else {
            log.error("Could not find CSV file in request.");
            this.addMessage(jsonResponse, "CSV file is missing");
            response.setStatus(500);
        }
        response.getWriter().print(jsonResponse.toString());
    }

    private Result update(ResourceResolver resourceResolver, Parameters params, Iterator<String[]> rows) throws PersistenceException {
        Result result = new Result();
        HashMap<String, String> map = new HashMap<String, String>();
        while (rows.hasNext()) {
            String[] row = rows.next();
            if (row.length == 3) {
                map.put(row[0], row[1]);
                log.debug("Adding type translation [ {} ] ~> [ {} ]", (Object)row[0], (Object)row[1]);
                continue;
            }
            log.warn("Row {} is malformed", Arrays.asList(row));
        }
        String query = "SELECT * FROM [nt:base] WHERE ";
        query = query + "ISDESCENDANTNODE([" + params.getPath() + "]) AND (";
        ArrayList<String> conditions = new ArrayList<String>();
        for (String key : map.keySet()) {
            conditions.add("[" + params.getPropertyName() + "] = '" + key + "'");
        }
        query = query + StringUtils.join(conditions, (String)" OR ");
        query = query + ")";
        log.debug("Query: {}", (Object)query);
        Iterator resources = resourceResolver.findResources(query, "JCR-SQL2");
        int count = 0;
        while (resources.hasNext()) {
            Resource resource = (Resource)resources.next();
            ModifiableValueMap properties = (ModifiableValueMap)resource.adaptTo(ModifiableValueMap.class);
            String newValue = (String)map.get(properties.get(params.getPropertyName(), String.class));
            if (newValue == null) continue;
            try {
                properties.put((Object)params.getPropertyName(), (Object)newValue);
                result.addSuccess(resource.getPath());
                ++count;
            }
            catch (Exception e) {
                result.addFailure(resource.getPath());
                log.warn("Could not update [ {}@" + params.getPropertyName() + " ]", (Object)resource.getPath(), (Object)e);
            }
            if (count != 1000) continue;
            this.save(resourceResolver, count);
            count = 0;
        }
        this.save(resourceResolver, count);
        return result;
    }

    private void save(ResourceResolver resourceResolver, int size) throws PersistenceException {
        if (resourceResolver.hasChanges()) {
            long start = System.currentTimeMillis();
            resourceResolver.commit();
            if (log.isInfoEnabled()) {
                log.info("Imported a BATCH of [ {} ] assets in {} ms", (Object)size, (Object)(System.currentTimeMillis() - start));
            }
        } else {
            log.debug("Nothing to save");
        }
    }

    private void addMessage(JSONObject jsonObject, String message) {
        try {
            jsonObject.put("message", (Object)message);
        }
        catch (JSONException e) {
            log.error("Could not formulate JSON Response", (Throwable)e);
        }
    }

    private class Result {
        private List<String> success = new ArrayList<String>();
        private List<String> failure = new ArrayList<String>();

        public List<String> getSuccess() {
            return this.success;
        }

        public void addSuccess(String path) {
            this.success.add(path);
        }

        public List<String> getFailure() {
            return this.failure;
        }

        public void addFailure(String path) {
            this.failure.add(path);
        }
    }
}

