/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.tools.dumplibs;

import com.adobe.granite.ui.clientlibs.LibraryType;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DumplibsParams {
    private static final Logger log = LoggerFactory.getLogger(DumplibsParams.class);
    private static final String PARAM_CATEGORIES = "categories";
    private static final String PARAM_PATH = "path";
    private static final String PARAM_TYPE = "type";
    private static final String PARAM_TRANS = "trans";
    private static final String PARAM_THEMED = "themed";
    private String[] categories;
    private String path;
    private LibraryType type;
    private boolean trans;
    private boolean themed;

    DumplibsParams(SlingHttpServletRequest request) {
        this.path = request.getParameter(PARAM_PATH);
        this.categories = this.getCategoriesArray(request.getParameter(PARAM_CATEGORIES));
        this.themed = this.parseBoolean(request.getParameter(PARAM_THEMED));
        this.trans = this.parseBoolean(request.getParameter(PARAM_TRANS));
        this.type = this.getLibraryType(request.getParameter(PARAM_TYPE));
    }

    private String[] getCategoriesArray(String categories) {
        if (categories == null) {
            return null;
        }
        String[] categoriesArr = categories.split(",");
        for (int i = 0; i < categoriesArr.length; ++i) {
            categoriesArr[i] = categoriesArr[i].trim();
        }
        return categoriesArr;
    }

    private boolean parseBoolean(String str) {
        return "yes".equalsIgnoreCase(str) || "1".equalsIgnoreCase(str) || "true".equalsIgnoreCase(str);
    }

    private LibraryType getLibraryType(String typeString) {
        try {
            return LibraryType.valueOf((String)typeString.toUpperCase());
        }
        catch (Exception e) {
            return LibraryType.JS;
        }
    }

    public String getCategoriesString() {
        Object[] categories = this.getCategories();
        return categories == null ? "null" : StringUtils.join((Object[])categories, (String)",");
    }

    public String[] getCategories() {
        return this.categories;
    }

    public String getPath() {
        return this.path;
    }

    public LibraryType getType() {
        return this.type;
    }

    public boolean isTrans() {
        return this.trans;
    }

    public boolean isThemed() {
        return this.themed;
    }
}

