/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.tools.dumplibs;

import com.adobe.acs.tools.dumplibs.DumplibsClientLibrary;
import com.adobe.acs.tools.dumplibs.DumplibsHtmlLibrary;
import com.adobe.acs.tools.dumplibs.DumplibsParams;
import com.adobe.granite.ui.clientlibs.ClientLibrary;
import com.adobe.granite.ui.clientlibs.HtmlLibrary;
import com.adobe.granite.ui.clientlibs.HtmlLibraryManager;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DumplibsServlet
extends SlingSafeMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(DumplibsServlet.class);
    private static final String CONTENT_TYPE_JSON = "application/json";
    private static final Gson gson = new Gson();
    HtmlLibraryManager libraryManager;

    protected final void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        DumplibsParams p = new DumplibsParams(request);
        if (p.getPath() != null) {
            this.handlePathRequest(request, response, p);
        } else if (p.getCategories() != null) {
            this.handleCategoriesRequest(request, response, p);
        } else {
            this.handleAllLibsRequest(request, response, p);
        }
    }

    private void handlePathRequest(SlingHttpServletRequest request, SlingHttpServletResponse response, DumplibsParams p) throws IOException {
        HtmlLibrary lib = this.libraryManager.getLibrary(p.getType(), p.getPath());
        response.setContentType(CONTENT_TYPE_JSON);
        JsonObject jsonObject = lib == null ? new JsonObject() : (JsonObject)this.htmlLibraryToJSON(lib);
        response.getWriter().print(jsonObject.toString());
    }

    private void handleCategoriesRequest(SlingHttpServletRequest request, SlingHttpServletResponse response, DumplibsParams p) throws IOException {
        Collection libs = this.libraryManager.getLibraries(p.getCategories(), p.getType(), !p.isThemed(), p.isTrans());
        JsonArray libsJSON = this.clientLibrariesCollectionToJSON(libs);
        response.setContentType(CONTENT_TYPE_JSON);
        response.getWriter().print(libsJSON.toString());
    }

    private void handleAllLibsRequest(SlingHttpServletRequest request, SlingHttpServletResponse response, DumplibsParams p) throws IOException {
        Map libs = this.libraryManager.getLibraries();
        JsonArray libsJSON = this.clientLibrariesMapToJSON(libs);
        response.setContentType(CONTENT_TYPE_JSON);
        response.getWriter().print(libsJSON.toString());
    }

    private JsonElement htmlLibraryToJSON(HtmlLibrary clientlib) {
        DumplibsHtmlLibrary lib = new DumplibsHtmlLibrary(clientlib);
        return gson.toJsonTree((Object)lib);
    }

    private JsonElement clientLibraryToJSON(ClientLibrary clientlib) {
        DumplibsClientLibrary lib = new DumplibsClientLibrary(clientlib);
        return gson.toJsonTree((Object)lib);
    }

    private JsonArray clientLibrariesMapToJSON(Map<String, ClientLibrary> libraries) {
        return this.clientLibrariesCollectionToJSON(libraries.values());
    }

    private JsonArray clientLibrariesCollectionToJSON(Collection<ClientLibrary> libraries) {
        JsonArray clientlibs = new JsonArray();
        if (libraries != null || !libraries.isEmpty()) {
            for (ClientLibrary lib : libraries) {
                clientlibs.add(this.clientLibraryToJSON(lib));
            }
        }
        return clientlibs;
    }

    protected void bindLibraryManager(HtmlLibraryManager htmlLibraryManager) {
        this.libraryManager = htmlLibraryManager;
    }

    protected void unbindLibraryManager(HtmlLibraryManager htmlLibraryManager) {
        if (this.libraryManager == htmlLibraryManager) {
            this.libraryManager = null;
        }
    }
}

