/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.tools.explain_query.impl;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.spi.FilterReply;
import com.adobe.acs.commons.util.OsgiPropertyUtil;
import com.day.cq.search.PredicateGroup;
import com.day.cq.search.QueryBuilder;
import com.day.cq.search.result.SearchResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import javax.management.openmbean.CompositeData;
import javax.servlet.ServletException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.api.jmx.QueryStatManagerMBean;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.slf4j.Marker;

public class ExplainQueryServlet
extends SlingAllMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(ExplainQueryServlet.class);
    private static final String OAK_QUERY_ANALYZE = "oak.query.analyze";
    private static final String SQL = "sql";
    private static final String SQL2 = "JCR-SQL2";
    private static final String XPATH = "xpath";
    private static final String QUERY_BUILDER = "queryBuilder";
    private static final String[] LANGUAGES = new String[]{"sql", "JCR-SQL2", "xpath"};
    private static final Pattern PROPERTY_INDEX_PATTERN = Pattern.compile("\\/\\*\\sproperty\\s([^\\s=]+)[=\\s]");
    private static final Pattern FILTER_PATTERN = Pattern.compile("\\[[^\\s]+\\]\\sas\\s\\[[^\\s]+\\]\\s\\/\\*\\sFilter\\(");
    private static final String PROP_LOGGER_NAMES = "log.logger-names";
    private static final String DEFAULT_PATTERN = "%msg%n";
    private static final String PROP_MSG_PATTERN = "log.pattern";
    private static final int DEFAULT_LIMIT = 100;
    private static final String PROP_LOG_COUNT_LIMIT = "log.message-count-limit";
    private QueryStatManagerMBean queryStatManagerMBean;
    private QueryBuilder queryBuilder;
    private QueryLogCollector logCollector = null;
    private final AtomicReference<ServiceRegistration> logCollectorReg = new AtomicReference();
    private final AtomicInteger logCollectorRegCount = new AtomicInteger();
    private BundleContext bundleContext;
    private Map<String, String> loggers = new HashMap<String, String>();
    private String pattern = "%msg%n";
    private int msgCountLimit = 100;

    protected final void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        JSONObject json = new JSONObject();
        try {
            json.put("slowQueries", (Object)this.compositeQueryDataToJSON(this.queryStatManagerMBean.getSlowQueries().values()));
        }
        catch (JSONException e) {
            log.error("Unable to serial Slow Queries into JSON: {}", (Object)e.getMessage());
        }
        try {
            json.put("popularQueries", (Object)this.compositeQueryDataToJSON(this.queryStatManagerMBean.getPopularQueries().values()));
        }
        catch (JSONException e) {
            log.error("Unable to serial Popular Queries into JSON: {}", (Object)e.getMessage());
        }
        response.setContentType("application/json");
        response.getWriter().print(json.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        boolean logCollectorRegistered = false;
        ResourceResolver resourceResolver = request.getResourceResolver();
        String statement = StringUtils.removeStartIgnoreCase((String)request.getParameter("statement"), (String)"EXPLAIN ");
        String language = request.getParameter("language");
        Session session = (Session)resourceResolver.adaptTo(Session.class);
        try {
            this.registerLogCollector();
            logCollectorRegistered = true;
            JSONObject json = new JSONObject();
            json.put("statement", (Object)statement);
            json.put("language", (Object)language);
            json.put("explain", (Object)this.explainQuery(session, statement, language));
            boolean collectExecutionTime = "true".equals(StringUtils.defaultIfEmpty((String)request.getParameter("executionTime"), (String)"false"));
            boolean collectCount = "true".equals(StringUtils.defaultIfEmpty((String)request.getParameter("resultCount"), (String)"false"));
            if (collectExecutionTime) {
                json.put("heuristics", (Object)this.getHeuristics(session, statement, language, collectCount));
            }
            response.setContentType("application/json");
            response.getWriter().print(json.toString());
        }
        catch (RepositoryException e) {
            log.error(e.getMessage());
            response.sendError(500);
        }
        catch (JSONException e) {
            log.error(e.getMessage());
            response.sendError(500);
        }
        finally {
            if (logCollectorRegistered) {
                this.unregisterLogCollector();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject explainQuery(Session session, String statement, String language) throws RepositoryException, JSONException {
        Matcher filterMatcher;
        QueryResult queryResult;
        Object query;
        String effectiveStatement;
        String effectiveLanguage;
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        JSONObject json = new JSONObject();
        String collectorKey = this.startCollection();
        if (language.equals(QUERY_BUILDER)) {
            effectiveLanguage = XPATH;
            String[] lines = StringUtils.split((String)statement, (char)'\n');
            Map<String, String> params = OsgiPropertyUtil.toMap(lines, "=", false, null, true);
            com.day.cq.search.Query query2 = this.queryBuilder.createQuery(PredicateGroup.create(params), session);
            effectiveStatement = query2.getResult().getQueryStatement();
        } else {
            effectiveStatement = statement;
            effectiveLanguage = language;
        }
        try {
            query = queryManager.createQuery("explain " + effectiveStatement, effectiveLanguage);
            queryResult = query.execute();
        }
        finally {
            query = this.logCollector;
            synchronized (query) {
                if (this.logCollector != null) {
                    List<String> logs = this.logCollector.getLogs(collectorKey);
                    json.put("logs", this.logCollector.getLogs(collectorKey));
                    if (logs.size() == this.logCollector.msgCountLimit) {
                        json.put("logsTruncated", true);
                    }
                }
                this.stopCollection(collectorKey);
            }
        }
        RowIterator rows = queryResult.getRows();
        Row firstRow = rows.nextRow();
        String plan = firstRow.getValue("plan").getString();
        json.put("plan", (Object)plan);
        HashSet<String> propertyIndexes = new HashSet<String>();
        Matcher propertyMatcher = PROPERTY_INDEX_PATTERN.matcher(plan);
        while (propertyMatcher.find()) {
            String match = propertyMatcher.group(1);
            if (!StringUtils.isNotBlank((String)match)) continue;
            propertyIndexes.add(StringUtils.stripToEmpty((String)match));
        }
        if (!propertyIndexes.isEmpty()) {
            json.put("propertyIndexes", (Object)new JSONArray().put(propertyIndexes));
        }
        if ((filterMatcher = FILTER_PATTERN.matcher(plan)).find()) {
            propertyIndexes.add("nodeType");
            json.put("propertyIndexes", (Object)new JSONArray().put(propertyIndexes));
            json.put("slow", true);
        }
        if (StringUtils.contains((String)plan, (String)" /* traverse ")) {
            json.put("traversal", true);
            json.put("slow", true);
        }
        if (StringUtils.contains((String)plan, (String)" /* aggregate ")) {
            json.put("aggregate", true);
        }
        return json;
    }

    private JSONObject getHeuristics(Session session, String statement, String language, boolean getCount) throws RepositoryException, JSONException {
        long getNodesTime;
        long executionTime;
        int count = 0;
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        JSONObject json = new JSONObject();
        long countTime = 0L;
        if (language.equals(QUERY_BUILDER)) {
            String[] lines = StringUtils.split((String)statement, (char)'\n');
            Map<String, String> params = OsgiPropertyUtil.toMap(lines, "=", false, null, true);
            com.day.cq.search.Query query = this.queryBuilder.createQuery(PredicateGroup.create(params), session);
            long start = System.currentTimeMillis();
            SearchResult result = query.getResult();
            executionTime = System.currentTimeMillis() - start;
            start = System.currentTimeMillis();
            result.getNodes();
            getNodesTime = System.currentTimeMillis() - start;
            if (getCount) {
                count = result.getHits().size();
                countTime = System.currentTimeMillis() - start;
            }
        } else {
            Query query = queryManager.createQuery(statement, language);
            long start = System.currentTimeMillis();
            QueryResult queryResult = query.execute();
            executionTime = System.currentTimeMillis() - start;
            start = System.currentTimeMillis();
            queryResult.getNodes();
            getNodesTime = System.currentTimeMillis() - start;
            if (getCount) {
                NodeIterator nodes = queryResult.getNodes();
                while (nodes.hasNext()) {
                    nodes.next();
                    ++count;
                }
                countTime = System.currentTimeMillis() - start;
            }
        }
        json.put("executeTime", executionTime);
        json.put("getNodesTime", getNodesTime);
        if (getCount) {
            json.put("count", count);
            json.put("countTime", countTime);
        }
        json.put("totalTime", executionTime + getNodesTime + countTime);
        return json;
    }

    private JSONArray compositeQueryDataToJSON(Collection<CompositeData> queries) throws JSONException {
        JSONArray jsonArray = new JSONArray();
        for (CompositeData query : queries) {
            Long duration = (Long)query.get("duration");
            Integer occurrenceCount = (Integer)query.get("occurrenceCount");
            String language = (String)query.get("language");
            String statement = (String)query.get("statement");
            if (!ArrayUtils.contains((Object[])LANGUAGES, (Object)language) || StringUtils.startsWithIgnoreCase((String)statement, (String)"EXPLAIN ") || StringUtils.startsWithIgnoreCase((String)statement, (String)"MEASURE ")) continue;
            JSONObject json = new JSONObject();
            try {
                json.put("duration", (Object)duration);
                json.put("language", (Object)language);
                json.put("occurrenceCount", (Object)occurrenceCount);
                json.put("statement", (Object)statement);
                jsonArray.put((Object)json);
            }
            catch (JSONException e) {
                log.warn("Could not add query to results [ {} ]", (Object)statement);
            }
        }
        return jsonArray;
    }

    private String startCollection() {
        String collectorKey = UUID.randomUUID().toString();
        MDC.put((String)"collectorKey", (String)collectorKey);
        return collectorKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopCollection(String key) {
        QueryLogCollector queryLogCollector = this.logCollector;
        synchronized (queryLogCollector) {
            MDC.remove((String)key);
            if (this.logCollector != null) {
                this.logCollector.stopCollection(key);
            }
        }
    }

    private static boolean checkMDCSupport(BundleContext context) {
        Version versionWithMDCSupport = new Version(1, 0, 9);
        for (Bundle b : context.getBundles()) {
            if (!"org.apache.jackrabbit.oak-core".equals(b.getSymbolicName())) continue;
            return versionWithMDCSupport.compareTo((Object)b.getVersion()) <= 0;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerLogCollector() {
        AtomicInteger atomicInteger = this.logCollectorRegCount;
        synchronized (atomicInteger) {
            int count = this.logCollectorRegCount.getAndIncrement();
            if (count == 0) {
                ServiceRegistration reg = this.bundleContext.registerService(TurboFilter.class.getName(), (Object)this.logCollector, null);
                this.logCollectorReg.set(reg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterLogCollector() {
        AtomicInteger atomicInteger = this.logCollectorRegCount;
        synchronized (atomicInteger) {
            int count = this.logCollectorRegCount.decrementAndGet();
            if (count == 0) {
                ServiceRegistration reg = this.logCollectorReg.getAndSet(null);
                reg.unregister();
            }
        }
    }

    private void activate(Map<String, ?> config, BundleContext context) {
        this.bundleContext = context;
        this.loggers = OsgiPropertyUtil.toMap(PropertiesUtil.toStringArray(config.get(PROP_LOGGER_NAMES), (String[])new String[0]), "=", true, null);
        if (this.loggers != null && !this.loggers.isEmpty()) {
            this.pattern = PropertiesUtil.toString(config.get(PROP_MSG_PATTERN), (String)DEFAULT_PATTERN);
            this.msgCountLimit = PropertiesUtil.toInteger(config.get(PROP_LOG_COUNT_LIMIT), (int)100);
            this.logCollector = new QueryLogCollector(this.loggers, this.pattern, this.msgCountLimit, ExplainQueryServlet.checkMDCSupport(context));
        } else {
            this.logCollector = null;
        }
    }

    private void deactivate() {
        ServiceRegistration reg = this.logCollectorReg.getAndSet(null);
        if (reg != null) {
            reg.unregister();
        }
    }

    protected void bindQueryStatManagerMBean(QueryStatManagerMBean queryStatManagerMBean) {
        this.queryStatManagerMBean = queryStatManagerMBean;
    }

    protected void unbindQueryStatManagerMBean(QueryStatManagerMBean queryStatManagerMBean) {
        if (this.queryStatManagerMBean == queryStatManagerMBean) {
            this.queryStatManagerMBean = null;
        }
    }

    protected void bindQueryBuilder(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    protected void unbindQueryBuilder(QueryBuilder queryBuilder) {
        if (this.queryBuilder == queryBuilder) {
            this.queryBuilder = null;
        }
    }

    private static final class QueryLogCollector
    extends TurboFilter {
        private static final String COLLECTOR_KEY = "collectorKey";
        private final Map<String, String> loggers;
        private final Layout<ILoggingEvent> layout;
        private final int msgCountLimit;
        private final Map<String, List<ILoggingEvent>> logEvents = new ConcurrentHashMap<String, List<ILoggingEvent>>();
        private final boolean mdcEnabled;

        private QueryLogCollector(Map<String, String> loggers, String pattern, int msgCountLimit, boolean mdcEnabled) {
            this.loggers = loggers;
            this.msgCountLimit = msgCountLimit;
            this.layout = QueryLogCollector.createLayout(pattern);
            this.mdcEnabled = mdcEnabled;
            if (!mdcEnabled) {
                log.debug("Current Oak version does not provide MDC. Explain log would have some extra entries");
            }
        }

        public FilterReply decide(Marker marker, ch.qos.logback.classic.Logger logger, Level level, String format, Object[] params, Throwable t) {
            String collectorKey = MDC.get((String)COLLECTOR_KEY);
            if (collectorKey == null) {
                return FilterReply.NEUTRAL;
            }
            if (!this.acceptLogStatement(logger.getName())) {
                return FilterReply.NEUTRAL;
            }
            if (format == null) {
                return FilterReply.ACCEPT;
            }
            LoggingEvent logEvent = new LoggingEvent(ch.qos.logback.classic.Logger.FQCN, logger, level, format, t, params);
            this.log(collectorKey, (ILoggingEvent)logEvent);
            return FilterReply.NEUTRAL;
        }

        public List<String> getLogs(String collectorKey) {
            List<ILoggingEvent> eventList = this.logEvents.get(collectorKey);
            if (eventList == null) {
                return Collections.emptyList();
            }
            ArrayList<String> result = new ArrayList<String>(eventList.size());
            for (ILoggingEvent e : eventList) {
                result.add(this.layout.doLayout((Object)e));
            }
            return result;
        }

        public void stopCollection(String key) {
            this.logEvents.remove(key);
        }

        private void log(String collectorKey, ILoggingEvent e) {
            List<ILoggingEvent> eventList = this.logEvents.get(collectorKey);
            if (eventList == null) {
                eventList = new ArrayList<ILoggingEvent>();
                this.logEvents.put(collectorKey, eventList);
            }
            if (eventList.size() < this.msgCountLimit) {
                eventList.add(e);
            }
        }

        private boolean acceptLogStatement(String name) {
            for (Map.Entry<String, String> entry : this.loggers.entrySet()) {
                if (!name.startsWith(entry.getKey())) continue;
                if (!this.mdcEnabled) {
                    return true;
                }
                if (this.mdcEnabled && entry.getValue() == null) {
                    return true;
                }
                return this.mdcEnabled && entry.getValue() != null && MDC.get((String)entry.getValue()) != null;
            }
            return false;
        }

        private static Layout<ILoggingEvent> createLayout(String pattern) {
            PatternLayout pl = new PatternLayout();
            pl.setPattern(pattern);
            pl.setOutputPatternAsHeader(false);
            pl.setContext((Context)((LoggerContext)LoggerFactory.getILoggerFactory()));
            pl.start();
            return pl;
        }
    }
}

