/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.tools.fiddle.impl;

import com.adobe.acs.tools.fiddle.impl.FiddleRefresher;
import com.adobe.acs.tools.fiddle.impl.InMemoryScript;
import com.adobe.granite.license.ProductInfo;
import com.adobe.granite.license.ProductInfoService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceProvider;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.spi.resource.provider.ResolveContext;
import org.apache.sling.spi.resource.provider.ResourceContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.Version;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FiddleResourceProviderImpl
extends org.apache.sling.spi.resource.provider.ResourceProvider<Object>
implements FiddleRefresher,
ResourceProvider {
    private static final Logger log = LoggerFactory.getLogger(FiddleResourceProviderImpl.class);
    private static final String ROOT = "/apps/acs-tools/components/aemfiddle/fiddle";
    private static final Version AEM_63_VERSION = new Version(6, 3, 0);
    private EventAdmin eventAdmin;
    private ProductInfoService productInfoService;
    private volatile ServiceRegistration resourceProviderRegistration = null;
    private volatile ServiceRegistration legacyResourceProviderRegistration = null;

    public Resource getResource(ResolveContext ctx, String path, ResourceContext resourceContext, Resource parent) {
        ResourceResolver resourceResolver = ctx.getResourceResolver();
        InMemoryScript script = InMemoryScript.get();
        if (script != null && path.equals(script.getPath())) {
            return script.toResource(resourceResolver);
        }
        return null;
    }

    public Iterator<Resource> listChildren(ResolveContext ctx, Resource parent) {
        InMemoryScript script;
        if (parent.getPath().equals(ROOT) && (script = InMemoryScript.get()) != null) {
            Resource scriptResource = script.toResource(parent.getResourceResolver());
            return Collections.singleton(scriptResource).iterator();
        }
        return null;
    }

    @Override
    public void refresh(String path) {
        if (this.resourceProviderRegistration != null) {
            if (this.getProviderContext() != null) {
                ArrayList<ResourceChange> resourceChangeList = new ArrayList<ResourceChange>();
                ResourceChange resourceChange = new ResourceChange(ResourceChange.ChangeType.CHANGED, path, false, Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
                resourceChangeList.add(resourceChange);
                this.getProviderContext().getObservationReporter().reportChanges(resourceChangeList, false);
            } else {
                log.warn("Unable to obtain a Observation Changer for AEM Fiddle script resource provider");
            }
        } else {
            Map<String, String> props = Collections.singletonMap("path", path);
            this.eventAdmin.sendEvent(new Event("org/apache/sling/api/resource/Resource/CHANGED", props));
        }
    }

    protected void activate(BundleContext context) {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ProductInfo[] productInfos = this.productInfoService.getInfos();
        if (productInfos.length > 0) {
            Version actualVersion = productInfos[0].getVersion();
            if (actualVersion.compareTo((Object)AEM_63_VERSION) < 0) {
                ((Dictionary)props).put("provider.roots", ROOT);
                this.legacyResourceProviderRegistration = context.registerService(ResourceProvider.class.getName(), (Object)this, props);
            } else {
                ((Dictionary)props).put("provider.name", "acs-aem-tools.aem-fiddle");
                ((Dictionary)props).put("provider.root", ROOT);
                ((Dictionary)props).put("provider.refreshable", true);
                this.resourceProviderRegistration = context.registerService(org.apache.sling.spi.resource.provider.ResourceProvider.class.getName(), (Object)this, props);
            }
        }
    }

    protected void deactivate(BundleContext context) {
        if (this.legacyResourceProviderRegistration != null) {
            this.resourceProviderRegistration.unregister();
        }
        if (this.resourceProviderRegistration != null) {
            this.resourceProviderRegistration.unregister();
        }
    }

    public Resource getResource(ResourceResolver resourceResolver, HttpServletRequest request, String path) {
        return this.getResource(resourceResolver, path);
    }

    public Resource getResource(ResourceResolver resourceResolver, String path) {
        InMemoryScript script = InMemoryScript.get();
        if (script != null && path.equals(script.getPath())) {
            return script.toResource(resourceResolver);
        }
        return null;
    }

    public Iterator<Resource> listChildren(Resource parent) {
        return this.listChildren(null, parent);
    }

    protected void bindEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    protected void unbindEventAdmin(EventAdmin eventAdmin) {
        if (this.eventAdmin == eventAdmin) {
            this.eventAdmin = null;
        }
    }

    protected void bindProductInfoService(ProductInfoService productInfoService) {
        this.productInfoService = productInfoService;
    }

    protected void unbindProductInfoService(ProductInfoService productInfoService) {
        if (this.productInfoService == productInfoService) {
            this.productInfoService = null;
        }
    }
}

