/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.tools.fiddle.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;

public class InMemoryScript {
    private static final Charset charset = Charset.forName("UTF-8");
    private static ThreadLocal<InMemoryScript> holder = new ThreadLocal();
    private final String extension;
    private final String data;
    private final String path;

    public String getExtension() {
        return this.extension;
    }

    public String getData() {
        return this.data;
    }

    private InMemoryScript(String ext, String data) {
        this.extension = ext;
        this.data = data;
        this.path = "/apps/acs-tools/components/aemfiddle/fiddle/fiddle." + this.extension;
    }

    public static InMemoryScript set(String ext, String data) {
        InMemoryScript value = new InMemoryScript(ext, data);
        holder.set(value);
        return value;
    }

    public static InMemoryScript get() {
        return holder.get();
    }

    public static void clear() {
        holder.set(null);
    }

    public Resource toResource(ResourceResolver resourceResolver) {
        return new ScriptResource(resourceResolver);
    }

    public String getPath() {
        return this.path;
    }

    public class ScriptParentResource
    extends SyntheticResource {
        private ScriptResource scriptResource;

        public ScriptParentResource(ScriptResource scriptResource) {
            super(scriptResource.getResourceResolver(), Text.getAbsoluteParent((String)scriptResource.getPath(), (int)1), null);
            this.scriptResource = scriptResource;
        }

        public Resource getChild(String relPath) {
            if (relPath.equals(this.scriptResource.getName())) {
                return this.scriptResource;
            }
            return null;
        }
    }

    private class ScriptPropertiesResource
    extends SyntheticResource {
        private final ValueMap properties;

        public ScriptPropertiesResource(ResourceResolver resourceResolver) {
            super(resourceResolver, InMemoryScript.this.path + "/" + "jcr:content", "nt:unstructured");
            Map<String, String> map = Collections.singletonMap("jcr:encoding", charset.name());
            this.properties = new ValueMapDecorator(map);
        }

        public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
            if (type == ValueMap.class) {
                return (AdapterType)this.properties;
            }
            return (AdapterType)super.adaptTo(type);
        }
    }

    private class ScriptResource
    extends SyntheticResource {
        public ScriptResource(ResourceResolver resourceResolver) {
            super(resourceResolver, InMemoryScript.this.path, "nt:file");
        }

        public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
            if (type == InputStream.class) {
                return (AdapterType)new ByteArrayInputStream(InMemoryScript.this.data.getBytes(charset));
            }
            if (type == ValueMap.class) {
                return (AdapterType)ValueMapDecorator.EMPTY;
            }
            return (AdapterType)super.adaptTo(type);
        }

        public Resource getChild(String relPath) {
            if ("jcr:content".equals(relPath)) {
                return new ScriptPropertiesResource(this.getResourceResolver());
            }
            return null;
        }

        public Resource getParent() {
            return new ScriptParentResource(this);
        }
    }
}

