/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.tools.fiddle.impl;

import com.adobe.acs.tools.fiddle.impl.FiddleRefresher;
import com.adobe.acs.tools.fiddle.impl.InMemoryScript;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestDispatcherOptions;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.api.wrappers.SlingHttpServletRequestWrapper;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunFiddleServlet
extends SlingAllMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(RunFiddleServlet.class);
    private static final String VAR_CLASSES = "/var/classes";
    private static final String COMPILED_JSP = "org/apache/jsp/apps/acs_002dtools/components/aemfiddle";
    private static final String[] COMPILED_JSP_FILES = new String[]{"org/apache/jsp/apps/acs_002dtools/components/aemfiddle/fiddle/fiddle_jsp.class", "org/apache/jsp/apps/acs_002dtools/components/aemfiddle/fiddle/fiddle_jsp.deps", "org/apache/jsp/apps/acs_002dtools/components/aemfiddle/fiddle/fiddle_jsp.java"};
    private File fileRoot;
    private FiddleRefresher fiddleRefresher;
    private SlingSettingsService slingSettingsService;

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        this.clearCompiledFiddle(request.getResourceResolver());
        Resource resource = this.getResource(request);
        String data = request.getParameter("scriptdata");
        String ext = request.getParameter("scriptext");
        InMemoryScript script = InMemoryScript.set(ext, data);
        this.fiddleRefresher.refresh(script.getPath());
        RequestDispatcherOptions options = new RequestDispatcherOptions();
        options.setForceResourceType("/apps/acs-tools/components/aemfiddle/fiddle");
        options.setReplaceSelectors("");
        request.setAttribute("com.adobe.acs.commons.wcm.component-error-handler.suppress", (Object)true);
        try {
            ((Session)request.getResourceResolver().adaptTo(Session.class)).getWorkspace().getObservationManager().setUserData("acs-aem-tools.aem-fiddle");
        }
        catch (RepositoryException e) {
            log.warn("Unable to set [ user-event-data = acs-aem-tools.aem-fiddle ] for fiddle execution.", (Throwable)e);
        }
        RequestDispatcher dispatcher = request.getRequestDispatcher(resource, options);
        GetRequest getRequest = new GetRequest(request);
        dispatcher.forward((ServletRequest)getRequest, (ServletResponse)response);
    }

    private Resource getResource(SlingHttpServletRequest request) {
        String path = request.getParameter("resource");
        if (path == null || "".equals(path)) {
            return request.getResource();
        }
        Resource resource = request.getResourceResolver().resolve(path);
        if (resource != null) {
            return resource;
        }
        return request.getResource();
    }

    private void clearCompiledFiddle(ResourceResolver resourceResolver) {
        Resource varClasses = resourceResolver.getResource(VAR_CLASSES);
        if (varClasses != null) {
            this.removeResource(varClasses.getChild(COMPILED_JSP));
            Iterator iterator = varClasses.listChildren();
            while (iterator.hasNext()) {
                Resource varClass = (Resource)iterator.next();
                this.removeResource(varClass.getChild(COMPILED_JSP));
            }
        }
        if (this.fileRoot != null) {
            for (String fileName : COMPILED_JSP_FILES) {
                File file = new File(this.fileRoot, fileName);
                if (!file.exists()) continue;
                file.delete();
            }
        }
    }

    private void removeResource(Resource resource) {
        Node node;
        if (resource != null && (node = (Node)resource.adaptTo(Node.class)) != null) {
            try {
                log.trace("Removing AEM Fiddle compiled scripts at: {}", (Object)node.getPath());
                node.remove();
                node.getSession().save();
            }
            catch (RepositoryException e) {
                log.error("Could not remove compiled AEM Fiddle scripts: {}", (Throwable)e);
            }
        }
    }

    protected void activate(ComponentContext ctx) {
        BundleContext bundleContext = ctx.getBundleContext();
        for (Bundle bundle : bundleContext.getBundles()) {
            if (!bundle.getSymbolicName().equals("org.apache.sling.commons.fsclassloader")) continue;
            this.fileRoot = new File(this.slingSettingsService.getSlingHomePath(), "launchpad/felix/bundle" + bundle.getBundleId() + "/data/classes");
            break;
        }
    }

    protected void bindFiddleRefresher(FiddleRefresher fiddleRefresher) {
        this.fiddleRefresher = fiddleRefresher;
    }

    protected void unbindFiddleRefresher(FiddleRefresher fiddleRefresher) {
        if (this.fiddleRefresher == fiddleRefresher) {
            this.fiddleRefresher = null;
        }
    }

    protected void bindSlingSettingsService(SlingSettingsService slingSettingsService) {
        this.slingSettingsService = slingSettingsService;
    }

    protected void unbindSlingSettingsService(SlingSettingsService slingSettingsService) {
        if (this.slingSettingsService == slingSettingsService) {
            this.slingSettingsService = null;
        }
    }

    private static class GetRequest
    extends SlingHttpServletRequestWrapper {
        public GetRequest(SlingHttpServletRequest wrappedRequest) {
            super(wrappedRequest);
        }

        public String getMethod() {
            return "GET";
        }
    }
}

