/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.tools.hc.impl;

import com.day.cq.wcm.api.components.Component;
import com.day.cq.wcm.api.components.ComponentManager;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.hc.api.HealthCheck;
import org.apache.sling.hc.api.Result;
import org.apache.sling.hc.api.ResultLog;
import org.apache.sling.hc.util.FormattingResultLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentIconHealthCheck
implements HealthCheck {
    private static final String FOUNDATION_PAGE_TYPE = "foundation/components/page";
    private static final String CLOUD_SERVICE_CONFIG_PAGE_TYPE = "cq/cloudserviceconfigs/components/configpage";
    private static final Logger log = LoggerFactory.getLogger(ComponentIconHealthCheck.class);
    private static final String PROP_PAGE_TYPES = "page.types";
    private static final String PROP_PATHS = "paths";
    private static final String GROUP_HIDDEN = ".hidden";
    private ResourceResolverFactory rrFactory;
    private String[] paths;
    private String[] pageTypes;

    protected void activate(Map<String, Object> properties) {
        this.paths = PropertiesUtil.toStringArray((Object)properties.get(PROP_PATHS), (String[])new String[0]);
        this.pageTypes = PropertiesUtil.toStringArray((Object)properties.get(PROP_PAGE_TYPES), (String[])new String[]{FOUNDATION_PAGE_TYPE, CLOUD_SERVICE_CONFIG_PAGE_TYPE});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result execute() {
        FormattingResultLog resultLog = new FormattingResultLog();
        int componentsWithoutIcons = 0;
        ResourceResolver resolver = null;
        try {
            resolver = this.rrFactory.getAdministrativeResourceResolver(null);
            ComponentManager compManager = (ComponentManager)resolver.adaptTo(ComponentManager.class);
            Collection components = compManager.getComponents();
            for (Component component : components) {
                String path = component.getPath();
                if (!StringUtils.startsWithAny((String)path, (String[])this.paths)) continue;
                String iconPath = component.getIconPath();
                if (!this.isDroppable(component) || this.isPageType(component) || iconPath != null) continue;
                ++componentsWithoutIcons;
                resultLog.warn("Component {} is editable, but doesn't have an icon.", new Object[]{path});
            }
            if (componentsWithoutIcons > 0) {
                resultLog.info("[You have component without icons.]", new Object[0]);
            } else {
                resultLog.debug("All components have icons.", new Object[0]);
            }
        }
        catch (Exception e) {
            log.error("Unable to list components", (Throwable)e);
        }
        finally {
            if (resolver != null) {
                resolver.close();
            }
        }
        return new Result((ResultLog)resultLog);
    }

    private boolean isDroppable(Component component) {
        return component.isEditable() && !component.getComponentGroup().equals(GROUP_HIDDEN);
    }

    private boolean isPageType(Component component) {
        if (component == null) {
            return false;
        }
        if (ArrayUtils.contains((Object[])this.pageTypes, (Object)component.getResourceType())) {
            return true;
        }
        return this.isPageType(component.getSuperComponent());
    }

    protected void bindRrFactory(ResourceResolverFactory resourceResolverFactory) {
        this.rrFactory = resourceResolverFactory;
    }

    protected void unbindRrFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.rrFactory == resourceResolverFactory) {
            this.rrFactory = null;
        }
    }
}

