/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.tools.hc.impl;

import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.Template;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.hc.api.HealthCheck;
import org.apache.sling.hc.api.Result;
import org.apache.sling.hc.api.ResultLog;
import org.apache.sling.hc.util.FormattingResultLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateThumbnailHealthCheck
implements HealthCheck {
    private static final Logger log = LoggerFactory.getLogger(TemplateThumbnailHealthCheck.class);
    private static final String PROP_PATHS = "paths";
    private ResourceResolverFactory rrFactory;
    private String[] paths;

    protected void activate(Map<String, Object> properties) {
        this.paths = PropertiesUtil.toStringArray((Object)properties.get(PROP_PATHS), (String[])new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result execute() {
        FormattingResultLog resultLog = new FormattingResultLog();
        int templatesWithoutIcons = 0;
        ResourceResolver resolver = null;
        try {
            resolver = this.rrFactory.getAdministrativeResourceResolver(null);
            PageManager pageManager = (PageManager)resolver.adaptTo(PageManager.class);
            Collection templates = pageManager.getTemplates(null);
            for (Template template : templates) {
                String thumbnailPath;
                String path = template.getPath();
                if (!StringUtils.startsWithAny((String)path, (String[])this.paths) || (thumbnailPath = template.getThumbnailPath()) != null) continue;
                ++templatesWithoutIcons;
                resultLog.warn("Template {} doesn't have a thumbnail.", new Object[]{path});
            }
            if (templatesWithoutIcons > 0) {
                resultLog.info("[You have templates without thumbnails.]", new Object[0]);
            } else {
                resultLog.debug("All templates have thumbnails.", new Object[0]);
            }
        }
        catch (Exception e) {
            log.error("Unable to list templates", (Throwable)e);
        }
        finally {
            if (resolver != null) {
                resolver.close();
            }
        }
        return new Result((ResultLog)resultLog);
    }

    protected void bindRrFactory(ResourceResolverFactory resourceResolverFactory) {
        this.rrFactory = resourceResolverFactory;
    }

    protected void unbindRrFactory(ResourceResolverFactory resourceResolverFactory) {
        if (this.rrFactory == resourceResolverFactory) {
            this.rrFactory = null;
        }
    }
}

