/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.tools.jsp_code_display.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.settings.SlingSettingsService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;

public class JspCodeServlet
extends SlingAllMethodsServlet {
    private SlingSettingsService slingSettingsService;
    private File fileRoot;

    protected void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        try {
            JSONObject result = new JSONObject();
            String line = request.getParameter("line");
            if (StringUtils.isNotBlank((String)line)) {
                Pattern pattern = Pattern.compile("^(.+)\\.(\\w+)\\.(\\w+)\\((\\w+\\.java):(\\d+)\\)$");
                Matcher matcher = pattern.matcher(line);
                if (matcher.matches()) {
                    String packageName = matcher.group(1);
                    String fileName = matcher.group(4);
                    String lineNumber = matcher.group(5);
                    String sourceFilePath = "/" + packageName.replace('.', '/') + "/" + fileName;
                    InputStream instream = null;
                    if (this.fileRoot != null) {
                        File classFile = new File(this.fileRoot, sourceFilePath);
                        if (classFile.exists()) {
                            instream = new FileInputStream(classFile);
                        }
                    } else {
                        ResourceResolver resourceResolver = request.getResourceResolver();
                        Resource classesRoot = resourceResolver.getResource("/var/classes");
                        if (classesRoot != null) {
                            if (classesRoot.getChild("org") != null) {
                                Resource fileResource = resourceResolver.getResource(classesRoot.getPath() + sourceFilePath);
                                if (fileResource != null) {
                                    instream = (InputStream)fileResource.adaptTo(InputStream.class);
                                }
                            } else {
                                Resource fileResource;
                                Iterator roots = classesRoot.listChildren();
                                if (roots.hasNext() && (fileResource = resourceResolver.getResource(((Resource)roots.next()).getPath() + sourceFilePath)) != null) {
                                    instream = (InputStream)fileResource.adaptTo(InputStream.class);
                                }
                            }
                        }
                    }
                    if (instream != null) {
                        result.put("success", true);
                        result.put("lineNumber", Integer.parseInt(lineNumber));
                        result.put("code", (Object)IOUtils.toString((InputStream)instream, (String)"UTF-8"));
                        IOUtils.closeQuietly((InputStream)instream);
                    } else {
                        result.put("success", false);
                        result.put("error", (Object)"Compiled JSP could not be found.");
                    }
                }
            } else {
                result.put("success", false);
                result.put("error", (Object)"No line was provided");
            }
            response.setContentType("application/json");
            result.write((Writer)response.getWriter());
        }
        catch (JSONException e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void activate(ComponentContext ctx) {
        BundleContext bundleContext = ctx.getBundleContext();
        for (Bundle bundle : bundleContext.getBundles()) {
            if (!bundle.getSymbolicName().equals("org.apache.sling.commons.fsclassloader")) continue;
            this.fileRoot = new File(this.slingSettingsService.getSlingHomePath(), "launchpad/felix/bundle" + bundle.getBundleId() + "/data/classes");
            break;
        }
    }

    protected void bindSlingSettingsService(SlingSettingsService slingSettingsService) {
        this.slingSettingsService = slingSettingsService;
    }

    protected void unbindSlingSettingsService(SlingSettingsService slingSettingsService) {
        if (this.slingSettingsService == slingSettingsService) {
            this.slingSettingsService = null;
        }
    }
}

