/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.tools.tag_maker.impl;

import com.adobe.acs.tools.tag_maker.TagData;
import com.adobe.acs.tools.tag_maker.tagdataconverters.TagDataConverter;
import com.day.cq.tagging.InvalidTagFormatException;
import com.day.cq.tagging.Tag;
import com.day.cq.tagging.TagConstants;
import com.day.cq.tagging.TagManager;
import com.day.text.csv.Csv;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagMakerServlet
extends SlingAllMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(TagMakerServlet.class);
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final String DEFAULT_CONVERTER = "Default (Normal AEM Node Naming)";
    private static final String NONE_CONVERTER = "__NONE";
    private static final boolean DEFAULT_CLEAN = true;
    private Map<String, TagDataConverter> tagDataConverters = new ConcurrentHashMap<String, TagDataConverter>();

    protected final void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding(DEFAULT_CHARSET);
        JSONArray jsonArray = new JSONArray();
        try {
            for (Map.Entry<String, TagDataConverter> entry : this.tagDataConverters.entrySet()) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("label", (Object)entry.getValue().getLabel());
                jsonObject.put("value", (Object)entry.getKey());
                jsonArray.put((Object)jsonObject);
            }
            response.getWriter().print(jsonArray.toString());
        }
        catch (JSONException e) {
            response.setStatus(500);
        }
    }

    protected final void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        TagDataConverter fallbackTagConverter;
        response.setContentType("application/json");
        response.setCharacterEncoding(DEFAULT_CHARSET);
        JSONObject jsonResponse = new JSONObject();
        TagManager tagManager = (TagManager)request.getResourceResolver().adaptTo(TagManager.class);
        RequestParameter charsetParam = request.getRequestParameter("charset");
        RequestParameter cleanParam = request.getRequestParameter("clean");
        RequestParameter delimiterParam = request.getRequestParameter("delimiter");
        RequestParameter fileParameter = request.getRequestParameter("file");
        RequestParameter separatorParam = request.getRequestParameter("separator");
        RequestParameter converterParam = request.getRequestParameter("converter");
        RequestParameter fallbackConverterParam = request.getRequestParameter("fallbackConverter");
        boolean clean = true;
        if (cleanParam != null) {
            clean = Boolean.valueOf(StringUtils.defaultIfEmpty((String)cleanParam.toString(), (String)String.valueOf(true)));
        }
        String converter = DEFAULT_CONVERTER;
        if (converterParam != null) {
            converter = StringUtils.defaultIfEmpty((String)converterParam.toString(), (String)DEFAULT_CONVERTER);
        }
        String fallbackConverter = NONE_CONVERTER;
        if (fallbackConverterParam != null) {
            fallbackConverter = StringUtils.defaultIfEmpty((String)fallbackConverterParam.toString(), (String)NONE_CONVERTER);
        }
        String charset = DEFAULT_CHARSET;
        if (charsetParam != null) {
            charset = StringUtils.defaultIfEmpty((String)charsetParam.toString(), (String)DEFAULT_CHARSET);
        }
        Character delimiter = null;
        if (delimiterParam != null && StringUtils.isNotBlank((String)delimiterParam.toString())) {
            delimiter = Character.valueOf(delimiterParam.toString().charAt(0));
        }
        Character separator = null;
        if (separatorParam != null && StringUtils.isNotBlank((String)separatorParam.toString())) {
            separator = Character.valueOf(separatorParam.toString().charAt(0));
        }
        ArrayList<TagDataConverter> tagDataConverters = new ArrayList<TagDataConverter>();
        TagDataConverter primaryTagConverter = this.getTagDataConverter(converter);
        if (primaryTagConverter != null) {
            tagDataConverters.add(primaryTagConverter);
        }
        if ((fallbackTagConverter = this.getTagDataConverter(fallbackConverter)) != null) {
            tagDataConverters.add(fallbackTagConverter);
        }
        if (tagDataConverters.isEmpty()) {
            log.error("Could not find Tag Data Converter [ {} ]", (Object)converter);
            response.setStatus(500);
        } else if (fileParameter != null && fileParameter.getInputStream() != null) {
            InputStream is = fileParameter.getInputStream();
            Csv csv = new Csv();
            if (delimiter != null) {
                log.debug("Setting Field Delimiter to [ {} ]", (Object)delimiter);
                csv.setFieldDelimiter(delimiter.charValue());
            }
            if (separator != null) {
                log.debug("Setting Field Separator to [ {} ]", (Object)separator);
                csv.setFieldSeparatorRead(separator.charValue());
            }
            if (clean) {
                is = this.stripLineEnds(is, charset, csv.getFieldSeparatorRead());
            }
            Iterator rows = csv.read(is, charset);
            try {
                ((Session)request.getResourceResolver().adaptTo(Session.class)).getWorkspace().getObservationManager().setUserData("acs-aem-tools.tag-maker");
                List<String> result = this.makeTags(tagManager, tagDataConverters, rows);
                try {
                    jsonResponse.put("tagIds", result);
                }
                catch (JSONException e) {
                    log.error("Could not serialized Tag Maker results into JSON", (Throwable)e);
                }
                this.addMessage(jsonResponse, result.size() + " tags were processed");
            }
            catch (InvalidTagFormatException e) {
                log.error("Could not create Tag due to illegal formatting", (Throwable)e);
                this.addMessage(jsonResponse, "Could not create tags due to illegal formatting");
                response.setStatus(500);
            }
            catch (RepositoryException e) {
                log.error("Could not save Tags to JCR", (Throwable)e);
                this.addMessage(jsonResponse, "Could not save tags");
                response.setStatus(500);
            }
        } else {
            log.error("Could not find CSV file in request.");
            this.addMessage(jsonResponse, "CSV file is missing");
            response.setStatus(500);
        }
        response.getWriter().print(jsonResponse.toString());
    }

    private List<String> makeTags(TagManager tagManager, List<TagDataConverter> tagDataConverters, Iterator<String[]> rows) throws InvalidTagFormatException, RepositoryException {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        block0: while (rows.hasNext()) {
            String[] row = rows.next();
            log.debug("Processing data from row {}", Arrays.asList(row));
            String tagId = null;
            for (int i = 0; i < row.length; ++i) {
                TagData tagData = null;
                String element = StringUtils.trimToNull((String)row[i]);
                if (element == null) {
                    log.warn("Element is null skipping this row [ {} ]", tagId);
                    continue block0;
                }
                for (TagDataConverter tagDataConverter : tagDataConverters) {
                    if (!tagDataConverter.accepts(element)) continue;
                    tagData = tagDataConverter.convert(element);
                    break;
                }
                if (tagData == null) {
                    log.warn("Could not find a Tag Data Converter that accepts CSV element [ {} ]; skipping...");
                    continue block0;
                }
                if (!tagData.isValid()) {
                    log.warn("Could not convert CSV element [ {} ] into valid Tag Data; skipping...");
                    continue block0;
                }
                tagId = i == 0 ? tagData.getName() + TagConstants.NAMESPACE_DELIMITER : (i == 1 ? tagId + tagData.getName() : tagId + "/" + tagData.getName());
                Tag tag = tagManager.createTag(tagId, tagData.getTitle(), tagData.getDescription());
                if (tagData.getLocalizedTitles() != null) {
                    Map<String, String> translationsMap = tagData.getLocalizedTitles();
                    Node node = (Node)tag.adaptTo(Node.class);
                    for (Map.Entry<String, String> entry : translationsMap.entrySet()) {
                        node.setProperty("jcr:title." + entry.getKey(), entry.getValue());
                    }
                    node.getSession().save();
                }
                log.trace("Created Tag [ {} ] with Title [ {} ]", (Object)tag.getTagID(), (Object)tagData.getTitle());
                result.add(tagId);
            }
        }
        if (tagManager.getSession().hasPendingChanges()) {
            long start = System.currentTimeMillis();
            tagManager.getSession().save();
            if (log.isInfoEnabled()) {
                log.info("Persisting tags to JCR in {} ms", (Object)(System.currentTimeMillis() - start));
            }
        }
        return new ArrayList<String>(result);
    }

    private InputStream stripLineEnds(InputStream is, String charset, char chartoStrip) throws IOException {
        log.debug("Stripping [ {} ] from the end of lines.", (Object)Character.valueOf(chartoStrip));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(baos);
        LineIterator lineIterator = IOUtils.lineIterator((InputStream)is, (String)charset);
        while (lineIterator.hasNext()) {
            String line = StringUtils.stripToNull((String)lineIterator.next());
            if (line == null) continue;
            line = StringUtils.stripEnd((String)line, (String)String.valueOf(chartoStrip));
            printStream.println(line);
        }
        return new ByteArrayInputStream(baos.toByteArray());
    }

    private TagDataConverter getTagDataConverter(String name) {
        if (StringUtils.isNotBlank((String)name)) {
            return this.tagDataConverters.get(name);
        }
        return null;
    }

    private void addMessage(JSONObject jsonObject, String message) {
        try {
            jsonObject.put("message", (Object)message);
        }
        catch (JSONException e) {
            log.error("Could not formulate JSON Response", (Throwable)e);
        }
    }

    protected final void bindTagDataConverter(TagDataConverter service, Map<Object, Object> props) {
        String type = PropertiesUtil.toString((Object)props.get("name"), null);
        if (type != null) {
            this.tagDataConverters.put(type, service);
        }
    }

    protected final void unbindTagDataConverter(TagDataConverter service, Map<Object, Object> props) {
        String type = PropertiesUtil.toString((Object)props.get("name"), null);
        if (type != null) {
            this.tagDataConverters.remove(type);
        }
    }
}

