/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.tools.tag_maker.tagdataconverters.impl;

import com.adobe.acs.tools.tag_maker.TagData;
import com.adobe.acs.tools.tag_maker.tagdataconverters.TagDataConverter;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class LocalizedTitleAndNodeNameConverterImpl
implements TagDataConverter {
    public static final String NAME = "acs-commons-localized-title-and-node-name";
    public static final String LABEL = "en[Title] fr[Titre] es[Titulo] {{ node-name }}";
    private static final Pattern ACCEPT_PATTERN = Pattern.compile("^\\s*([a-zA-Z_-]+\\[[^]]+\\]\\s+)+\\{\\{(.+)}}\\s*$");
    private static final Pattern NODE_NAME_PATTERN = Pattern.compile("\\{\\{(.+)}}\\s?$");
    private static final Pattern LOCALIZED_TITLES_PATTERN = Pattern.compile("([a-zA-Z_-]+)\\[([^]]+)\\]");
    private static final String DEFAULT_LOCALE_KEY = "default";

    @Override
    public final String getLabel() {
        return LABEL;
    }

    @Override
    public final TagData convert(String data) {
        data = StringUtils.stripToEmpty((String)data);
        TreeMap<String, String> localizedTitles = new TreeMap<String, String>();
        String title = "";
        Matcher matcher = NODE_NAME_PATTERN.matcher(data);
        if (!matcher.find() || matcher.groupCount() != 1) {
            return TagData.EMPTY;
        }
        String name = StringUtils.stripToEmpty((String)matcher.group(1));
        String rawLocalizedTitles = StringUtils.stripToEmpty((String)NODE_NAME_PATTERN.matcher(data).replaceAll(""));
        Matcher localeMatch = LOCALIZED_TITLES_PATTERN.matcher(rawLocalizedTitles);
        String firstLocale = null;
        while (localeMatch.find()) {
            String locale = StringUtils.stripToEmpty((String)localeMatch.group(1));
            String localeTitle = StringUtils.stripToEmpty((String)localeMatch.group(2));
            if (firstLocale == null) {
                firstLocale = locale;
            }
            if (DEFAULT_LOCALE_KEY.equals(locale)) {
                title = localeTitle;
                continue;
            }
            localizedTitles.put(locale, localeTitle);
        }
        if (StringUtils.isEmpty((String)title) && firstLocale != null) {
            title = (String)localizedTitles.get(firstLocale);
        }
        if (StringUtils.isEmpty((String)title)) {
            return TagData.EMPTY;
        }
        TagData tagData = new TagData(name);
        tagData.setTitle(title);
        tagData.setLocalizedTitles(localizedTitles);
        return tagData;
    }

    @Override
    public boolean accepts(String data) {
        Matcher matcher = ACCEPT_PATTERN.matcher(data);
        return matcher.matches();
    }
}

