/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.tools.tag_maker.tagdataconverters.impl;

import com.adobe.acs.tools.tag_maker.TagData;
import com.adobe.acs.tools.tag_maker.tagdataconverters.TagDataConverter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class TitleAndNodeNameConverterImpl
implements TagDataConverter {
    public static final String NAME = "acs-commons-title-and-node-name";
    public static final String LABEL = "Title {{ node-name }}";
    private static final Pattern ACCEPT_PATTERN = Pattern.compile(".+\\{\\{(.+)}}$");
    private static final Pattern PATTERN = Pattern.compile("\\{\\{(.+)}}$");

    @Override
    public final String getLabel() {
        return LABEL;
    }

    @Override
    public final TagData convert(String data) {
        Matcher matcher = PATTERN.matcher(data = StringUtils.stripToEmpty((String)data));
        if (!matcher.find() || matcher.groupCount() != 1) {
            return TagData.EMPTY;
        }
        String name = matcher.group(1);
        name = StringUtils.stripToEmpty((String)name);
        String title = PATTERN.matcher(data).replaceAll("");
        title = StringUtils.stripToEmpty((String)title);
        TagData tagData = new TagData(name);
        tagData.setTitle(title);
        return tagData;
    }

    @Override
    public boolean accepts(String data) {
        Matcher matcher = ACCEPT_PATTERN.matcher(data);
        return matcher.matches();
    }
}

