/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.tools.test_page_generator.impl;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Parameters {
    private static final Logger log = LoggerFactory.getLogger(Parameters.class);
    private static final int DEFAULT_SAVE_THRESHOLD = 1000;
    private static final int DEFAULT_BUCKET_SIZE = 100;
    private static final String DEFAULT_BUCKET_TYPE = "sling:Folder";
    private final String rootPath;
    private final String template;
    private final int total;
    private final int bucketSize;
    private final int saveThreshold;
    private final String bucketType;
    private final Map<String, Object> properties;

    public Parameters(SlingHttpServletRequest request) throws JSONException {
        String data = request.getParameter("json");
        JSONObject json = new JSONObject(data);
        this.rootPath = json.optString("rootPath", "");
        this.template = json.optString("template", "");
        this.total = json.optInt("total", 0);
        this.bucketSize = json.optInt("bucketSize", 100);
        this.bucketType = json.optString("bucketType", DEFAULT_BUCKET_TYPE);
        this.saveThreshold = json.optInt("saveThreshold", 1000);
        this.properties = new HashMap<String, Object>();
        JSONArray jsonArray = json.getJSONArray("properties");
        if (jsonArray != null) {
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject item = jsonArray.getJSONObject(i);
                boolean isMulti = item.optBoolean("multi", false);
                String name = item.optString("name", "");
                if (!StringUtils.isNotBlank((String)name)) continue;
                if (isMulti) {
                    ArrayList<String> values = new ArrayList<String>();
                    for (String value : StringUtils.split((String)item.optString("value", ""), (String)",")) {
                        String tmp = StringUtils.stripToNull((String)value);
                        if (tmp == null) continue;
                        values.add(value);
                    }
                    this.properties.put(name, values.toArray(new String[values.size()]));
                    continue;
                }
                String value = item.optString("value", "");
                this.properties.put(name, value);
            }
        }
    }

    public final String getRootPath() {
        if (!StringUtils.isBlank((String)this.rootPath)) {
            return this.rootPath;
        }
        return "/content/" + Long.toString(new Date().getTime());
    }

    public final String getTemplate() {
        return this.template;
    }

    public final int getTotal() {
        if (this.total > 0) {
            return this.total;
        }
        return 0;
    }

    public final int getBucketSize() {
        if (this.bucketSize > 0) {
            return this.bucketSize;
        }
        return 100;
    }

    public final String getBucketType() {
        return StringUtils.defaultIfEmpty((String)this.bucketType, (String)DEFAULT_BUCKET_TYPE);
    }

    public final int getSaveThreshold() {
        if (this.saveThreshold > 0) {
            return this.saveThreshold;
        }
        return 1000;
    }

    public final Map<String, Object> getProperties() {
        return this.properties;
    }

    public final String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("Template: " + this.getTemplate());
        printWriter.println("Total Pages to Create: " + this.getTotal());
        printWriter.println("Bucket Size: " + this.getBucketSize());
        printWriter.println("Bucket Type: " + this.getBucketType());
        printWriter.println("Save Threshold: " + this.getSaveThreshold());
        return printWriter.toString();
    }
}

