/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.tools.test_page_generator.impl;

import com.adobe.acs.tools.test_page_generator.impl.Parameters;
import com.day.cq.commons.jcr.JcrUtil;
import com.day.cq.wcm.api.Page;
import com.day.cq.wcm.api.PageManager;
import com.day.cq.wcm.api.Template;
import com.day.cq.wcm.api.WCMException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.servlet.ServletException;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestPageGeneratorServlet
extends SlingAllMethodsServlet {
    private static final Logger log = LoggerFactory.getLogger(TestPageGeneratorServlet.class);
    private ScriptEngineManager scriptEngineManager;
    private static final int MILLIS_IN_SECONDS = 1000;
    private static final String NT_SLING_FOLDER = "sling:Folder";
    private static final String NODE_PREFIX = "test-page-";
    private static final String TITLE_PREFIX = "Test Page ";

    protected final void doPost(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        try {
            ((Session)request.getResourceResolver().adaptTo(Session.class)).getWorkspace().getObservationManager().setUserData("acs-aem-tools.test-page-generator");
            JSONObject json = this.generatePages(request.getResourceResolver(), new Parameters(request));
            response.getWriter().write(json.toString(2));
        }
        catch (JSONException e) {
            log.error(e.getMessage());
            this.sendJSONError(response, "Form errors", "Could not understand provided parameters");
        }
        catch (RepositoryException e) {
            log.error("Could not perform interim Save due to: {}", (Object)e.getMessage());
            this.sendJSONError(response, "Repository error", e.getMessage());
        }
        catch (WCMException e) {
            log.error("Could not create Page due to: {}", (Object)e.getMessage());
            this.sendJSONError(response, "WCM Page creation error", e.getMessage());
        }
        catch (IllegalArgumentException e) {
            log.error("Could not store JavaScript eval result into repository: {}", (Object)e.getMessage());
            this.sendJSONError(response, "JavaScript-based property evaluation error", e.getMessage());
        }
    }

    private JSONObject generatePages(ResourceResolver resourceResolver, Parameters parameters) throws IOException, WCMException, RepositoryException, JSONException {
        ScriptEngine scriptEngine = this.scriptEngineManager.getEngineByExtension("ecma");
        JSONObject jsonResponse = new JSONObject();
        int pageCount = parameters.getTotal();
        int bucketSize = parameters.getBucketSize();
        int saveThreshold = parameters.getSaveThreshold();
        String rootPath = parameters.getRootPath();
        Session session = (Session)resourceResolver.adaptTo(Session.class);
        int[] depthTracker = this.initDepthTracker(pageCount, bucketSize);
        int i = 0;
        int bucketCount = 0;
        long start = System.currentTimeMillis();
        while (i++ < pageCount) {
            depthTracker = this.updateDepthTracker(depthTracker, bucketCount, bucketSize);
            if (this.needsNewBucket(bucketCount, bucketSize)) {
                bucketCount = 0;
            }
            String folderPath = this.getOrCreateBucketPath(resourceResolver, parameters, rootPath, depthTracker);
            Page page = this.createPage(resourceResolver, folderPath, NODE_PREFIX + (i + 1), parameters.getTemplate(), TITLE_PREFIX + (i + 1));
            ModifiableValueMap properties = (ModifiableValueMap)page.getContentResource().adaptTo(ModifiableValueMap.class);
            for (Map.Entry<String, Object> entry : parameters.getProperties().entrySet()) {
                properties.put((Object)entry.getKey(), this.eval(scriptEngine, entry.getValue()));
            }
            ++bucketCount;
            if (i % saveThreshold != 0) continue;
            log.debug("Saving at threshold for [ {} ] items", (Object)i);
            this.save(session);
        }
        if (saveThreshold % i != 0) {
            this.save(session);
        }
        jsonResponse.put("totalTime", (int)((System.currentTimeMillis() - start) / 1000L));
        jsonResponse.put("rootPath", (Object)rootPath);
        jsonResponse.put("bucketSize", bucketSize);
        jsonResponse.put("saveThreshold", saveThreshold);
        jsonResponse.put("depth", depthTracker.length);
        jsonResponse.put("count", pageCount);
        jsonResponse.put("success", true);
        return jsonResponse;
    }

    private void sendJSONError(SlingHttpServletResponse response, String title, String message) throws IOException {
        JSONObject json = new JSONObject();
        response.setStatus(500);
        try {
            json.put("title", (Object)title);
            json.put("message", (Object)message);
            response.getWriter().write(json.toString());
        }
        catch (JSONException e) {
            String fallbackJSON = "{ \"title\": \"Error creating error response. Please review AEM error logs.\" }";
            response.getWriter().write(fallbackJSON);
        }
    }

    private long save(Session session) throws RepositoryException {
        long start = System.currentTimeMillis();
        session.save();
        long total = System.currentTimeMillis() - start;
        log.debug("Save operation for batch page creation took {} ms", (Object)total);
        return total;
    }

    private boolean needsNewBucket(int bucketCount, int bucketSize) {
        return bucketCount >= bucketSize;
    }

    private String getOrCreateBucketPath(ResourceResolver resourceResolver, Parameters params, String rootPath, int[] depthTracker) throws RepositoryException {
        Node node;
        Session session = (Session)resourceResolver.adaptTo(Session.class);
        String folderPath = rootPath;
        for (int i = 0; i < depthTracker.length; ++i) {
            String tmp = Integer.toString(depthTracker[i] + 1);
            folderPath = folderPath + "/" + tmp;
        }
        if (resourceResolver.getResource(folderPath) != null) {
            return folderPath;
        }
        if (StringUtils.equals((String)NT_SLING_FOLDER, (String)params.getBucketType())) {
            node = JcrUtil.createPath((String)folderPath, (String)NT_SLING_FOLDER, (String)NT_SLING_FOLDER, (Session)session, (boolean)false);
            JcrUtil.createPath((String)(folderPath + "/jcr:content"), (String)"cq:Page", (String)"nt:unstructured", (Session)session, (boolean)false);
            log.debug("Created new folder path at [ {} ]", (Object)node.getPath());
        } else {
            node = JcrUtil.createPath((String)folderPath, (String)"cq:Page", (String)"cq:Page", (Session)session, (boolean)false);
            JcrUtil.createPath((String)(folderPath + "/jcr:content"), (String)"cq:Page", (String)"cq:PageContent", (Session)session, (boolean)false);
        }
        return node.getPath();
    }

    private int[] initDepthTracker(int total, int bucketSize) {
        int depth = this.getDepth(total, bucketSize);
        int[] depthTracker = new int[depth];
        for (int i = 0; i < depthTracker.length; ++i) {
            depthTracker[i] = 0;
        }
        return depthTracker;
    }

    private int[] updateDepthTracker(int[] depthTracker, int bucketCount, int bucketSize) {
        if (!this.needsNewBucket(bucketCount, bucketSize)) {
            return depthTracker;
        }
        for (int i = depthTracker.length - 1; i >= 0; --i) {
            if (depthTracker[i] < bucketSize - 1) {
                depthTracker[i] = depthTracker[i] + 1;
                log.debug("Updating depthTracker at location [ {} ] to [ {} ]", (Object)i, (Object)depthTracker[i]);
                break;
            }
            depthTracker[i] = 0;
        }
        return depthTracker;
    }

    private int getDepth(int total, int bucketSize) {
        int depth = 0;
        int remainingSize = total;
        do {
            remainingSize = (int)Math.ceil((double)remainingSize / (double)bucketSize);
            log.debug("Remaining size of [ {} ] at depth [ {} ]", (Object)remainingSize, (Object)depth);
            ++depth;
        } while (remainingSize > bucketSize);
        log.debug("Final depth of [ {} ]", (Object)depth);
        return depth;
    }

    private Page createPage(ResourceResolver resourceResolver, String folderPath, String nodeName, String templatePath, String title) throws RepositoryException, WCMException {
        PageManager pageManager = (PageManager)resourceResolver.adaptTo(PageManager.class);
        Template template = pageManager.getTemplate(templatePath);
        if (template != null) {
            return pageManager.create(folderPath, nodeName, templatePath, title, false);
        }
        Session session = (Session)resourceResolver.adaptTo(Session.class);
        Node folderNode = session.getNode(folderPath);
        nodeName = JcrUtil.createValidName((String)nodeName);
        Node pageNode = JcrUtil.createUniqueNode((Node)folderNode, (String)nodeName, (String)"cq:Page", (Session)session);
        Node contentNode = JcrUtil.createUniqueNode((Node)pageNode, (String)"jcr:content", (String)"cq:PageContent", (Session)session);
        JcrUtil.setProperty((Node)contentNode, (String)"jcr:title", (Object)title);
        return (Page)resourceResolver.getResource(pageNode.getPath()).adaptTo(Page.class);
    }

    private Object eval(ScriptEngine scriptEngine, Object value) {
        if (scriptEngine == null) {
            log.warn("ScriptEngine is null; cannot evaluate");
            return value;
        }
        if (value instanceof String[]) {
            String[] values;
            ArrayList<String> scripts = new ArrayList<String>();
            for (String val : values = (String[])value) {
                scripts.add(String.valueOf(this.eval(scriptEngine, val)));
            }
            return scripts.toArray(new String[scripts.size()]);
        }
        if (!(value instanceof String)) {
            return value;
        }
        String stringValue = StringUtils.stripToEmpty((String)((String)value));
        if (StringUtils.startsWith((String)stringValue, (String)"{{") && StringUtils.endsWith((String)stringValue, (String)"}}")) {
            String script = StringUtils.removeStart((String)stringValue, (String)"{{");
            script = StringUtils.removeEnd((String)script, (String)"}}");
            script = StringUtils.stripToEmpty((String)script);
            try {
                return scriptEngine.eval(script);
            }
            catch (ScriptException e) {
                log.error("Could not evaluation the test page property ecma [ {} ]", (Object)script);
            }
        }
        return value;
    }

    protected void bindScriptEngineManager(ScriptEngineManager scriptEngineManager) {
        this.scriptEngineManager = scriptEngineManager;
    }

    protected void unbindScriptEngineManager(ScriptEngineManager scriptEngineManager) {
        if (this.scriptEngineManager == scriptEngineManager) {
            this.scriptEngineManager = null;
        }
    }
}

