/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.acs.tools.wcm.debug;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.osgi.PropertiesUtil;

public class SlingComponentDebugFilter
implements Filter {
    public static final String IS_ENABLED = "isEnabled";
    private boolean isEnabled;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        SlingHttpServletResponse slingResponse = (SlingHttpServletResponse)response;
        SlingHttpServletRequest slingRequest = (SlingHttpServletRequest)request;
        Resource resource = slingRequest.getResource();
        if (this.canDebugRequest(slingRequest)) {
            this.filterResponse(slingRequest, slingResponse, resource, filterChain);
        } else {
            filterChain.doFilter((ServletRequest)slingRequest, response);
        }
    }

    private boolean canDebugRequest(SlingHttpServletRequest request) {
        boolean canDebugRequest = false;
        String path = request.getPathInfo();
        if (this.isEnabled && path.contains(".html")) {
            canDebugRequest = true;
        }
        return canDebugRequest;
    }

    private void filterResponse(SlingHttpServletRequest slingRequest, SlingHttpServletResponse slingResponse, Resource resource, FilterChain chain) throws IOException, ServletException {
        PrintWriter out = slingResponse.getWriter();
        CharResponseWrapper responseWrapper = new CharResponseWrapper((HttpServletResponse)slingResponse);
        chain.doFilter((ServletRequest)slingRequest, (ServletResponse)responseWrapper);
        StringBuilder servletResponse = new StringBuilder(responseWrapper.toString());
        if (!servletResponse.toString().contains("acs:resourcePath")) {
            servletResponse.append("<!-- {acs:resourcePath:" + resource.getPath() + "-->");
            out.write(servletResponse.toString());
        } else {
            out.write(servletResponse.toString());
        }
    }

    protected void activate(Map<String, String> properties) {
        this.isEnabled = PropertiesUtil.toBoolean((Object)properties.get(IS_ENABLED), (boolean)false);
    }

    public void destroy() {
    }

    public class CharResponseWrapper
    extends HttpServletResponseWrapper {
        private CharArrayWriter output;

        public String toString() {
            return this.output.toString();
        }

        public CharResponseWrapper(HttpServletResponse response) {
            super(response);
            this.output = new CharArrayWriter();
        }

        public PrintWriter getWriter() {
            return new PrintWriter(this.output);
        }
    }
}

