/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.backup;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.segment.Compactor;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNodeBuilder;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.plugins.segment.file.FileStore;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileStoreBackup {
    private static final Logger log = LoggerFactory.getLogger(FileStoreBackup.class);
    private static final long DEFAULT_LIFETIME = TimeUnit.HOURS.toMillis(1L);
    static int MAX_FILE_SIZE = 256;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void backup(NodeStore store, File destination) throws IOException {
        long s = System.currentTimeMillis();
        String checkpoint = store.checkpoint(DEFAULT_LIFETIME);
        NodeState current = store.retrieve(checkpoint);
        if (current == null) {
            current = store.getRoot();
        }
        FileStore backup = new FileStore(destination, MAX_FILE_SIZE, false);
        try {
            SegmentNodeState state = backup.getHead();
            NodeState before = null;
            String beforeCheckpoint = state.getString("checkpoint");
            if (beforeCheckpoint == null) {
                before = EmptyNodeState.EMPTY_NODE;
            } else {
                before = store.retrieve(beforeCheckpoint);
                if (before == null) {
                    before = state.getChildNode("root");
                }
            }
            Compactor compactor = new Compactor(backup.getTracker().getWriter());
            SegmentNodeState after = compactor.compact(before, current);
            SegmentNodeBuilder builder = state.builder();
            builder.setProperty("checkpoint", checkpoint);
            builder.setChildNode("root", after);
            backup.setHead(state, builder.getNodeState());
        }
        finally {
            backup.close();
        }
        log.debug("Backup finished in {} ms.", (Object)(System.currentTimeMillis() - s));
    }
}

