/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import com.google.common.primitives.Ints;
import java.util.Arrays;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.lucene.FieldNames;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.IntField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.FieldInfo;

public final class FieldFactory {
    private static final FieldType OAK_TYPE = new FieldType();
    private static final FieldType OAK_TYPE_NOT_STORED = new FieldType();
    private static final int[] TYPABLE_TAGS = new int[]{Type.DATE.tag(), Type.BOOLEAN.tag(), Type.DOUBLE.tag(), Type.LONG.tag()};

    public static boolean canCreateTypedField(Type<?> type) {
        return Ints.contains((int[])TYPABLE_TAGS, (int)type.tag());
    }

    private FieldFactory() {
    }

    public static Field newPathField(String path) {
        return new StringField(":path", path, Field.Store.YES);
    }

    public static Field newPropertyField(String name, String value, boolean tokenized, boolean stored) {
        if (tokenized) {
            return new OakTextField(name, value, stored);
        }
        return new StringField(name, value, Field.Store.NO);
    }

    public static Field newFulltextField(String value) {
        return new TextField(":fulltext", value, Field.Store.NO);
    }

    public static Field newFulltextField(String name, String value) {
        return new TextField(FieldNames.createFulltextFieldName(name), value, Field.Store.NO);
    }

    public static Field newAncestorsField(String path) {
        return new TextField(":ancestors", path, Field.Store.NO);
    }

    public static Field newDepthField(String path) {
        return new IntField(":depth", PathUtils.getDepth(path), Field.Store.NO);
    }

    public static Long dateToLong(String date) {
        if (date == null) {
            return null;
        }
        return ISO8601.parse(date).getTimeInMillis();
    }

    static {
        OAK_TYPE.setIndexed(true);
        OAK_TYPE.setOmitNorms(true);
        OAK_TYPE.setStored(true);
        OAK_TYPE.setIndexOptions(FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
        OAK_TYPE.setTokenized(true);
        OAK_TYPE.freeze();
        OAK_TYPE_NOT_STORED.setIndexed(true);
        OAK_TYPE_NOT_STORED.setOmitNorms(true);
        OAK_TYPE_NOT_STORED.setStored(false);
        OAK_TYPE_NOT_STORED.setIndexOptions(FieldInfo.IndexOptions.DOCS_AND_FREQS_AND_POSITIONS);
        OAK_TYPE_NOT_STORED.setTokenized(true);
        OAK_TYPE_NOT_STORED.freeze();
        Arrays.sort(TYPABLE_TAGS);
    }

    private static final class OakTextField
    extends Field {
        public OakTextField(String name, String value, boolean stored) {
            super(name, value, stored ? OAK_TYPE : OAK_TYPE_NOT_STORED);
        }
    }
}

