/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.hash.Hashing;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.commons.io.FileUtils;
import org.apache.jackrabbit.oak.commons.IOUtils;
import org.apache.jackrabbit.oak.plugins.index.lucene.CopyOnReadStatsMBean;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexDefinition;
import org.apache.lucene.store.BaseDirectory;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IndexCopier
implements CopyOnReadStatsMBean {
    private static final Set<String> REMOTE_ONLY = ImmutableSet.of((Object)"segments.gen");
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Executor executor;
    private final File indexRootDir;
    private final AtomicInteger localReadCount = new AtomicInteger();
    private final AtomicInteger remoteReadCount = new AtomicInteger();
    private final AtomicInteger invalidFileCount = new AtomicInteger();
    private final AtomicLong downloadSize = new AtomicLong();
    private final AtomicLong downloadTime = new AtomicLong();
    private final Map<String, String> indexPathMapping = Maps.newConcurrentMap();
    private final Map<String, String> indexPathVersionMapping = Maps.newConcurrentMap();

    public IndexCopier(Executor executor, File indexRootDir) {
        this.executor = executor;
        this.indexRootDir = indexRootDir;
    }

    public Directory wrap(String indexPath, IndexDefinition definition, Directory remote) throws IOException {
        Directory local = this.createLocalDir(indexPath, definition);
        return new CopyOnReadDirectory(remote, local);
    }

    protected Directory createLocalDir(String indexPath, IndexDefinition definition) throws IOException {
        String newVersion;
        File indexDir = this.getIndexDir(indexPath);
        File versionedIndexDir = new File(indexDir, newVersion = String.valueOf(definition.getReindexCount()));
        if (!versionedIndexDir.exists()) {
            Preconditions.checkState((boolean)versionedIndexDir.mkdirs(), (String)"Cannot create directory %s", (Object[])new Object[]{versionedIndexDir});
        }
        this.indexPathMapping.put(indexPath, indexDir.getAbsolutePath());
        Object result = FSDirectory.open((File)versionedIndexDir);
        String oldVersion = this.indexPathVersionMapping.put(indexPath, newVersion);
        if (!newVersion.equals(oldVersion) && oldVersion != null) {
            result = new DeleteOldDirOnClose((Directory)result, new File(indexDir, oldVersion));
        }
        return result;
    }

    public File getIndexDir(String indexPath) {
        String subDir = Hashing.sha256().hashString((CharSequence)indexPath, Charsets.UTF_8).toString();
        return new File(this.indexRootDir, subDir);
    }

    @Override
    public TabularData getIndexPathMapping() {
        TabularDataSupport tds;
        try {
            TabularType tt = new TabularType(IndexMappingData.class.getName(), "Lucene Index Stats", IndexMappingData.TYPE, new String[]{"jcrPath"});
            tds = new TabularDataSupport(tt);
            for (Map.Entry<String, String> e : this.indexPathMapping.entrySet()) {
                tds.put(new CompositeDataSupport(IndexMappingData.TYPE, IndexMappingData.FIELD_NAMES, new String[]{e.getKey(), e.getValue()}));
            }
        }
        catch (OpenDataException e) {
            throw new IllegalStateException(e);
        }
        return tds;
    }

    @Override
    public int getLocalReadCount() {
        return this.localReadCount.get();
    }

    @Override
    public int getRemoteReadCount() {
        return this.remoteReadCount.get();
    }

    public int getInvalidFileCount() {
        return this.invalidFileCount.get();
    }

    @Override
    public String getDownloadSize() {
        return IOUtils.humanReadableByteCount(this.downloadSize.get());
    }

    @Override
    public long getDownloadTime() {
        return this.downloadTime.get();
    }

    @Override
    public String getLocalIndexSize() {
        return IOUtils.humanReadableByteCount(FileUtils.sizeOfDirectory((File)this.indexRootDir));
    }

    private static class IndexMappingData {
        static final String[] FIELD_NAMES = new String[]{"jcrPath", "fsPath"};
        static final String[] FIELD_DESCRIPTIONS = new String[]{"JCR Path", "Filesystem Path"};
        static final OpenType[] FIELD_TYPES = new OpenType[]{SimpleType.STRING, SimpleType.STRING};
        static final CompositeType TYPE = IndexMappingData.createCompositeType();

        private IndexMappingData() {
        }

        static CompositeType createCompositeType() {
            try {
                return new CompositeType(IndexMappingData.class.getName(), "Composite data type for Index Mapping Data", FIELD_NAMES, FIELD_DESCRIPTIONS, FIELD_TYPES);
            }
            catch (OpenDataException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private class DeleteOldDirOnClose
    extends FilterDirectory {
        private final File oldIndexDir;

        protected DeleteOldDirOnClose(Directory in, File oldIndexDir) {
            super(in);
            this.oldIndexDir = oldIndexDir;
        }

        public void close() throws IOException {
            try {
                FileUtils.deleteDirectory((File)this.oldIndexDir);
                IndexCopier.this.log.debug("Removed old index content from {} ", (Object)this.oldIndexDir);
            }
            catch (IOException e) {
                IndexCopier.this.log.warn("Not able to remove old version of copied index at {}", (Object)this.oldIndexDir, (Object)e);
            }
            super.close();
        }
    }

    private class CopyOnReadDirectory
    extends BaseDirectory {
        private final Directory remote;
        private final Directory local;
        private final ConcurrentMap<String, FileReference> files = Maps.newConcurrentMap();

        public CopyOnReadDirectory(Directory remote, Directory local) throws IOException {
            this.remote = remote;
            this.local = local;
        }

        public String[] listAll() throws IOException {
            return this.remote.listAll();
        }

        public boolean fileExists(String name) throws IOException {
            return this.remote.fileExists(name);
        }

        public void deleteFile(String name) throws IOException {
            throw new UnsupportedOperationException("Cannot delete in a ReadOnly directory");
        }

        public long fileLength(String name) throws IOException {
            return this.remote.fileLength(name);
        }

        public IndexOutput createOutput(String name, IOContext context) throws IOException {
            throw new UnsupportedOperationException("Cannot write in a ReadOnly directory");
        }

        public void sync(Collection<String> names) throws IOException {
            this.remote.sync(names);
        }

        public IndexInput openInput(String name, IOContext context) throws IOException {
            if (REMOTE_ONLY.contains(name)) {
                return this.remote.openInput(name, context);
            }
            FileReference ref = (FileReference)this.files.get(name);
            if (ref != null) {
                if (ref.isLocalValid()) {
                    return ((FileReference)this.files.get(name)).openLocalInput(context);
                }
                IndexCopier.this.remoteReadCount.incrementAndGet();
                return this.remote.openInput(name, context);
            }
            FileReference toPut = new FileReference(name);
            FileReference old = this.files.putIfAbsent(name, toPut);
            if (old == null) {
                this.copy(toPut);
            }
            if (toPut.isLocalValid()) {
                return toPut.openLocalInput(context);
            }
            return this.remote.openInput(name, context);
        }

        private void copy(final FileReference reference) {
            IndexCopier.this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    String name = reference.name;
                    try {
                        if (!CopyOnReadDirectory.this.local.fileExists(name)) {
                            long start = System.currentTimeMillis();
                            CopyOnReadDirectory.this.remote.copy(CopyOnReadDirectory.this.local, name, name, IOContext.READ);
                            reference.markValid();
                            IndexCopier.this.downloadTime.addAndGet(System.currentTimeMillis() - start);
                            IndexCopier.this.downloadSize.addAndGet(CopyOnReadDirectory.this.remote.fileLength(name));
                        } else {
                            long remoteLength;
                            long localLength = CopyOnReadDirectory.this.local.fileLength(name);
                            if (localLength != (remoteLength = CopyOnReadDirectory.this.remote.fileLength(name))) {
                                IndexCopier.this.log.warn("Found local copy for {} in {} but size of local {} differs from remote {}. Content would be read from remote file only", new Object[]{name, CopyOnReadDirectory.this.local, localLength, remoteLength});
                                IndexCopier.this.invalidFileCount.incrementAndGet();
                            } else {
                                reference.markValid();
                            }
                        }
                    }
                    catch (IOException e) {
                        IndexCopier.this.log.warn("Error occurred while copying file [{}] from {} to {}", new Object[]{name, CopyOnReadDirectory.this.remote, CopyOnReadDirectory.this.local, e});
                    }
                }
            });
        }

        public void close() throws IOException {
            IndexCopier.this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        CopyOnReadDirectory.this.removeDeletedFiles();
                    }
                    catch (IOException e) {
                        IndexCopier.this.log.warn("Error occurred while removing deleted files from Local {}, Remote {}", new Object[]{CopyOnReadDirectory.this.local, CopyOnReadDirectory.this.remote, e});
                    }
                    try {
                        CopyOnReadDirectory.this.local.close();
                        CopyOnReadDirectory.this.remote.close();
                    }
                    catch (IOException e) {
                        IndexCopier.this.log.warn("Error occurred while closing directory ", (Throwable)e);
                    }
                }
            });
        }

        private void removeDeletedFiles() throws IOException {
            Sets.SetView filesToBeDeleted = Sets.difference((Set)ImmutableSet.copyOf((Object[])this.local.listAll()), (Set)ImmutableSet.copyOf((Object[])this.remote.listAll()));
            for (String fileName : filesToBeDeleted) {
                this.local.deleteFile(fileName);
            }
            if (!filesToBeDeleted.isEmpty()) {
                IndexCopier.this.log.debug("Following files have been removed from Lucene index directory [{}]", (Object)filesToBeDeleted);
            }
        }

        private class FileReference {
            final String name;
            private volatile boolean valid;

            private FileReference(String name) {
                this.name = name;
            }

            boolean isLocalValid() {
                return this.valid;
            }

            IndexInput openLocalInput(IOContext context) throws IOException {
                IndexCopier.this.localReadCount.incrementAndGet();
                return CopyOnReadDirectory.this.local.openInput(this.name, context);
            }

            void markValid() {
                this.valid = true;
            }
        }
    }
}

