/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeTypeIterator;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.index.lucene.Aggregate;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexFormatVersion;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexConstants;
import org.apache.jackrabbit.oak.plugins.index.lucene.OakCodec;
import org.apache.jackrabbit.oak.plugins.index.lucene.PropertyDefinition;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.ConfigUtil;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.TokenizerChain;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.PropertyStates;
import org.apache.jackrabbit.oak.plugins.nodetype.ReadOnlyNodeTypeManager;
import org.apache.jackrabbit.oak.plugins.tree.ImmutableTree;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.util.TreeUtil;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import org.apache.lucene.analysis.path.PathHierarchyTokenizerFactory;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.codecs.Codec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IndexDefinition
implements Aggregate.AggregateMapper {
    private static final Logger log = LoggerFactory.getLogger(IndexDefinition.class);
    static final int DEFAULT_BLOB_SIZE = 1047552;
    static final long DEFAULT_ENTRY_COUNT = 1000L;
    static final String INDEX_VERSION = ":version";
    private static String TYPES_ALLOW_ALL_NAME = "all";
    static final int TYPES_ALLOW_NONE = 0;
    static final int TYPES_ALLOW_ALL = -1;
    static final QueryIndex.OrderEntry NATIVE_SORT_ORDER = new QueryIndex.OrderEntry("jcr:score", Type.UNDEFINED, QueryIndex.OrderEntry.Order.DESCENDING);
    private final boolean fullTextEnabled;
    private final NodeState definition;
    private final NodeState root;
    private final String funcName;
    private final int blobSize;
    private final Codec codec;
    private final long entryCount;
    private final boolean entryCountDefined;
    private final double costPerEntry;
    private final double costPerExecution;
    private final Map<String, List<IndexingRule>> indexRules;
    private final List<IndexingRule> definedRules;
    private final String indexName;
    private final boolean testMode;
    private final boolean evaluatePathRestrictions;
    private final IndexFormatVersion version;
    private final Map<String, Aggregate> aggregates;
    private final boolean indexesAllTypes;
    private final Analyzer analyzer;
    private final boolean hasCustomTikaConfig;

    public IndexDefinition(NodeState root, NodeState defn) {
        this(root, defn, null);
    }

    public IndexDefinition(NodeState root, NodeBuilder defn) {
        this(root, defn.getBaseState(), defn, null);
    }

    public IndexDefinition(NodeState root, NodeState defn, @Nullable String indexPath) {
        this(root, defn, null, indexPath);
    }

    public IndexDefinition(NodeState root, NodeState defn, @Nullable NodeBuilder defnb, @Nullable String indexPath) {
        this.root = root;
        this.version = IndexDefinition.determineIndexFormatVersion(defn, defnb);
        this.definition = defn;
        this.indexName = IndexDefinition.determineIndexName(defn, indexPath);
        this.blobSize = ConfigUtil.getOptionalValue(defn, "blobSize", 1047552);
        this.testMode = ConfigUtil.getOptionalValue(defn, "testMode", false);
        this.aggregates = this.collectAggregates(defn);
        NodeState rulesState = defn.getChildNode("indexRules");
        if (!rulesState.exists()) {
            rulesState = IndexDefinition.createIndexRules(defn).getNodeState();
        }
        ArrayList definedIndexRules = Lists.newArrayList();
        this.indexRules = this.collectIndexRules(rulesState, definedIndexRules);
        this.definedRules = ImmutableList.copyOf((Collection)definedIndexRules);
        this.fullTextEnabled = IndexDefinition.hasFulltextEnabledIndexRule(definedIndexRules);
        this.evaluatePathRestrictions = ConfigUtil.getOptionalValue(defn, "evaluatePathRestrictions", false);
        String functionName = ConfigUtil.getOptionalValue(defn, "functionName", null);
        if (this.fullTextEnabled && functionName == null) {
            functionName = "lucene";
        }
        this.funcName = functionName != null ? "native*" + functionName : null;
        this.codec = this.createCodec();
        if (defn.hasProperty("entryCount")) {
            this.entryCountDefined = true;
            this.entryCount = defn.getProperty("entryCount").getValue(Type.LONG);
        } else {
            this.entryCountDefined = false;
            this.entryCount = 1000L;
        }
        this.costPerEntry = ConfigUtil.getOptionalValue(defn, "costPerEntry", 1.0);
        this.costPerExecution = ConfigUtil.getOptionalValue(defn, "costPerExecution", 1.0);
        this.indexesAllTypes = this.areAllTypesIndexed();
        this.analyzer = this.createAnalyzer();
        this.hasCustomTikaConfig = this.getTikaConfigNode().exists();
    }

    public boolean isFullTextEnabled() {
        return this.fullTextEnabled;
    }

    public String getFunctionName() {
        return this.funcName;
    }

    public boolean hasFunctionDefined() {
        return this.funcName != null;
    }

    public int getBlobSize() {
        return this.blobSize;
    }

    public Codec getCodec() {
        return this.codec;
    }

    public long getReindexCount() {
        if (this.definition.hasProperty("reindexCount")) {
            return this.definition.getProperty("reindexCount").getValue(Type.LONG);
        }
        return 0L;
    }

    public long getEntryCount() {
        return this.entryCount;
    }

    public boolean isEntryCountDefined() {
        return this.entryCountDefined;
    }

    public double getCostPerEntry() {
        return this.costPerEntry;
    }

    public double getCostPerExecution() {
        return this.costPerExecution;
    }

    public long getFulltextEntryCount(long numOfDocs) {
        if (this.isEntryCountDefined()) {
            return Math.min(this.getEntryCount(), numOfDocs);
        }
        return numOfDocs;
    }

    public IndexFormatVersion getVersion() {
        return this.version;
    }

    public boolean isOfOldFormat() {
        return !IndexDefinition.hasIndexingRules(this.definition);
    }

    public boolean isTestMode() {
        return this.testMode;
    }

    public boolean evaluatePathRestrictions() {
        return this.evaluatePathRestrictions;
    }

    public boolean indexesAllTypes() {
        return this.indexesAllTypes;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    public boolean hasCustomTikaConfig() {
        return this.hasCustomTikaConfig;
    }

    public InputStream getTikaConfig() {
        return ConfigUtil.getBlob(this.getTikaConfigNode(), "config.xml").getNewStream();
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String toString() {
        return "Lucene Index : " + this.indexName;
    }

    private Analyzer createAnalyzer() {
        if (!this.evaluatePathRestrictions()) {
            return LuceneIndexConstants.ANALYZER;
        }
        ImmutableMap analyzerMap = ImmutableMap.builder().put((Object)":ancestors", (Object)new TokenizerChain((TokenizerFactory)new PathHierarchyTokenizerFactory(Collections.emptyMap()))).build();
        return new PerFieldAnalyzerWrapper(LuceneIndexConstants.ANALYZER, (Map)analyzerMap);
    }

    @Override
    @CheckForNull
    public Aggregate getAggregate(String nodeType) {
        Aggregate agg = this.aggregates.get(nodeType);
        return agg != null ? agg : null;
    }

    private Map<String, Aggregate> collectAggregates(NodeState defn) {
        HashMap aggregateMap = Maps.newHashMap();
        for (ChildNodeEntry childNodeEntry : defn.getChildNode("aggregates").getChildNodeEntries()) {
            String nodeType = childNodeEntry.getName();
            int recursionLimit = ConfigUtil.getOptionalValue(childNodeEntry.getNodeState(), "reaggregateLimit", 5);
            ArrayList includes = Lists.newArrayList();
            for (ChildNodeEntry childNodeEntry2 : childNodeEntry.getNodeState().getChildNodeEntries()) {
                NodeState is = childNodeEntry2.getNodeState();
                String primaryType = is.getString("primaryType");
                String path = is.getString("path");
                boolean relativeNode = ConfigUtil.getOptionalValue(is, "relativeNode", false);
                if (path == null) {
                    log.warn("Aggregate pattern in {} does not have required property [{}]. {} aggregate rule would be ignored", new Object[]{this, "path", childNodeEntry2.getName()});
                    continue;
                }
                includes.add(new Aggregate.NodeInclude(this, primaryType, path, relativeNode));
            }
            aggregateMap.put(nodeType, new Aggregate(nodeType, includes, recursionLimit));
        }
        return ImmutableMap.copyOf((Map)aggregateMap);
    }

    public List<IndexingRule> getDefinedRules() {
        return this.definedRules;
    }

    @CheckForNull
    public IndexingRule getApplicableIndexingRule(String primaryNodeType) {
        ArrayList<IndexingRule> rules = null;
        List<IndexingRule> r = this.indexRules.get(primaryNodeType);
        if (r != null) {
            rules = new ArrayList<IndexingRule>();
            rules.addAll(r);
        }
        if (rules != null) {
            for (IndexingRule rule : rules) {
                if (!rule.appliesTo(primaryNodeType)) continue;
                return rule;
            }
        }
        return null;
    }

    @CheckForNull
    public IndexingRule getApplicableIndexingRule(Tree state) {
        ArrayList<IndexingRule> rules = null;
        List<IndexingRule> r = this.indexRules.get(IndexDefinition.getPrimaryTypeName(state));
        if (r != null) {
            rules = new ArrayList<IndexingRule>();
            rules.addAll(r);
        }
        for (String name : IndexDefinition.getMixinTypeNames(state)) {
            r = this.indexRules.get(name);
            if (r == null) continue;
            if (rules == null) {
                rules = new ArrayList();
            }
            rules.addAll(r);
        }
        if (rules != null) {
            for (IndexingRule rule : rules) {
                if (!rule.appliesTo(state)) continue;
                return rule;
            }
        }
        return null;
    }

    private Map<String, List<IndexingRule>> collectIndexRules(NodeState indexRules, List<IndexingRule> definedIndexRules) {
        if (!indexRules.exists()) {
            return Collections.emptyMap();
        }
        if (!IndexDefinition.hasOrderableChildren(indexRules)) {
            log.warn("IndexRule node does not have orderable children in [{}]", (Object)this);
        }
        HashMap nt2rules = Maps.newHashMap();
        ReadOnlyNodeTypeManager ntReg = IndexDefinition.createNodeTypeManager((Tree)new ImmutableTree(this.root));
        ImmutableTree ruleTree = new ImmutableTree(indexRules);
        List<String> allNames = IndexDefinition.getAllNodeTypes(ntReg);
        for (Tree tree : ruleTree.getChildren()) {
            IndexingRule rule = new IndexingRule(tree.getName(), indexRules.getChildNode(tree.getName()));
            definedIndexRules.add(rule);
            log.trace("Found rule '{}' for NodeType '{}'", (Object)rule, (Object)rule.getNodeTypeName());
            List<String> ntNames = allNames;
            if (!rule.inherited) {
                ntNames = Collections.singletonList(rule.getNodeTypeName());
            }
            for (String ntName : ntNames) {
                if (!ntReg.isNodeType(ntName, rule.getNodeTypeName())) continue;
                ArrayList<IndexingRule> perNtConfig = (ArrayList<IndexingRule>)nt2rules.get(ntName);
                if (perNtConfig == null) {
                    perNtConfig = new ArrayList<IndexingRule>();
                    nt2rules.put(ntName, perNtConfig);
                }
                log.trace("Registering rule '{}' for name '{}'", (Object)rule, (Object)ntName);
                perNtConfig.add(new IndexingRule(rule, ntName));
            }
        }
        for (Map.Entry entry : nt2rules.entrySet()) {
            entry.setValue(ImmutableList.copyOf((Collection)((Collection)entry.getValue())));
        }
        return ImmutableMap.copyOf((Map)nt2rules);
    }

    private boolean areAllTypesIndexed() {
        IndexingRule ntBaseRule = this.getApplicableIndexingRule("nt:base");
        return ntBaseRule != null;
    }

    public static NodeBuilder updateDefinition(NodeBuilder indexDefn) {
        NodeState defn = indexDefn.getBaseState();
        if (!IndexDefinition.hasIndexingRules(defn)) {
            NodeState rulesState = IndexDefinition.createIndexRules(defn).getNodeState();
            indexDefn.setChildNode("indexRules", rulesState);
            indexDefn.setProperty(INDEX_VERSION, IndexDefinition.determineIndexFormatVersion(defn, indexDefn).getVersion());
            indexDefn.removeProperty("declaringNodeTypes");
            indexDefn.removeProperty("includePropertyNames");
            indexDefn.removeProperty("excludePropertyNames");
            indexDefn.removeProperty("orderedProps");
            indexDefn.removeProperty("fulltextEnabled");
            indexDefn.child("properties").remove();
            log.info("Updated index definition for {}", (Object)IndexDefinition.determineIndexName(defn, null));
        }
        return indexDefn;
    }

    private static NodeBuilder createIndexRules(NodeState defn) {
        NodeBuilder builder = EmptyNodeState.EMPTY_NODE.builder();
        Set<String> declaringNodeTypes = IndexDefinition.getMultiProperty(defn, "declaringNodeTypes");
        Set<String> includes = IndexDefinition.getMultiProperty(defn, "includePropertyNames");
        Set<String> excludes = IndexDefinition.toLowerCase(IndexDefinition.getMultiProperty(defn, "excludePropertyNames"));
        Set<String> orderedProps = IndexDefinition.getMultiProperty(defn, "orderedProps");
        boolean fullTextEnabled = ConfigUtil.getOptionalValue(defn, "fulltextEnabled", true);
        boolean storageEnabled = ConfigUtil.getOptionalValue(defn, "oak.experimental.storage", true);
        NodeState propNodeState = defn.getChildNode("properties");
        if (declaringNodeTypes.isEmpty()) {
            declaringNodeTypes = Collections.singleton("nt:base");
        }
        HashSet propNamesSet = Sets.newHashSet();
        propNamesSet.addAll(includes);
        propNamesSet.addAll(excludes);
        propNamesSet.addAll(orderedProps);
        for (ChildNodeEntry childNodeEntry : propNodeState.getChildNodeEntries()) {
            if (propNamesSet.contains(childNodeEntry.getName()) || !Iterables.isEmpty(childNodeEntry.getNodeState().getChildNodeNames())) continue;
            propNamesSet.add(childNodeEntry.getName());
        }
        ArrayList<String> propNames = new ArrayList<String>(propNamesSet);
        String string = "^[^\\/]*$";
        if (fullTextEnabled && includes.isEmpty()) {
            propNames.add("^[^\\/]*$");
        }
        for (String typeName : declaringNodeTypes) {
            NodeBuilder rule = builder.child(typeName);
            IndexDefinition.markAsNtUnstructured(rule);
            ArrayList propNodeNames = Lists.newArrayListWithCapacity((int)propNamesSet.size());
            NodeBuilder propNodes = rule.child("properties");
            int i = 0;
            Iterator iterator = propNames.iterator();
            while (iterator.hasNext()) {
                NodeState propDefNode;
                String propName;
                String propNodeName = propName = (String)iterator.next();
                if (PropertyDefinition.isRelativeProperty(propName) || propName.equals("^[^\\/]*$")) {
                    propNodeName = "prop" + i++;
                }
                propNodeNames.add(propNodeName);
                NodeBuilder prop = propNodes.child(propNodeName);
                IndexDefinition.markAsNtUnstructured(prop);
                prop.setProperty("name", propName);
                if (excludes.contains(propName)) {
                    prop.setProperty("index", false);
                } else if (fullTextEnabled) {
                    prop.setProperty("analyzed", true);
                    prop.setProperty("nodeScopeIndex", true);
                    prop.setProperty("useInExcerpt", storageEnabled);
                    prop.setProperty("propertyIndex", false);
                } else {
                    prop.setProperty("propertyIndex", true);
                    if (orderedProps.contains(propName)) {
                        prop.setProperty("ordered", true);
                    }
                }
                if (propName.equals("^[^\\/]*$")) {
                    prop.setProperty("isRegexp", true);
                }
                if ((propDefNode = IndexDefinition.getPropDefnNode(defn, propName)) == null) continue;
                for (PropertyState propertyState : propDefNode.getProperties()) {
                    prop.setProperty(propertyState);
                }
            }
            PropertyState supportedTypes = defn.getProperty("includePropertyTypes");
            if (supportedTypes == null) {
                supportedTypes = PropertyStates.createProperty("includePropertyTypes", TYPES_ALLOW_ALL_NAME);
            }
            rule.setProperty(supportedTypes);
            if (!"nt:base".equals(typeName)) {
                rule.setProperty("inherited", false);
            }
            propNodes.setProperty(":childOrder", propNodeNames, Type.NAMES);
            IndexDefinition.markAsNtUnstructured(propNodes);
        }
        IndexDefinition.markAsNtUnstructured(builder);
        builder.setProperty(":childOrder", declaringNodeTypes, Type.NAMES);
        return builder;
    }

    private static NodeState getPropDefnNode(NodeState defn, String propName) {
        NodeState propDefNode;
        NodeState propNode = defn.getChildNode("properties");
        if (PropertyDefinition.isRelativeProperty(propName)) {
            NodeState result = propNode;
            for (String name : PathUtils.elements(propName)) {
                result = result.getChildNode(name);
            }
            propDefNode = result;
        } else {
            propDefNode = propNode.getChildNode(propName);
        }
        return propDefNode.exists() ? propDefNode : null;
    }

    private NodeState getTikaConfigNode() {
        return this.definition.getChildNode("tika").getChildNode("config.xml");
    }

    private Codec createCodec() {
        String codecName = ConfigUtil.getOptionalValue(this.definition, "codec", null);
        Object codec = null;
        if (codecName != null) {
            codec = Codec.forName((String)codecName);
        } else if (this.fullTextEnabled) {
            codec = new OakCodec();
        }
        return codec;
    }

    private static String determineIndexName(NodeState defn, String indexPath) {
        String indexName = defn.getString("name");
        if (indexName == null) {
            if (indexPath != null) {
                return indexPath;
            }
            return "<No 'name' property defined>";
        }
        if (indexPath != null) {
            return indexName + "(" + indexPath + ")";
        }
        return indexName;
    }

    private static Set<String> getMultiProperty(NodeState definition, String propName) {
        PropertyState pse = definition.getProperty(propName);
        return pse != null ? ImmutableSet.copyOf(pse.getValue(Type.STRINGS)) : Collections.emptySet();
    }

    private static Set<String> toLowerCase(Set<String> values) {
        HashSet result = Sets.newHashSet();
        for (String val : values) {
            result.add(val.toLowerCase());
        }
        return ImmutableSet.copyOf((Collection)result);
    }

    private static List<String> getAllNodeTypes(ReadOnlyNodeTypeManager ntReg) {
        try {
            ArrayList typeNames = Lists.newArrayList();
            NodeTypeIterator ntItr = ntReg.getAllNodeTypes();
            while (ntItr.hasNext()) {
                typeNames.add(ntItr.nextNodeType().getName());
            }
            return typeNames;
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    private static ReadOnlyNodeTypeManager createNodeTypeManager(final Tree root) {
        return new ReadOnlyNodeTypeManager(){

            @Override
            protected Tree getTypes() {
                return TreeUtil.getTree(root, "/jcr:system/jcr:nodeTypes");
            }

            @Override
            @Nonnull
            protected NamePathMapper getNamePathMapper() {
                return NamePathMapper.DEFAULT;
            }
        };
    }

    private static String getPrimaryTypeName(Tree state) {
        String primaryType = TreeUtil.getPrimaryTypeName(state);
        return primaryType != null ? primaryType : "nt:base";
    }

    private static Iterable<String> getMixinTypeNames(Tree tree) {
        PropertyState property = tree.getProperty("jcr:mimeType");
        return property != null ? property.getValue(Type.NAMES) : Collections.emptyList();
    }

    private static boolean hasOrderableChildren(NodeState state) {
        return state.hasProperty(":childOrder");
    }

    static int getSupportedTypes(NodeState defn, String typePropertyName, int defaultVal) {
        PropertyState pst = defn.getProperty(typePropertyName);
        if (pst != null) {
            int types = 0;
            for (String inc : pst.getValue(Type.STRINGS)) {
                if (TYPES_ALLOW_ALL_NAME.equals(inc)) {
                    return -1;
                }
                try {
                    types |= 1 << PropertyType.valueFromName((String)inc);
                }
                catch (IllegalArgumentException e) {
                    log.warn("Unknown property type: " + inc);
                }
            }
            return types;
        }
        return defaultVal;
    }

    static boolean includePropertyType(int includedPropertyTypes, int type) {
        if (includedPropertyTypes == -1) {
            return true;
        }
        if (includedPropertyTypes == 0) {
            return false;
        }
        return (includedPropertyTypes & 1 << type) != 0;
    }

    private static boolean hasFulltextEnabledIndexRule(List<IndexingRule> rules) {
        for (IndexingRule rule : rules) {
            if (!rule.fulltextEnabled) continue;
            return true;
        }
        return false;
    }

    private static void markAsNtUnstructured(NodeBuilder nb) {
        nb.setProperty("jcr:primaryType", "nt:unstructured", Type.NAME);
    }

    private static IndexFormatVersion determineIndexFormatVersion(NodeState defn, NodeBuilder defnb) {
        if (defnb != null && !defnb.getChildNode(":data").exists()) {
            return IndexDefinition.determineVersionForFreshIndex(defnb);
        }
        if (defn.hasProperty("compatVersion")) {
            return IndexDefinition.versionFrom(defn.getProperty("compatVersion"));
        }
        if (defn.hasProperty(INDEX_VERSION)) {
            return IndexDefinition.versionFrom(defn.getProperty(INDEX_VERSION));
        }
        if (!defn.getChildNode(":data").exists()) {
            return IndexDefinition.determineVersionForFreshIndex(defn);
        }
        boolean fullTextEnabled = ConfigUtil.getOptionalValue(defn, "fulltextEnabled", true);
        return fullTextEnabled ? IndexFormatVersion.V1 : IndexFormatVersion.V2;
    }

    static IndexFormatVersion determineVersionForFreshIndex(NodeState defn) {
        return IndexDefinition.determineVersionForFreshIndex(defn.getProperty("fulltextEnabled"), defn.getProperty("compatVersion"), defn.getProperty(INDEX_VERSION));
    }

    static IndexFormatVersion determineVersionForFreshIndex(NodeBuilder defnb) {
        return IndexDefinition.determineVersionForFreshIndex(defnb.getProperty("fulltextEnabled"), defnb.getProperty("compatVersion"), defnb.getProperty(INDEX_VERSION));
    }

    private static IndexFormatVersion determineVersionForFreshIndex(PropertyState fulltext, PropertyState compat, PropertyState version) {
        if (compat != null) {
            return IndexDefinition.versionFrom(compat);
        }
        IndexFormatVersion defaultToUse = IndexFormatVersion.getDefault();
        IndexFormatVersion existing = version != null ? IndexDefinition.versionFrom(version) : null;
        IndexFormatVersion result = defaultToUse;
        if (existing != null) {
            result = IndexFormatVersion.max(result, existing);
        }
        if (fulltext != null && !fulltext.getValue(Type.BOOLEAN).booleanValue()) {
            return IndexFormatVersion.max(result, IndexFormatVersion.V2);
        }
        return result;
    }

    private static IndexFormatVersion versionFrom(PropertyState ps) {
        return IndexFormatVersion.getVersion(Ints.checkedCast((long)ps.getValue(Type.LONG)));
    }

    private static boolean hasIndexingRules(NodeState defn) {
        return defn.getChildNode("indexRules").exists();
    }

    private static final class NamePattern {
        private final String parentPath;
        private final Pattern pattern;
        private final PropertyDefinition config;

        private NamePattern(String pattern, PropertyDefinition config) {
            if ("^[^\\/]*$".equals(pattern)) {
                this.parentPath = "";
                this.pattern = Pattern.compile(pattern);
            } else {
                this.parentPath = PathUtils.getParentPath(pattern);
                this.pattern = Pattern.compile(PathUtils.getName(pattern));
            }
            this.config = config;
        }

        boolean matches(String propertyPath) {
            String parentPath = PathUtils.getParentPath(propertyPath);
            String propertyName = PathUtils.getName(propertyPath);
            if (!this.parentPath.equals(parentPath)) {
                return false;
            }
            return this.pattern.matcher(propertyName).matches();
        }

        PropertyDefinition getConfig() {
            return this.config;
        }
    }

    public class IndexingRule {
        private final String baseNodeType;
        private final String nodeTypeName;
        private final Map<String, PropertyDefinition> propConfigs;
        private final List<NamePattern> namePatterns;
        private final List<PropertyDefinition> nullCheckEnabledProperties;
        private final boolean indexesAllNodesOfMatchingType;
        final float boost;
        final boolean inherited;
        final int propertyTypes;
        final boolean fulltextEnabled;
        final boolean propertyIndexEnabled;
        final Aggregate aggregate;
        final Aggregate propAggregate;

        IndexingRule(String nodeTypeName, NodeState config) {
            this.nodeTypeName = nodeTypeName;
            this.baseNodeType = nodeTypeName;
            this.boost = ConfigUtil.getOptionalValue(config, "boost", 1.0f);
            this.inherited = ConfigUtil.getOptionalValue(config, "inherited", true);
            this.propertyTypes = IndexDefinition.getSupportedTypes(config, "includePropertyTypes", -1);
            ArrayList namePatterns = Lists.newArrayList();
            ArrayList nonExistentProperties = Lists.newArrayList();
            ArrayList propIncludes = Lists.newArrayList();
            this.propConfigs = this.collectPropConfigs(config, namePatterns, propIncludes, nonExistentProperties);
            this.propAggregate = new Aggregate(nodeTypeName, propIncludes);
            this.aggregate = this.combine(this.propAggregate, nodeTypeName);
            this.namePatterns = ImmutableList.copyOf((Collection)namePatterns);
            this.nullCheckEnabledProperties = ImmutableList.copyOf((Collection)nonExistentProperties);
            this.fulltextEnabled = this.aggregate.hasNodeAggregates() || this.hasAnyFullTextEnabledProperty();
            this.propertyIndexEnabled = this.hasAnyPropertyIndexConfigured();
            this.indexesAllNodesOfMatchingType = this.allMatchingNodeByTypeIndexed();
            this.validateRuleDefinition();
        }

        IndexingRule(IndexingRule original, String nodeTypeName) {
            this.nodeTypeName = nodeTypeName;
            this.baseNodeType = original.getNodeTypeName();
            this.propConfigs = original.propConfigs;
            this.namePatterns = original.namePatterns;
            this.boost = original.boost;
            this.inherited = original.inherited;
            this.propertyTypes = original.propertyTypes;
            this.propertyIndexEnabled = original.propertyIndexEnabled;
            this.propAggregate = original.propAggregate;
            this.nullCheckEnabledProperties = original.nullCheckEnabledProperties;
            this.aggregate = this.combine(this.propAggregate, nodeTypeName);
            this.fulltextEnabled = this.aggregate.hasNodeAggregates() || original.fulltextEnabled;
            this.indexesAllNodesOfMatchingType = this.allMatchingNodeByTypeIndexed();
        }

        public boolean isIndexed(String propertyName) {
            return this.getConfig(propertyName) != null;
        }

        public String getNodeTypeName() {
            return this.nodeTypeName;
        }

        public List<PropertyDefinition> getNullCheckEnabledProperties() {
            return this.nullCheckEnabledProperties;
        }

        public String toString() {
            String str = "IndexRule: " + this.nodeTypeName;
            if (!this.baseNodeType.equals(this.nodeTypeName)) {
                str = str + "(" + this.baseNodeType + ")";
            }
            return str;
        }

        public boolean isAggregated(String nodePath) {
            return this.aggregate.hasRelativeNodeInclude(nodePath);
        }

        public boolean appliesTo(Tree state) {
            return this.nodeTypeName.equals(IndexDefinition.getPrimaryTypeName(state));
        }

        public boolean appliesTo(String nodeTypeName) {
            return this.nodeTypeName.equals(nodeTypeName);
        }

        public boolean isFulltextEnabled() {
            return this.fulltextEnabled;
        }

        @CheckForNull
        public PropertyDefinition getConfig(String propertyName) {
            PropertyDefinition config = this.propConfigs.get(propertyName.toLowerCase(Locale.ENGLISH));
            if (config != null) {
                return config;
            }
            if (this.namePatterns.size() > 0) {
                for (NamePattern np : this.namePatterns) {
                    if (!np.matches(propertyName)) continue;
                    return np.getConfig();
                }
            }
            return null;
        }

        public boolean includePropertyType(int type) {
            return IndexDefinition.includePropertyType(this.propertyTypes, type);
        }

        public Aggregate getAggregate() {
            return this.aggregate;
        }

        public boolean indexesAllNodesOfMatchingType() {
            return this.indexesAllNodesOfMatchingType;
        }

        public boolean isBasedOnNtBase() {
            return "nt:base".equals(this.baseNodeType);
        }

        private Map<String, PropertyDefinition> collectPropConfigs(NodeState config, List<NamePattern> patterns, List<Aggregate.Include> propAggregate, List<PropertyDefinition> nonExistentProperties) {
            HashMap propDefns = Maps.newHashMap();
            NodeState propNode = config.getChildNode("properties");
            if (!propNode.exists()) {
                return Collections.emptyMap();
            }
            if (!IndexDefinition.hasOrderableChildren(propNode)) {
                log.warn("Properties node for [{}] does not have orderable children in [{}]", (Object)this, (Object)IndexDefinition.this);
            }
            ImmutableTree propTree = new ImmutableTree(propNode);
            for (Tree prop : propTree.getChildren()) {
                String propName = prop.getName();
                NodeState propDefnNode = propNode.getChildNode(propName);
                if (!propDefnNode.exists() || propDefns.containsKey(propName)) continue;
                PropertyDefinition pd = new PropertyDefinition(this, propName, propDefnNode);
                if (pd.isRegexp) {
                    patterns.add(new NamePattern(pd.name, pd));
                } else {
                    propDefns.put(pd.name.toLowerCase(Locale.ENGLISH), pd);
                }
                if (pd.relative) {
                    propAggregate.add(new Aggregate.PropertyInclude(pd));
                }
                if (!pd.nullCheckEnabled) continue;
                nonExistentProperties.add(pd);
            }
            return ImmutableMap.copyOf((Map)propDefns);
        }

        private boolean hasAnyFullTextEnabledProperty() {
            for (PropertyDefinition pd : this.propConfigs.values()) {
                if (!pd.fulltextEnabled()) continue;
                return true;
            }
            for (NamePattern np : this.namePatterns) {
                if (!np.getConfig().fulltextEnabled()) continue;
                return true;
            }
            return false;
        }

        private boolean hasAnyPropertyIndexConfigured() {
            for (PropertyDefinition pd : this.propConfigs.values()) {
                if (!pd.propertyIndex) continue;
                return true;
            }
            for (NamePattern np : this.namePatterns) {
                if (!np.getConfig().propertyIndex) continue;
                return true;
            }
            return false;
        }

        private boolean allMatchingNodeByTypeIndexed() {
            if (this.fulltextEnabled) {
                return true;
            }
            for (PropertyDefinition pd : this.nullCheckEnabledProperties) {
                if (pd.relative) continue;
                return true;
            }
            return this.getConfig("jcr:primaryType") != null;
        }

        private Aggregate combine(Aggregate propAggregate, String nodeTypeName) {
            Aggregate nodeTypeAgg = IndexDefinition.this.getAggregate(nodeTypeName);
            ArrayList includes = Lists.newArrayList();
            includes.addAll(propAggregate.getIncludes());
            if (nodeTypeAgg != null) {
                includes.addAll(nodeTypeAgg.getIncludes());
            }
            return new Aggregate(nodeTypeName, includes);
        }

        private void validateRuleDefinition() {
            if (!this.nullCheckEnabledProperties.isEmpty() && this.isBasedOnNtBase()) {
                throw new IllegalStateException("nt:base based rule cannot have a PropertyDefinition with nullCheckEnabled");
            }
        }
    }
}

