/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.IndexEditor;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdateCallback;
import org.apache.jackrabbit.oak.plugins.index.lucene.Aggregate;
import org.apache.jackrabbit.oak.plugins.index.lucene.FieldFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.FieldNames;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexFormatVersion;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexEditorContext;
import org.apache.jackrabbit.oak.plugins.index.lucene.PropertyDefinition;
import org.apache.jackrabbit.oak.plugins.index.lucene.TermFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.ConfigUtil;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.tree.ImmutableTree;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoubleDocValuesField;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.WriteOutContentHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;

public class LuceneIndexEditor
implements IndexEditor,
Aggregate.AggregateRoot {
    private static final Logger log = LoggerFactory.getLogger(LuceneIndexEditor.class);
    private final LuceneIndexEditorContext context;
    private final String name;
    private final LuceneIndexEditor parent;
    private String path;
    private boolean propertiesChanged = false;
    private final NodeState root;
    private final boolean isDeleted;
    private ImmutableTree current;
    private IndexDefinition.IndexingRule indexingRule;
    private List<Aggregate.Matcher> currentMatchers = Collections.emptyList();
    private final MatcherState matcherState;

    LuceneIndexEditor(NodeState root, NodeBuilder definition, IndexUpdateCallback updateCallback) throws CommitFailedException {
        this.parent = null;
        this.name = null;
        this.path = "/";
        this.context = new LuceneIndexEditorContext(root, definition, updateCallback);
        this.root = root;
        this.isDeleted = false;
        this.matcherState = MatcherState.NONE;
    }

    private LuceneIndexEditor(LuceneIndexEditor parent, String name, MatcherState matcherState, boolean isDeleted) {
        this.parent = parent;
        this.name = name;
        this.path = null;
        this.context = parent.context;
        this.root = parent.root;
        this.isDeleted = isDeleted;
        this.matcherState = matcherState;
    }

    public String getPath() {
        if (this.path == null) {
            this.path = PathUtils.concat(this.parent.getPath(), this.name);
        }
        return this.path;
    }

    @Override
    public void enter(NodeState before, NodeState after) throws CommitFailedException {
        if (EmptyNodeState.MISSING_NODE == before && this.parent == null) {
            this.context.enableReindexMode();
        }
        NodeState currentState = after.exists() ? after : before;
        this.current = this.parent == null ? new ImmutableTree(currentState) : new ImmutableTree(this.parent.current, this.name, currentState);
        this.indexingRule = this.getDefinition().getApplicableIndexingRule((Tree)this.current);
        if (this.indexingRule != null) {
            this.currentMatchers = this.indexingRule.getAggregate().createMatchers(this);
        }
    }

    @Override
    public void leave(NodeState before, NodeState after) throws CommitFailedException {
        long indexed;
        Object path;
        if ((this.propertiesChanged || !before.exists()) && this.addOrUpdate((String)(path = this.getPath()), after, before.exists()) && (indexed = this.context.incIndexedNodes()) % 1000L == 0L) {
            log.debug("{} => Indexed {} nodes...", (Object)this.context.getDefinition().getIndexName(), (Object)indexed);
        }
        for (Aggregate.Matcher m : this.matcherState.affectedMatchers) {
            m.markRootDirty();
        }
        if (this.parent == null) {
            try {
                this.context.closeWriter();
            }
            catch (IOException e) {
                throw new CommitFailedException("Lucene", 4, "Failed to close the Lucene index", e);
            }
            if (this.context.getIndexedNodes() > 0L) {
                log.debug("{} => Indexed {} nodes, done.", (Object)this.context.getDefinition().getIndexName(), (Object)this.context.getIndexedNodes());
            }
        }
    }

    @Override
    public void propertyAdded(PropertyState after) {
        this.markPropertyChanged(after.getName());
        this.checkAggregates(after.getName());
    }

    @Override
    public void propertyChanged(PropertyState before, PropertyState after) {
        this.markPropertyChanged(before.getName());
        this.checkAggregates(before.getName());
    }

    @Override
    public void propertyDeleted(PropertyState before) {
        this.markPropertyChanged(before.getName());
        this.checkAggregates(before.getName());
    }

    @Override
    public Editor childNodeAdded(String name, NodeState after) {
        return new LuceneIndexEditor(this, name, this.getMatcherState(name, after), false);
    }

    @Override
    public Editor childNodeChanged(String name, NodeState before, NodeState after) {
        return new LuceneIndexEditor(this, name, this.getMatcherState(name, after), false);
    }

    @Override
    public Editor childNodeDeleted(String name, NodeState before) throws CommitFailedException {
        MatcherState ms;
        if (!this.isDeleted) {
            String path = PathUtils.concat(this.getPath(), name);
            try {
                IndexWriter writer = this.context.getWriter();
                writer.deleteDocuments(TermFactory.newPathTerm(path));
                writer.deleteDocuments((Query)new PrefixQuery(TermFactory.newPathTerm(path + "/")));
                this.context.indexUpdate();
            }
            catch (IOException e) {
                throw new CommitFailedException("Lucene", 5, "Failed to remove the index entries of the removed subtree " + path, e);
            }
        }
        if (!(ms = this.getMatcherState(name, before)).isEmpty()) {
            return new LuceneIndexEditor(this, name, ms, true);
        }
        return null;
    }

    private boolean addOrUpdate(String path, NodeState state, boolean isUpdate) throws CommitFailedException {
        try {
            Document d = this.makeDocument(path, state, isUpdate);
            if (d != null) {
                if (log.isTraceEnabled()) {
                    log.trace("Indexed document for {} is {}", (Object)path, (Object)d);
                }
                this.context.indexUpdate();
                this.context.getWriter().updateDocument(TermFactory.newPathTerm(path), (Iterable)d);
                return true;
            }
        }
        catch (IOException e) {
            throw new CommitFailedException("Lucene", 3, "Failed to index the node " + path, e);
        }
        catch (IllegalArgumentException ie) {
            throw new CommitFailedException("Lucene", 3, "Failed to index the node " + path, ie);
        }
        return false;
    }

    private Document makeDocument(String path, NodeState state, boolean isUpdate) throws CommitFailedException {
        if (!this.isIndexable()) {
            return null;
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        boolean dirty = false;
        for (PropertyState propertyState : state.getProperties()) {
            PropertyDefinition pd;
            String pname = propertyState.getName();
            if (!LuceneIndexEditor.isVisible(pname) || (pd = this.indexingRule.getConfig(pname)) == null || !pd.index) continue;
            if (pd.ordered) {
                dirty |= this.addTypedOrderedFields(fields, propertyState, pname, pd);
            }
            dirty |= this.indexProperty(path, fields, state, propertyState, pname, pd);
        }
        dirty |= this.indexAggregates(path, fields, state);
        if (isUpdate && !(dirty |= this.indexNullCheckEnabledProps(path, fields, state))) {
            return null;
        }
        if (!this.indexingRule.isFulltextEnabled() && !dirty) {
            return null;
        }
        Document document = new Document();
        document.add((IndexableField)FieldFactory.newPathField(path));
        String string = PathUtils.getName(path);
        if (this.indexingRule.isFulltextEnabled()) {
            document.add((IndexableField)FieldFactory.newFulltextField(string));
        }
        if (this.getDefinition().evaluatePathRestrictions()) {
            document.add((IndexableField)FieldFactory.newAncestorsField(PathUtils.getParentPath(path)));
            document.add((IndexableField)FieldFactory.newDepthField(path));
        }
        for (Field f : fields) {
            document.add((IndexableField)f);
        }
        return document;
    }

    private boolean indexProperty(String path, List<Field> fields, NodeState state, PropertyState property, String pname, PropertyDefinition pd) throws CommitFailedException {
        boolean includeTypeForFullText = this.indexingRule.includePropertyType(property.getType().tag());
        if (Type.BINARY.tag() == property.getType().tag() && includeTypeForFullText) {
            fields.addAll(this.newBinary(property, state, null, path + "@" + pname));
            return true;
        }
        boolean dirty = false;
        if (pd.propertyIndex && pd.includePropertyType(property.getType().tag())) {
            dirty |= this.addTypedFields(fields, property, pname);
        }
        if (pd.fulltextEnabled() && includeTypeForFullText) {
            for (String value : property.getValue(Type.STRINGS)) {
                if (pd.analyzed && pd.includePropertyType(property.getType().tag())) {
                    String analyzedPropName = this.constructAnalyzedPropertyName(pname);
                    fields.add(FieldFactory.newPropertyField(analyzedPropName, value, !pd.skipTokenization(pname), pd.stored));
                }
                if (pd.useInSpellcheck) {
                    fields.add(FieldFactory.newPropertyField(":spellcheck", value, true, false));
                }
                if (pd.nodeScopeIndex) {
                    Field field = FieldFactory.newFulltextField(value);
                    field.setBoost(pd.boost);
                    fields.add(field);
                }
                dirty = true;
            }
        }
        return dirty;
    }

    private String constructAnalyzedPropertyName(String pname) {
        if (this.context.getDefinition().getVersion().isAtLeast(IndexFormatVersion.V2)) {
            return FieldNames.createAnalyzedFieldName(pname);
        }
        return pname;
    }

    private boolean addTypedFields(List<Field> fields, PropertyState property, String pname) throws CommitFailedException {
        int tag = property.getType().tag();
        boolean fieldAdded = false;
        for (int i = 0; i < property.count(); ++i) {
            Object f;
            if (tag == Type.LONG.tag()) {
                f = new LongField(pname, property.getValue(Type.LONG, i).longValue(), Field.Store.NO);
            } else if (tag == Type.DATE.tag()) {
                String date = property.getValue(Type.DATE, i);
                f = new LongField(pname, FieldFactory.dateToLong(date).longValue(), Field.Store.NO);
            } else {
                f = tag == Type.DOUBLE.tag() ? new DoubleField(pname, property.getValue(Type.DOUBLE, i).doubleValue(), Field.Store.NO) : (tag == Type.BOOLEAN.tag() ? new StringField(pname, property.getValue(Type.BOOLEAN, i).toString(), Field.Store.NO) : new StringField(pname, property.getValue(Type.STRING, i), Field.Store.NO));
            }
            fields.add((Field)f);
            fieldAdded = true;
        }
        return fieldAdded;
    }

    private boolean addTypedOrderedFields(List<Field> fields, PropertyState property, String pname, PropertyDefinition pd) throws CommitFailedException {
        int idxDefinedTag;
        int tag = property.getType().tag();
        if (tag != (idxDefinedTag = pd.getType())) {
            log.debug("Ordered property defined with type {} differs from property {} with type {} in path {}", new Object[]{Type.fromTag(idxDefinedTag, false), property.toString(), Type.fromTag(tag, false), this.getPath()});
            tag = idxDefinedTag;
        }
        String name = FieldNames.createDocValFieldName(pname);
        boolean fieldAdded = false;
        for (int i = 0; i < property.count(); ++i) {
            NumericDocValuesField f = null;
            try {
                if (tag == Type.LONG.tag()) {
                    f = new NumericDocValuesField(name, property.getValue(Type.LONG, i).longValue());
                } else if (tag == Type.DATE.tag()) {
                    String date = property.getValue(Type.DATE, i);
                    f = new NumericDocValuesField(name, FieldFactory.dateToLong(date).longValue());
                } else if (tag == Type.DOUBLE.tag()) {
                    f = new DoubleDocValuesField(name, property.getValue(Type.DOUBLE, i).doubleValue());
                } else if (tag == Type.BOOLEAN.tag()) {
                    f = new SortedDocValuesField(name, new BytesRef((CharSequence)property.getValue(Type.BOOLEAN, i).toString()));
                } else if (tag == Type.STRING.tag()) {
                    f = new SortedDocValuesField(name, new BytesRef((CharSequence)property.getValue(Type.STRING, i)));
                }
                if (f == null) continue;
                fields.add((Field)f);
                fieldAdded = true;
                continue;
            }
            catch (Exception e) {
                log.warn("Ignoring ordered property. Could not convert property {} of type {} to type {} for path {}", new Object[]{pname, Type.fromTag(property.getType().tag(), false), Type.fromTag(tag, false), this.getPath(), e});
            }
        }
        return fieldAdded;
    }

    private static boolean isVisible(String name) {
        return name.charAt(0) != ':';
    }

    private List<Field> newBinary(PropertyState property, NodeState state, String nodePath, String path) {
        ArrayList<Field> fields = new ArrayList<Field>();
        Metadata metadata = new Metadata();
        if ("jcr:data".equals(property.getName())) {
            String encoding;
            String type = state.getString("jcr:mimeType");
            if (type != null) {
                metadata.set("Content-Type", type);
            }
            if ((encoding = state.getString("jcr:encoding")) != null) {
                metadata.set("Content-Encoding", encoding);
            }
        }
        for (Blob v : property.getValue(Type.BINARIES)) {
            if (nodePath != null) {
                fields.add(FieldFactory.newFulltextField(nodePath, this.parseStringValue(v, metadata, path)));
                continue;
            }
            fields.add(FieldFactory.newFulltextField(this.parseStringValue(v, metadata, path)));
        }
        return fields;
    }

    private boolean indexNullCheckEnabledProps(String path, List<Field> fields, NodeState state) {
        boolean fieldAdded = false;
        for (PropertyDefinition pd : this.indexingRule.getNullCheckEnabledProperties()) {
            if (!this.isPropertyNull(state, pd)) continue;
            fields.add((Field)new StringField(":nullProps", pd.name, Field.Store.NO));
            fieldAdded = true;
        }
        return fieldAdded;
    }

    private boolean isPropertyNull(NodeState state, PropertyDefinition pd) {
        NodeState propertyNode = LuceneIndexEditor.getPropertyNode(state, pd);
        if (!propertyNode.exists()) {
            return false;
        }
        return !propertyNode.hasProperty(pd.nonRelativeName);
    }

    private static NodeState getPropertyNode(NodeState nodeState, PropertyDefinition pd) {
        if (!pd.relative) {
            return nodeState;
        }
        NodeState node = nodeState;
        for (String name : pd.ancestors) {
            node = node.getChildNode(name);
        }
        return node;
    }

    @Override
    public void markDirty() {
        this.propertiesChanged = true;
    }

    private MatcherState getMatcherState(String name, NodeState after) {
        ArrayList matched = Lists.newArrayList();
        ArrayList inherited = Lists.newArrayList();
        for (Aggregate.Matcher m : Iterables.concat(this.matcherState.inherited, this.currentMatchers)) {
            Aggregate.Matcher result = m.match(name, after);
            if (result.getStatus() == Aggregate.Matcher.Status.MATCH_FOUND) {
                matched.add(result);
            }
            if (result.getStatus() == Aggregate.Matcher.Status.FAIL) continue;
            inherited.addAll(result.nextSet());
        }
        if (!matched.isEmpty() || !inherited.isEmpty()) {
            return new MatcherState(matched, inherited);
        }
        return MatcherState.NONE;
    }

    private boolean indexAggregates(final String path, final List<Field> fields, final NodeState state) throws CommitFailedException {
        final AtomicBoolean dirtyFlag = new AtomicBoolean();
        this.indexingRule.getAggregate().collectAggregates(state, new Aggregate.ResultCollector(){

            @Override
            public void onResult(Aggregate.NodeIncludeResult result) throws CommitFailedException {
                boolean dirty = LuceneIndexEditor.this.indexAggregatedNode(path, fields, result);
                if (dirty) {
                    dirtyFlag.set(true);
                }
            }

            @Override
            public void onResult(Aggregate.PropertyIncludeResult result) throws CommitFailedException {
                boolean dirty = false;
                if (result.pd.ordered) {
                    dirty |= LuceneIndexEditor.this.addTypedOrderedFields(fields, result.propertyState, result.propertyPath, result.pd);
                }
                if (dirty |= LuceneIndexEditor.this.indexProperty(path, fields, state, result.propertyState, result.propertyPath, result.pd)) {
                    dirtyFlag.set(true);
                }
            }
        });
        return dirtyFlag.get();
    }

    private boolean indexAggregatedNode(String path, List<Field> fields, Aggregate.NodeIncludeResult result) throws CommitFailedException {
        IndexDefinition.IndexingRule ruleAggNode = this.context.getDefinition().getApplicableIndexingRule(ConfigUtil.getPrimaryTypeName(result.nodeState));
        boolean dirty = false;
        for (PropertyState propertyState : result.nodeState.getProperties()) {
            String pname = propertyState.getName();
            if (!LuceneIndexEditor.isVisible(pname)) continue;
            int type = propertyState.getType().tag();
            if (ruleAggNode == null ? !this.indexingRule.includePropertyType(type) : !ruleAggNode.includePropertyType(type)) continue;
            if (Type.BINARY == propertyState.getType()) {
                String aggreagtedNodePath = PathUtils.concat(path, result.nodePath);
                String nodePath = result.isRelativeNode() ? result.rootIncludePath : null;
                fields.addAll(this.newBinary(propertyState, result.nodeState, nodePath, aggreagtedNodePath + "@" + pname));
                dirty = true;
                continue;
            }
            PropertyDefinition pd = null;
            if (ruleAggNode != null) {
                pd = ruleAggNode.getConfig(pname);
            }
            if (pd != null && !pd.nodeScopeIndex) continue;
            for (String value : propertyState.getValue(Type.STRINGS)) {
                Field field;
                Field field2 = field = result.isRelativeNode() ? FieldFactory.newFulltextField(result.rootIncludePath, value) : FieldFactory.newFulltextField(value);
                if (pd != null) {
                    field.setBoost(pd.boost);
                }
                fields.add(field);
                dirty = true;
            }
        }
        return dirty;
    }

    private void checkAggregates(String name) {
        for (Aggregate.Matcher m : this.matcherState.matched) {
            if (this.matcherState.affectedMatchers.contains(m) || !m.aggregatesProperty(name)) continue;
            this.matcherState.affectedMatchers.add(m);
        }
    }

    private void markPropertyChanged(String name) {
        if (this.isIndexable() && !this.propertiesChanged && this.indexingRule.isIndexed(name)) {
            this.propertiesChanged = true;
        }
    }

    private IndexDefinition getDefinition() {
        return this.context.getDefinition();
    }

    private boolean isIndexable() {
        return this.indexingRule != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String parseStringValue(Blob v, Metadata metadata, String path) {
        WriteOutContentHandler handler;
        block6: {
            handler = new WriteOutContentHandler();
            try {
                InputStream stream = v.getNewStream();
                try {
                    this.context.getParser().parse(stream, (ContentHandler)handler, metadata, new ParseContext());
                }
                finally {
                    stream.close();
                }
            }
            catch (LinkageError e) {
            }
            catch (Throwable t) {
                if (handler.isWriteLimitReached(t)) break block6;
                log.debug("Failed to extract text from a binary property: " + path + " This is a fairly common case, and nothing to" + " worry about. The stack trace is included to" + " help improve the text extraction feature.", t);
                return "TextExtractionError";
            }
        }
        return handler.toString();
    }

    private static class MatcherState {
        static final MatcherState NONE = new MatcherState(Collections.<Aggregate.Matcher>emptyList(), Collections.<Aggregate.Matcher>emptyList());
        final List<Aggregate.Matcher> matched;
        final List<Aggregate.Matcher> inherited;
        final Set<Aggregate.Matcher> affectedMatchers;

        public MatcherState(List<Aggregate.Matcher> matched, List<Aggregate.Matcher> inherited) {
            this.matched = matched;
            this.inherited = inherited;
            this.affectedMatchers = matched.isEmpty() ? Collections.emptySet() : Sets.newIdentityHashSet();
        }

        public boolean isEmpty() {
            return this.matched.isEmpty() && this.inherited.isEmpty();
        }
    }
}

