/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.index.IndexUpdateCallback;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexFormatVersion;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexConstants;
import org.apache.jackrabbit.oak.plugins.index.lucene.OakDirectory;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.util.ISO8601;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.SerialMergeScheduler;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NoLockFactory;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class LuceneIndexEditorContext {
    private static final Logger log = LoggerFactory.getLogger(LuceneIndexEditorContext.class);
    private final IndexWriterConfig config;
    private static final Parser defaultParser = new AutoDetectParser();
    private final IndexDefinition definition;
    private final NodeBuilder definitionBuilder;
    private IndexWriter writer = null;
    private long indexedNodes;
    private final IndexUpdateCallback updateCallback;
    private boolean reindex;
    private Parser parser;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IndexWriterConfig getIndexWriterConfig(IndexDefinition definition) {
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        thread.setContextClassLoader(IndexWriterConfig.class.getClassLoader());
        try {
            IndexWriterConfig config = new IndexWriterConfig(LuceneIndexConstants.VERSION, definition.getAnalyzer());
            config.setMergeScheduler((MergeScheduler)new SerialMergeScheduler());
            if (definition.getCodec() != null) {
                config.setCodec(definition.getCodec());
            }
            IndexWriterConfig indexWriterConfig = config;
            return indexWriterConfig;
        }
        finally {
            thread.setContextClassLoader(loader);
        }
    }

    private static Directory newIndexDirectory(IndexDefinition indexDefinition, NodeBuilder definition) throws IOException {
        String path = definition.getString("path");
        if (path == null) {
            return new OakDirectory(definition.child(":data"), indexDefinition);
        }
        File file = new File(path);
        file.mkdirs();
        return FSDirectory.open((File)file, (LockFactory)NoLockFactory.getNoLockFactory());
    }

    LuceneIndexEditorContext(NodeState root, NodeBuilder definition, IndexUpdateCallback updateCallback) {
        this.definitionBuilder = definition;
        this.definition = new IndexDefinition(root, definition);
        this.config = LuceneIndexEditorContext.getIndexWriterConfig(this.definition);
        this.indexedNodes = 0L;
        this.updateCallback = updateCallback;
        if (this.definition.isOfOldFormat()) {
            IndexDefinition.updateDefinition(definition);
        }
    }

    Parser getParser() {
        if (this.parser == null) {
            this.parser = LuceneIndexEditorContext.initializeTikaParser(this.definition);
        }
        return this.parser;
    }

    IndexWriter getWriter() throws IOException {
        if (this.writer == null) {
            this.writer = new IndexWriter(LuceneIndexEditorContext.newIndexDirectory(this.definition, this.definitionBuilder), this.config);
        }
        return this.writer;
    }

    void closeWriter() throws IOException {
        if (this.reindex && this.writer == null) {
            this.getWriter();
        }
        if (this.writer != null) {
            this.writer.close();
            NodeBuilder status = this.definitionBuilder.child(":status");
            status.setProperty("lastUpdated", ISO8601.format(Calendar.getInstance()), Type.DATE);
            status.setProperty("indexedNodes", this.indexedNodes);
        }
    }

    public void enableReindexMode() {
        this.reindex = true;
        IndexFormatVersion version = IndexDefinition.determineVersionForFreshIndex(this.definitionBuilder);
        this.definitionBuilder.setProperty(":version", version.getVersion());
    }

    public long incIndexedNodes() {
        ++this.indexedNodes;
        return this.indexedNodes;
    }

    public long getIndexedNodes() {
        return this.indexedNodes;
    }

    void indexUpdate() throws CommitFailedException {
        this.updateCallback.indexUpdate();
    }

    public IndexDefinition getDefinition() {
        return this.definition;
    }

    private static Parser initializeTikaParser(IndexDefinition definition) {
        if (definition.hasCustomTikaConfig()) {
            InputStream is = definition.getTikaConfig();
            try {
                TikaConfig config = new TikaConfig(is);
                AutoDetectParser autoDetectParser = new AutoDetectParser(config);
                return autoDetectParser;
            }
            catch (IOException e) {
                throw new RuntimeException("Error loading TikaConfig for " + definition, e);
            }
            catch (SAXException e) {
                throw new RuntimeException("Error loading TikaConfig for " + definition, e);
            }
            catch (TikaException e) {
                throw new RuntimeException("Error loading TikaConfig for " + definition, e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
        return defaultParser;
    }
}

