/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.File;
import java.util.List;
import java.util.Map;
import javax.management.NotCompliantMBeanException;
import org.apache.commons.io.FilenameUtils;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.ReferencePolicyOption;
import org.apache.jackrabbit.oak.commons.PropertiesUtil;
import org.apache.jackrabbit.oak.osgi.OsgiWhiteboard;
import org.apache.jackrabbit.oak.plugins.index.aggregate.NodeAggregator;
import org.apache.jackrabbit.oak.plugins.index.lucene.CopyOnReadStatsMBean;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexCopier;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexTracker;
import org.apache.jackrabbit.oak.plugins.index.lucene.LoggingInfoStream;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexMBean;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexMBeanImpl;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexProvider;
import org.apache.jackrabbit.oak.spi.commit.BackgroundObserver;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.query.QueryIndexProvider;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardExecutor;
import org.apache.jackrabbit.oak.spi.whiteboard.WhiteboardUtils;
import org.apache.lucene.util.InfoStream;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(metatype=true, label="Apache Jackrabbit Oak LuceneIndexProvider")
public class LuceneIndexProviderService {
    public static final String REPOSITORY_HOME = "repository.home";
    private LuceneIndexProvider indexProvider;
    private final List<ServiceRegistration> regs = Lists.newArrayList();
    private final List<Registration> oakRegs = Lists.newArrayList();
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, policyOption=ReferencePolicyOption.GREEDY, policy=ReferencePolicy.DYNAMIC)
    private NodeAggregator nodeAggregator;
    @Property(boolValue={false}, label="Enable Debug Logging", description="Enables debug logging in Lucene. After enabling this actual logging can be controlled via changing log level for category 'oak.lucene' to debug")
    private static final String PROP_DEBUG = "debug";
    @Property(boolValue={false}, label="Enable CopyOnRead", description="Enable copying of Lucene index to local file system to improve query performance")
    private static final String PROP_COPY_ON_READ = "enableCopyOnReadSupport";
    @Property(label="Local index storage path", description="Local file system path where Lucene indexes would be copied when CopyOnRead is enabled. If not specified then indexes would be stored under 'index' dir under Repository Home")
    private static final String PROP_LOCAL_INDEX_DIR = "localIndexDir";
    @Property(boolValue={true}, label="Open index asynchronously", description="Enable opening of indexes in asynchronous mode")
    private static final String PROP_ASYNC_INDEX_OPEN = "enableOpenIndexAsync";
    private Whiteboard whiteboard;
    private WhiteboardExecutor executor;
    private BackgroundObserver backgroundObserver;

    @Activate
    private void activate(BundleContext bundleContext, Map<String, ?> config) throws NotCompliantMBeanException {
        this.whiteboard = new OsgiWhiteboard(bundleContext);
        this.executor = new WhiteboardExecutor();
        this.executor.start(this.whiteboard);
        this.indexProvider = new LuceneIndexProvider(this.createTracker(bundleContext, config));
        this.initializeLogging(config);
        this.initialize();
        this.regs.add(bundleContext.registerService(QueryIndexProvider.class.getName(), (Object)this.indexProvider, null));
        this.registerObserver(bundleContext, config);
        this.oakRegs.add(WhiteboardUtils.registerMBean(this.whiteboard, LuceneIndexMBean.class, new LuceneIndexMBeanImpl(this.indexProvider.getTracker()), "LuceneIndex", "Lucene Index statistics"));
    }

    @Deactivate
    private void deactivate() {
        for (ServiceRegistration serviceRegistration : this.regs) {
            serviceRegistration.unregister();
        }
        for (Registration registration : this.oakRegs) {
            registration.unregister();
        }
        if (this.backgroundObserver != null) {
            this.backgroundObserver.close();
        }
        if (this.indexProvider != null) {
            this.indexProvider.close();
            this.indexProvider = null;
        }
        if (this.executor != null) {
            this.executor.stop();
        }
        InfoStream.setDefault((InfoStream)InfoStream.NO_OUTPUT);
    }

    private void initialize() {
        if (this.indexProvider == null) {
            return;
        }
        if (this.nodeAggregator != null) {
            this.log.debug("Using NodeAggregator {}", this.nodeAggregator.getClass());
        }
        this.indexProvider.setAggregator(this.nodeAggregator);
    }

    private void initializeLogging(Map<String, ?> config) {
        boolean debug = PropertiesUtil.toBoolean(config.get(PROP_DEBUG), false);
        if (debug) {
            InfoStream.setDefault((InfoStream)LoggingInfoStream.INSTANCE);
            this.log.info("Registered LoggingInfoStream with Lucene. Lucene logs can be enabled now via category [{}]", (Object)"oak.lucene");
        }
    }

    private IndexTracker createTracker(BundleContext bundleContext, Map<String, ?> config) {
        boolean enableCopyOnRead = PropertiesUtil.toBoolean(config.get(PROP_COPY_ON_READ), false);
        if (enableCopyOnRead) {
            String repoHome;
            String indexDirPath = PropertiesUtil.toString(config.get(PROP_LOCAL_INDEX_DIR), null);
            if (Strings.isNullOrEmpty((String)indexDirPath) && (repoHome = bundleContext.getProperty(REPOSITORY_HOME)) != null) {
                indexDirPath = FilenameUtils.concat((String)repoHome, (String)"index");
            }
            Preconditions.checkNotNull((Object)indexDirPath, (String)"Index directory cannot be determined as neither index directory path [%s] nor repository home [%s] defined", (Object[])new Object[]{PROP_LOCAL_INDEX_DIR, REPOSITORY_HOME});
            File indexDir = new File(indexDirPath);
            IndexCopier copier = new IndexCopier(this.executor, indexDir);
            this.log.info("Enabling CopyOnRead support. Index files would be copied under {}", (Object)indexDir.getAbsolutePath());
            this.oakRegs.add(WhiteboardUtils.registerMBean(this.whiteboard, CopyOnReadStatsMBean.class, copier, "CopyOnReadStats", "CopyOnRead support statistics"));
            return new IndexTracker(copier);
        }
        return new IndexTracker();
    }

    private void registerObserver(BundleContext bundleContext, Map<String, ?> config) {
        boolean enableAsyncIndexOpen = PropertiesUtil.toBoolean(config.get(PROP_ASYNC_INDEX_OPEN), true);
        Closeable observer = this.indexProvider;
        if (enableAsyncIndexOpen) {
            this.backgroundObserver = new BackgroundObserver(this.indexProvider, this.executor, 5);
            observer = this.backgroundObserver;
            this.log.info("Registering the LuceneIndexProvider as a BackgroundObserver");
        }
        this.regs.add(bundleContext.registerService(Observer.class.getName(), (Object)observer, null));
    }

    protected void bindNodeAggregator(NodeAggregator aggregator) {
        this.nodeAggregator = aggregator;
        this.initialize();
    }

    protected void unbindNodeAggregator(NodeAggregator aggregator) {
        this.nodeAggregator = null;
        this.initialize();
    }
}

