/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.CheckForNull;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.aggregate.NodeAggregator;
import org.apache.jackrabbit.oak.plugins.index.lucene.FieldFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.FieldNames;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexNode;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexPlanner;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexTracker;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexConstants;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneIndexLookup;
import org.apache.jackrabbit.oak.plugins.index.lucene.LuceneRequestFacade;
import org.apache.jackrabbit.oak.plugins.index.lucene.PropertyDefinition;
import org.apache.jackrabbit.oak.plugins.index.lucene.TermFactory;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.MoreLikeThisHelper;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.SpellcheckHelper;
import org.apache.jackrabbit.oak.query.QueryEngineSettings;
import org.apache.jackrabbit.oak.query.fulltext.FullTextAnd;
import org.apache.jackrabbit.oak.query.fulltext.FullTextExpression;
import org.apache.jackrabbit.oak.query.fulltext.FullTextOr;
import org.apache.jackrabbit.oak.query.fulltext.FullTextTerm;
import org.apache.jackrabbit.oak.query.fulltext.FullTextVisitor;
import org.apache.jackrabbit.oak.spi.query.Cursor;
import org.apache.jackrabbit.oak.spi.query.Cursors;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.query.IndexRow;
import org.apache.jackrabbit.oak.spi.query.PropertyValues;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.search.spell.SuggestWord;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Version;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LucenePropertyIndex
implements QueryIndex.AdvancedQueryIndex,
QueryIndex,
QueryIndex.NativeQueryIndex,
QueryIndex.AdvanceFulltextQueryIndex {
    private static final Logger LOG = LoggerFactory.getLogger(LucenePropertyIndex.class);
    static final String ATTR_PLAN_RESULT = "oak.lucene.planResult";
    static final int LUCENE_QUERY_BATCH_SIZE = 50;
    protected final IndexTracker tracker;
    private static char[] fulltextTokens = new char[]{'*', '?'};

    public LucenePropertyIndex(IndexTracker tracker) {
        this.tracker = tracker;
    }

    @Override
    public String getIndexName() {
        return "lucene-property";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<QueryIndex.IndexPlan> getPlans(Filter filter, List<QueryIndex.OrderEntry> sortOrder, NodeState rootState) {
        Collection<String> indexPaths = new LuceneIndexLookup(rootState).collectIndexNodePaths(filter);
        ArrayList plans = Lists.newArrayListWithCapacity((int)indexPaths.size());
        IndexNode indexNode = null;
        for (String path : indexPaths) {
            try {
                QueryIndex.IndexPlan plan;
                indexNode = this.tracker.acquireIndexNode(path);
                if (indexNode == null || (plan = new IndexPlanner(indexNode, path, filter, sortOrder).getPlan()) == null) continue;
                plans.add(plan);
            }
            finally {
                if (indexNode == null) continue;
                indexNode.release();
            }
        }
        return plans;
    }

    @Override
    public double getCost(Filter filter, NodeState root) {
        throw new UnsupportedOperationException("Not supported as implementing AdvancedQueryIndex");
    }

    @Override
    public String getPlan(Filter filter, NodeState root) {
        throw new UnsupportedOperationException("Not supported as implementing AdvancedQueryIndex");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPlanDescription(QueryIndex.IndexPlan plan, NodeState root) {
        Filter filter = plan.getFilter();
        IndexNode index = this.tracker.acquireIndexNode(LucenePropertyIndex.getPlanResult((QueryIndex.IndexPlan)plan).indexPath);
        Preconditions.checkState((index != null ? 1 : 0) != 0, (Object)"The Lucene index is not available");
        try {
            FullTextExpression ft = filter.getFullTextConstraint();
            StringBuilder sb = new StringBuilder("lucene:");
            String path = LucenePropertyIndex.getPlanResult((QueryIndex.IndexPlan)plan).indexPath;
            sb.append(LucenePropertyIndex.getIndexName(plan)).append("(").append(path).append(") ");
            sb.append(LucenePropertyIndex.getLuceneRequest(plan, null));
            if (plan.getSortOrder() != null && !plan.getSortOrder().isEmpty()) {
                sb.append(" ordering:").append(plan.getSortOrder());
            }
            if (ft != null) {
                sb.append(" ft:(").append(ft).append(")");
            }
            String string = sb.toString();
            return string;
        }
        finally {
            index.release();
        }
    }

    @Override
    public Cursor query(Filter filter, NodeState root) {
        throw new UnsupportedOperationException("Not supported as implementing AdvancedQueryIndex");
    }

    @Override
    public Cursor query(final QueryIndex.IndexPlan plan, NodeState rootState) {
        final Filter filter = plan.getFilter();
        final Sort sort = this.getSort(plan);
        final IndexPlanner.PlanResult pr = LucenePropertyIndex.getPlanResult(plan);
        QueryEngineSettings settings = filter.getQueryEngineSettings();
        AbstractIterator<LuceneResultRow> itr = new AbstractIterator<LuceneResultRow>(){
            private final Deque<LuceneResultRow> queue = Queues.newArrayDeque();
            private final Set<String> seenPaths = Sets.newHashSet();
            private ScoreDoc lastDoc;
            private int nextBatchSize = 50;
            private boolean noDocs = false;

            protected LuceneResultRow computeNext() {
                if (!this.queue.isEmpty() || this.loadDocs()) {
                    return this.queue.remove();
                }
                return (LuceneResultRow)this.endOfData();
            }

            private LuceneResultRow convertToRow(ScoreDoc doc, IndexSearcher searcher) throws IOException {
                IndexReader reader = searcher.getIndexReader();
                PathStoredFieldVisitor visitor = new PathStoredFieldVisitor();
                reader.document(doc.doc, (StoredFieldVisitor)visitor);
                String path = visitor.getPath();
                if (path != null) {
                    if ("".equals(path)) {
                        path = "/";
                    }
                    if (pr.isPathTransformed()) {
                        if ((path = pr.transformPath(path)) == null || this.seenPaths.contains(path)) {
                            return null;
                        }
                        this.seenPaths.add(path);
                    }
                    return new LuceneResultRow(path, doc.score);
                }
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private boolean loadDocs() {
                if (this.noDocs) {
                    return false;
                }
                ScoreDoc lastDocToRecord = null;
                IndexNode indexNode = LucenePropertyIndex.this.acquireIndexNode(plan);
                Preconditions.checkState((indexNode != null ? 1 : 0) != 0);
                try {
                    IndexSearcher searcher = indexNode.getSearcher();
                    LuceneRequestFacade luceneRequestFacade = LucenePropertyIndex.getLuceneRequest(plan, searcher.getIndexReader());
                    if (luceneRequestFacade.getLuceneRequest() instanceof Query) {
                        Object docs;
                        Query query = (Query)luceneRequestFacade.getLuceneRequest();
                        long time = System.currentTimeMillis();
                        if (this.lastDoc != null) {
                            LOG.debug("loading the next {} entries for query {}", (Object)this.nextBatchSize, (Object)query);
                            docs = sort == null ? searcher.searchAfter(this.lastDoc, query, this.nextBatchSize) : searcher.searchAfter(this.lastDoc, query, 50, sort);
                        } else {
                            LOG.debug("loading the first {} entries for query {}", (Object)this.nextBatchSize, (Object)query);
                            docs = sort == null ? searcher.search(query, this.nextBatchSize) : searcher.search(query, 50, sort);
                        }
                        time = System.currentTimeMillis() - time;
                        LOG.debug("... took {} ms", (Object)time);
                        this.nextBatchSize = (int)Math.min((long)this.nextBatchSize * 2L, 100000L);
                        for (ScoreDoc doc : docs.scoreDocs) {
                            LuceneResultRow row = this.convertToRow(doc, searcher);
                            if (row != null) {
                                this.queue.add(row);
                            }
                            lastDocToRecord = doc;
                        }
                    } else if (luceneRequestFacade.getLuceneRequest() instanceof SpellcheckHelper.SpellcheckQuery) {
                        SpellcheckHelper.SpellcheckQuery spellcheckQuery = (SpellcheckHelper.SpellcheckQuery)luceneRequestFacade.getLuceneRequest();
                        SuggestWord[] suggestWords = SpellcheckHelper.getSpellcheck(spellcheckQuery);
                        ArrayList<String> suggestedWords = new ArrayList<String>(suggestWords.length);
                        QueryParser qp = new QueryParser(Version.LUCENE_47, ":fulltext", indexNode.getDefinition().getAnalyzer());
                        block6: for (SuggestWord suggestion : suggestWords) {
                            Query query = qp.createPhraseQuery(":fulltext", suggestion.string);
                            TopDocs topDocs = searcher.search(query, 100);
                            if (topDocs.totalHits <= 0) continue;
                            for (ScoreDoc doc : topDocs.scoreDocs) {
                                Document retrievedDoc = searcher.doc(doc.doc);
                                if (!filter.isAccessible(retrievedDoc.get(":path"))) continue;
                                suggestedWords.add(suggestion.string);
                                continue block6;
                            }
                        }
                        this.queue.add(new LuceneResultRow(suggestedWords));
                        this.noDocs = true;
                    }
                }
                catch (IOException e) {
                    LOG.warn("query via {} failed.", (Object)LucenePropertyIndex.this, (Object)e);
                }
                finally {
                    indexNode.release();
                }
                if (lastDocToRecord != null) {
                    this.lastDoc = lastDocToRecord;
                }
                return !this.queue.isEmpty();
            }
        };
        return new LucenePathCursor((Iterator<LuceneResultRow>)itr, plan, settings);
    }

    @Override
    public NodeAggregator getNodeAggregator() {
        return null;
    }

    public static boolean isNodePath(String fulltextTermPath) {
        return fulltextTermPath.endsWith("/*");
    }

    private IndexNode acquireIndexNode(QueryIndex.IndexPlan plan) {
        return this.tracker.acquireIndexNode(LucenePropertyIndex.getPlanResult((QueryIndex.IndexPlan)plan).indexPath);
    }

    private Sort getSort(QueryIndex.IndexPlan plan) {
        List<QueryIndex.OrderEntry> sortOrder = plan.getSortOrder();
        if (sortOrder == null || sortOrder.isEmpty()) {
            return null;
        }
        ArrayList fieldsList = Lists.newArrayListWithCapacity((int)sortOrder.size());
        IndexPlanner.PlanResult planResult = LucenePropertyIndex.getPlanResult(plan);
        for (int i = 0; i < sortOrder.size(); ++i) {
            QueryIndex.OrderEntry oe = sortOrder.get(i);
            if (LucenePropertyIndex.isNativeSort(oe)) continue;
            PropertyDefinition pd = planResult.getOrderedProperty(i);
            boolean reverse = oe.getOrder() != QueryIndex.OrderEntry.Order.ASCENDING;
            String propName = oe.getPropertyName();
            propName = FieldNames.createDocValFieldName(propName);
            fieldsList.add(new SortField(propName, LucenePropertyIndex.toLuceneSortType(oe, pd), reverse));
        }
        if (fieldsList.isEmpty()) {
            return null;
        }
        return new Sort(fieldsList.toArray(new SortField[0]));
    }

    private static boolean isNativeSort(QueryIndex.OrderEntry oe) {
        return oe.getPropertyName().equals(IndexDefinition.NATIVE_SORT_ORDER.getPropertyName());
    }

    private static SortField.Type toLuceneSortType(QueryIndex.OrderEntry oe, PropertyDefinition defn) {
        Type<?> t = oe.getPropertyType();
        Preconditions.checkState((t != null ? 1 : 0) != 0, (Object)"Type cannot be null");
        Preconditions.checkState((!t.isArray() ? 1 : 0) != 0, (Object)"Array types are not supported");
        int type = LucenePropertyIndex.getPropertyType(defn, oe.getPropertyName(), t.tag());
        switch (type) {
            case 3: 
            case 5: {
                return SortField.Type.LONG;
            }
            case 4: {
                return SortField.Type.DOUBLE;
            }
        }
        return SortField.Type.STRING;
    }

    private static String getIndexName(QueryIndex.IndexPlan plan) {
        return PathUtils.getName(LucenePropertyIndex.getPlanResult((QueryIndex.IndexPlan)plan).indexPath);
    }

    private static LuceneRequestFacade getLuceneRequest(QueryIndex.IndexPlan plan, IndexReader reader) {
        ArrayList<Query> qs = new ArrayList<Query>();
        Filter filter = plan.getFilter();
        FullTextExpression ft = filter.getFullTextConstraint();
        IndexPlanner.PlanResult planResult = LucenePropertyIndex.getPlanResult(plan);
        IndexDefinition defn = planResult.indexDefinition;
        Analyzer analyzer = defn.getAnalyzer();
        if (ft != null) {
            qs.add(LucenePropertyIndex.getFullTextQuery(plan, ft, analyzer, reader));
        }
        Filter.PropertyRestriction pr = null;
        if (defn.hasFunctionDefined()) {
            pr = filter.getPropertyRestriction(defn.getFunctionName());
        }
        if (pr != null) {
            String query = String.valueOf(pr.first.getValue(pr.first.getType()));
            QueryParser queryParser = new QueryParser(LuceneIndexConstants.VERSION, "", analyzer);
            if (query.startsWith("mlt?")) {
                Query moreLikeThis;
                String mltQueryString = query.replace("mlt?", "");
                if (reader != null && (moreLikeThis = MoreLikeThisHelper.getMoreLikeThis(reader, analyzer, mltQueryString)) != null) {
                    qs.add(moreLikeThis);
                }
            } else if (query.startsWith("spellcheck?")) {
                String spellcheckQueryString = query.replace("spellcheck?", "");
                if (reader != null) {
                    return new LuceneRequestFacade<SpellcheckHelper.SpellcheckQuery>(SpellcheckHelper.getSpellcheckQuery(spellcheckQueryString, reader));
                }
            } else {
                try {
                    qs.add(queryParser.parse(query));
                }
                catch (ParseException e) {
                    throw new RuntimeException(e);
                }
            }
        } else if (planResult.evaluateNonFullTextConstraints()) {
            LucenePropertyIndex.addNonFullTextConstraints(qs, plan, reader);
        }
        if (qs.size() == 0 && plan.getSortOrder() != null) {
            List<QueryIndex.OrderEntry> orders = plan.getSortOrder();
            for (int i = 0; i < orders.size(); ++i) {
                QueryIndex.OrderEntry oe = orders.get(i);
                if (LucenePropertyIndex.isNativeSort(oe)) continue;
                PropertyDefinition pd = planResult.getOrderedProperty(i);
                Filter.PropertyRestriction orderRest = new Filter.PropertyRestriction();
                orderRest.propertyName = oe.getPropertyName();
                Query q = LucenePropertyIndex.createQuery(orderRest, pd);
                if (q == null) continue;
                qs.add(q);
            }
        }
        if (qs.size() == 0) {
            if (reader == null) {
                return new LuceneRequestFacade<MatchAllDocsQuery>(new MatchAllDocsQuery());
            }
            return new LuceneRequestFacade<MatchAllDocsQuery>(new MatchAllDocsQuery());
        }
        if (qs.size() == 1) {
            return new LuceneRequestFacade(qs.get(0));
        }
        BooleanQuery bq = new BooleanQuery();
        for (Query q : qs) {
            bq.add(q, BooleanClause.Occur.MUST);
        }
        return new LuceneRequestFacade<BooleanQuery>(bq);
    }

    private static void addNonFullTextConstraints(List<Query> qs, QueryIndex.IndexPlan plan, IndexReader reader) {
        Filter filter = plan.getFilter();
        IndexPlanner.PlanResult planResult = LucenePropertyIndex.getPlanResult(plan);
        IndexDefinition defn = planResult.indexDefinition;
        if (!filter.matchesAllTypes()) {
            LucenePropertyIndex.addNodeTypeConstraints(planResult.indexingRule, qs, filter);
        }
        String path = LucenePropertyIndex.getPathRestriction(plan);
        switch (filter.getPathRestriction()) {
            case ALL_CHILDREN: {
                if (!defn.evaluatePathRestrictions() || "/".equals(path)) break;
                qs.add((Query)new TermQuery(TermFactory.newAncestorTerm(path)));
                break;
            }
            case DIRECT_CHILDREN: {
                if (!defn.evaluatePathRestrictions()) break;
                BooleanQuery bq = new BooleanQuery();
                bq.add(new BooleanClause((Query)new TermQuery(TermFactory.newAncestorTerm(path)), BooleanClause.Occur.MUST));
                bq.add(new BooleanClause(LucenePropertyIndex.newDepthQuery(path), BooleanClause.Occur.MUST));
                qs.add((Query)bq);
                break;
            }
            case EXACT: {
                qs.add((Query)new TermQuery(TermFactory.newPathTerm(path)));
                break;
            }
            case PARENT: {
                if (PathUtils.denotesRoot(path)) {
                    qs.add((Query)new TermQuery(new Term(":path", "///")));
                    break;
                }
                qs.add((Query)new TermQuery(TermFactory.newPathTerm(PathUtils.getParentPath(path))));
                break;
            }
        }
        for (Filter.PropertyRestriction pr : filter.getPropertyRestrictions()) {
            Query q;
            PropertyDefinition pd;
            String name = pr.propertyName;
            if ("rep:excerpt".equals(name) || pr.isNotNullRestriction() && filter.getPropertyRestrictions(name).size() > 1 && pr.list == null) continue;
            if (pr.first != null && pr.first.equals(pr.last) && pr.firstIncluding && pr.lastIncluding) {
                String first = pr.first.getValue(Type.STRING);
                first = first.replace("\\", "");
                if ("jcr:path".equals(name)) {
                    qs.add((Query)new TermQuery(TermFactory.newPathTerm(first)));
                    continue;
                }
                if ("*".equals(name)) {
                    LucenePropertyIndex.addReferenceConstraint(first, qs, reader);
                    continue;
                }
            }
            if ((pd = planResult.getPropDefn(pr)) == null || (q = LucenePropertyIndex.createQuery(pr, pd)) == null) continue;
            qs.add(q);
        }
    }

    private static int determinePropertyType(PropertyDefinition defn, Filter.PropertyRestriction pr) {
        int typeFromRestriction = pr.propertyType;
        if (typeFromRestriction == 0) {
            if (pr.first != null && pr.first.getType() != Type.UNDEFINED) {
                typeFromRestriction = pr.first.getType().tag();
            } else if (pr.last != null && pr.last.getType() != Type.UNDEFINED) {
                typeFromRestriction = pr.last.getType().tag();
            } else if (pr.list != null && !pr.list.isEmpty()) {
                typeFromRestriction = pr.list.get(0).getType().tag();
            }
        }
        return LucenePropertyIndex.getPropertyType(defn, pr.propertyName, typeFromRestriction);
    }

    private static int getPropertyType(PropertyDefinition defn, String name, int defaultVal) {
        if (defn.isTypeDefined()) {
            return defn.getType();
        }
        return defaultVal;
    }

    private static IndexPlanner.PlanResult getPlanResult(QueryIndex.IndexPlan plan) {
        return (IndexPlanner.PlanResult)plan.getAttribute(ATTR_PLAN_RESULT);
    }

    private static Query createLikeQuery(String name, String first) {
        first = first.replace('%', '*');
        first = first.replace('_', '?');
        int indexOfWS = first.indexOf(42);
        int indexOfWC = first.indexOf(63);
        int len = first.length();
        if (indexOfWS == len || indexOfWC == len) {
            first = first.substring(0, first.length() - 1);
            if ("jcr:path".equals(name)) {
                return new PrefixQuery(TermFactory.newPathTerm(first));
            }
            return new PrefixQuery(new Term(name, first));
        }
        if ("jcr:path".equals(name)) {
            return new WildcardQuery(TermFactory.newPathTerm(first));
        }
        return new WildcardQuery(new Term(name, first));
    }

    @CheckForNull
    private static Query createQuery(Filter.PropertyRestriction pr, PropertyDefinition defn) {
        int propType = LucenePropertyIndex.determinePropertyType(defn, pr);
        if (pr.isNullRestriction()) {
            return new TermQuery(new Term(":nullProps", defn.name));
        }
        switch (propType) {
            case 5: {
                Long last;
                Long first = pr.first != null ? FieldFactory.dateToLong(pr.first.getValue(Type.DATE)) : null;
                Long l = last = pr.last != null ? FieldFactory.dateToLong(pr.last.getValue(Type.DATE)) : null;
                if (pr.first != null && pr.first.equals(pr.last) && pr.firstIncluding && pr.lastIncluding) {
                    return NumericRangeQuery.newLongRange((String)pr.propertyName, (Long)first, (Long)first, (boolean)true, (boolean)true);
                }
                if (pr.first != null && pr.last != null) {
                    return NumericRangeQuery.newLongRange((String)pr.propertyName, (Long)first, (Long)last, (boolean)pr.firstIncluding, (boolean)pr.lastIncluding);
                }
                if (pr.first != null && pr.last == null) {
                    return NumericRangeQuery.newLongRange((String)pr.propertyName, (Long)first, null, (boolean)pr.firstIncluding, (boolean)true);
                }
                if (pr.last != null && !pr.last.equals(pr.first)) {
                    return NumericRangeQuery.newLongRange((String)pr.propertyName, null, (Long)last, (boolean)true, (boolean)pr.lastIncluding);
                }
                if (pr.list != null) {
                    BooleanQuery in = new BooleanQuery();
                    for (PropertyValue value : pr.list) {
                        Long dateVal = FieldFactory.dateToLong(value.getValue(Type.DATE));
                        in.add((Query)NumericRangeQuery.newLongRange((String)pr.propertyName, (Long)dateVal, (Long)dateVal, (boolean)true, (boolean)true), BooleanClause.Occur.SHOULD);
                    }
                    return in;
                }
                if (!pr.isNotNullRestriction()) break;
                return NumericRangeQuery.newLongRange((String)pr.propertyName, (Long)0L, (Long)Long.MAX_VALUE, (boolean)true, (boolean)true);
            }
            case 4: {
                Double last;
                Double first = pr.first != null ? pr.first.getValue(Type.DOUBLE) : null;
                Double d = last = pr.last != null ? pr.last.getValue(Type.DOUBLE) : null;
                if (pr.first != null && pr.first.equals(pr.last) && pr.firstIncluding && pr.lastIncluding) {
                    return NumericRangeQuery.newDoubleRange((String)pr.propertyName, (Double)first, (Double)first, (boolean)true, (boolean)true);
                }
                if (pr.first != null && pr.last != null) {
                    return NumericRangeQuery.newDoubleRange((String)pr.propertyName, (Double)first, (Double)last, (boolean)pr.firstIncluding, (boolean)pr.lastIncluding);
                }
                if (pr.first != null && pr.last == null) {
                    return NumericRangeQuery.newDoubleRange((String)pr.propertyName, (Double)first, null, (boolean)pr.firstIncluding, (boolean)true);
                }
                if (pr.last != null && !pr.last.equals(pr.first)) {
                    return NumericRangeQuery.newDoubleRange((String)pr.propertyName, null, (Double)last, (boolean)true, (boolean)pr.lastIncluding);
                }
                if (pr.list != null) {
                    BooleanQuery in = new BooleanQuery();
                    for (PropertyValue value : pr.list) {
                        Double doubleVal = value.getValue(Type.DOUBLE);
                        in.add((Query)NumericRangeQuery.newDoubleRange((String)pr.propertyName, (Double)doubleVal, (Double)doubleVal, (boolean)true, (boolean)true), BooleanClause.Occur.SHOULD);
                    }
                    return in;
                }
                if (!pr.isNotNullRestriction()) break;
                return NumericRangeQuery.newDoubleRange((String)pr.propertyName, (Double)Double.MIN_VALUE, (Double)Double.MAX_VALUE, (boolean)true, (boolean)true);
            }
            case 3: {
                Long last;
                Long first = pr.first != null ? pr.first.getValue(Type.LONG) : null;
                Long l = last = pr.last != null ? pr.last.getValue(Type.LONG) : null;
                if (pr.first != null && pr.first.equals(pr.last) && pr.firstIncluding && pr.lastIncluding) {
                    return NumericRangeQuery.newLongRange((String)pr.propertyName, (Long)first, (Long)first, (boolean)true, (boolean)true);
                }
                if (pr.first != null && pr.last != null) {
                    return NumericRangeQuery.newLongRange((String)pr.propertyName, (Long)first, (Long)last, (boolean)pr.firstIncluding, (boolean)pr.lastIncluding);
                }
                if (pr.first != null && pr.last == null) {
                    return NumericRangeQuery.newLongRange((String)pr.propertyName, (Long)first, null, (boolean)pr.firstIncluding, (boolean)true);
                }
                if (pr.last != null && !pr.last.equals(pr.first)) {
                    return NumericRangeQuery.newLongRange((String)pr.propertyName, null, (Long)last, (boolean)true, (boolean)pr.lastIncluding);
                }
                if (pr.list != null) {
                    BooleanQuery in = new BooleanQuery();
                    for (PropertyValue value : pr.list) {
                        Long longVal = value.getValue(Type.LONG);
                        in.add((Query)NumericRangeQuery.newLongRange((String)pr.propertyName, (Long)longVal, (Long)longVal, (boolean)true, (boolean)true), BooleanClause.Occur.SHOULD);
                    }
                    return in;
                }
                if (!pr.isNotNullRestriction()) break;
                return NumericRangeQuery.newLongRange((String)pr.propertyName, (Long)Long.MIN_VALUE, (Long)Long.MAX_VALUE, (boolean)true, (boolean)true);
            }
            default: {
                String last;
                if (pr.isLike) {
                    return LucenePropertyIndex.createLikeQuery(pr.propertyName, pr.first.getValue(Type.STRING));
                }
                String first = pr.first != null ? pr.first.getValue(Type.STRING) : null;
                String string = last = pr.last != null ? pr.last.getValue(Type.STRING) : null;
                if (pr.first != null && pr.first.equals(pr.last) && pr.firstIncluding && pr.lastIncluding) {
                    return new TermQuery(new Term(pr.propertyName, first));
                }
                if (pr.first != null && pr.last != null) {
                    return TermRangeQuery.newStringRange((String)pr.propertyName, (String)first, (String)last, (boolean)pr.firstIncluding, (boolean)pr.lastIncluding);
                }
                if (pr.first != null && pr.last == null) {
                    return TermRangeQuery.newStringRange((String)pr.propertyName, (String)first, null, (boolean)pr.firstIncluding, (boolean)true);
                }
                if (pr.last != null && !pr.last.equals(pr.first)) {
                    return TermRangeQuery.newStringRange((String)pr.propertyName, null, (String)last, (boolean)true, (boolean)pr.lastIncluding);
                }
                if (pr.list != null) {
                    BooleanQuery in = new BooleanQuery();
                    for (PropertyValue value : pr.list) {
                        String strVal = value.getValue(Type.STRING);
                        in.add((Query)new TermQuery(new Term(pr.propertyName, strVal)), BooleanClause.Occur.SHOULD);
                    }
                    return in;
                }
                if (!pr.isNotNullRestriction()) break;
                return new TermRangeQuery(pr.propertyName, null, null, true, true);
            }
        }
        throw new IllegalStateException("PropertyRestriction not handled " + pr + " for index " + defn);
    }

    private static void addReferenceConstraint(String uuid, List<Query> qs, IndexReader reader) {
        if (reader == null) {
            qs.add((Query)new TermQuery(new Term("*", uuid)));
            return;
        }
        BooleanQuery bq = new BooleanQuery();
        Collection fields = MultiFields.getIndexedFields((IndexReader)reader);
        for (String f : fields) {
            bq.add((Query)new TermQuery(new Term(f, uuid)), BooleanClause.Occur.SHOULD);
        }
        qs.add((Query)bq);
    }

    private static void addNodeTypeConstraints(IndexDefinition.IndexingRule defn, List<Query> qs, Filter filter) {
        PropertyDefinition mixinType;
        BooleanQuery bq = new BooleanQuery();
        PropertyDefinition primaryType = defn.getConfig("jcr:primaryType");
        if (primaryType != null && primaryType.propertyIndex) {
            for (String type : filter.getPrimaryTypes()) {
                bq.add((Query)new TermQuery(new Term("jcr:primaryType", type)), BooleanClause.Occur.SHOULD);
            }
        }
        if ((mixinType = defn.getConfig("jcr:mixinTypes")) != null && mixinType.propertyIndex) {
            for (String type : filter.getMixinTypes()) {
                bq.add((Query)new TermQuery(new Term("jcr:mixinTypes", type)), BooleanClause.Occur.SHOULD);
            }
        }
        if (bq.clauses().size() != 0) {
            qs.add((Query)bq);
        }
    }

    static Query getFullTextQuery(final QueryIndex.IndexPlan plan, FullTextExpression ft, final Analyzer analyzer, final IndexReader reader) {
        final IndexPlanner.PlanResult pr = LucenePropertyIndex.getPlanResult(plan);
        final AtomicReference result = new AtomicReference();
        ft.accept(new FullTextVisitor(){

            @Override
            public boolean visit(FullTextOr or) {
                BooleanQuery q = new BooleanQuery();
                for (FullTextExpression e : or.list) {
                    Query x = LucenePropertyIndex.getFullTextQuery(plan, e, analyzer, reader);
                    q.add(x, BooleanClause.Occur.SHOULD);
                }
                result.set(q);
                return true;
            }

            @Override
            public boolean visit(FullTextAnd and) {
                BooleanQuery q = new BooleanQuery();
                for (FullTextExpression e : and.list) {
                    BooleanQuery bq;
                    Query x = LucenePropertyIndex.getFullTextQuery(plan, e, analyzer, reader);
                    boolean hasMustNot = false;
                    if (x instanceof BooleanQuery && (bq = (BooleanQuery)x).getClauses().length == 1 && bq.getClauses()[0].getOccur() == BooleanClause.Occur.MUST_NOT) {
                        hasMustNot = true;
                        q.add(bq.getClauses()[0]);
                    }
                    if (hasMustNot) continue;
                    q.add(x, BooleanClause.Occur.MUST);
                }
                result.set(q);
                return true;
            }

            @Override
            public boolean visit(FullTextTerm term) {
                Query q;
                String p = term.getPropertyName();
                if (p != null) {
                    p = LucenePropertyIndex.getLuceneFieldName(p, pr);
                }
                if ((q = LucenePropertyIndex.tokenToQuery(term.getText(), p, analyzer, reader)) == null) {
                    return false;
                }
                String boost = term.getBoost();
                if (boost != null) {
                    q.setBoost(Float.parseFloat(boost));
                }
                if (term.isNot()) {
                    BooleanQuery bq = new BooleanQuery();
                    bq.add(q, BooleanClause.Occur.MUST_NOT);
                    result.set(bq);
                } else {
                    result.set(q);
                }
                return true;
            }
        });
        return (Query)result.get();
    }

    static String getLuceneFieldName(String p, IndexPlanner.PlanResult pr) {
        if (LucenePropertyIndex.isNodePath(p)) {
            p = pr.isPathTransformed() ? PathUtils.getName(p) : FieldNames.createFulltextFieldName(PathUtils.getParentPath(p));
        } else {
            if (pr.isPathTransformed()) {
                p = PathUtils.getName(p);
            }
            p = FieldNames.createAnalyzedFieldName(p);
        }
        return p;
    }

    static Query tokenToQuery(String text, String fieldName, Analyzer analyzer, IndexReader reader) {
        if (analyzer == null) {
            return null;
        }
        List<String> tokens = LucenePropertyIndex.tokenize(text, analyzer);
        if (tokens.isEmpty()) {
            return new BooleanQuery();
        }
        if (tokens.size() == 1) {
            String token = tokens.iterator().next();
            if (LucenePropertyIndex.hasFulltextToken(token)) {
                return new WildcardQuery(TermFactory.newFulltextTerm(token, fieldName));
            }
            return new TermQuery(TermFactory.newFulltextTerm(token, fieldName));
        }
        if (LucenePropertyIndex.hasFulltextToken(tokens)) {
            MultiPhraseQuery mpq = new MultiPhraseQuery();
            for (String token : tokens) {
                if (LucenePropertyIndex.hasFulltextToken(token)) {
                    Term[] terms = LucenePropertyIndex.extractMatchingTokens(reader, fieldName, token);
                    if (terms == null || terms.length <= 0) continue;
                    mpq.add(terms);
                    continue;
                }
                mpq.add(TermFactory.newFulltextTerm(token, fieldName));
            }
            return mpq;
        }
        PhraseQuery pq = new PhraseQuery();
        for (String t : tokens) {
            pq.add(TermFactory.newFulltextTerm(t, fieldName));
        }
        return pq;
    }

    private static Term[] extractMatchingTokens(IndexReader reader, String fieldName, String token) {
        if (reader == null) {
            return null;
        }
        try {
            BytesRef text;
            ArrayList<Term> terms = new ArrayList<Term>();
            Term onTerm = TermFactory.newFulltextTerm(token, fieldName);
            Terms t = MultiFields.getTerms((IndexReader)reader, (String)onTerm.field());
            Automaton a = WildcardQuery.toAutomaton((Term)onTerm);
            CompiledAutomaton ca = new CompiledAutomaton(a);
            TermsEnum te = ca.getTermsEnum(t);
            while ((text = te.next()) != null) {
                terms.add(TermFactory.newFulltextTerm(text.utf8ToString(), fieldName));
            }
            return terms.toArray(new Term[terms.size()]);
        }
        catch (IOException e) {
            LOG.error("Building fulltext query failed", (Object)e.getMessage());
            return null;
        }
    }

    private static boolean hasFulltextToken(List<String> tokens) {
        for (String token : tokens) {
            if (!LucenePropertyIndex.hasFulltextToken(token)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasFulltextToken(String token) {
        for (char c : fulltextTokens) {
            if (token.indexOf(c) == -1) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<String> tokenize(String text, Analyzer analyzer) {
        ArrayList<String> tokens = new ArrayList<String>();
        TokenStream stream = null;
        try {
            stream = analyzer.tokenStream(":fulltext", (Reader)new StringReader(text));
            CharTermAttribute termAtt = (CharTermAttribute)stream.addAttribute(CharTermAttribute.class);
            OffsetAttribute offsetAtt = (OffsetAttribute)stream.addAttribute(OffsetAttribute.class);
            stream.reset();
            int poz = 0;
            boolean hasFulltextToken = false;
            StringBuilder token = new StringBuilder();
            while (stream.incrementToken()) {
                String term = termAtt.toString();
                int start = offsetAtt.startOffset();
                int end = offsetAtt.endOffset();
                if (start > poz) {
                    for (int i = poz; i < start; ++i) {
                        for (char c : fulltextTokens) {
                            if (c != text.charAt(i)) continue;
                            token.append(c);
                            hasFulltextToken = true;
                        }
                    }
                }
                poz = end;
                if (hasFulltextToken) {
                    token.append(term);
                    hasFulltextToken = false;
                    continue;
                }
                if (token.length() > 0) {
                    tokens.add(token.toString());
                }
                token = new StringBuilder();
                token.append(term);
            }
            if (poz < text.length()) {
                for (int i = poz; i < text.length(); ++i) {
                    for (char c : fulltextTokens) {
                        if (c != text.charAt(i)) continue;
                        token.append(c);
                    }
                }
            }
            if (token.length() > 0) {
                tokens.add(token.toString());
            }
            stream.end();
        }
        catch (IOException e) {
            LOG.error("Building fulltext query failed", (Object)e.getMessage());
            List<String> list = null;
            return list;
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {}
        }
        return tokens;
    }

    private static String getPathRestriction(QueryIndex.IndexPlan plan) {
        Filter f = plan.getFilter();
        String pathPrefix = plan.getPathPrefix();
        if (pathPrefix.isEmpty()) {
            return f.getPath();
        }
        String relativePath = PathUtils.relativize(pathPrefix, f.getPath());
        return "/" + relativePath;
    }

    private static Query newDepthQuery(String path) {
        int depth = PathUtils.getDepth(path) + 1;
        return NumericRangeQuery.newIntRange((String)":depth", (Integer)depth, (Integer)depth, (boolean)true, (boolean)true);
    }

    private static class PathStoredFieldVisitor
    extends StoredFieldVisitor {
        private String path;
        private boolean pathVisited;

        private PathStoredFieldVisitor() {
        }

        public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
            if (":path".equals(fieldInfo.name)) {
                return StoredFieldVisitor.Status.YES;
            }
            return this.pathVisited ? StoredFieldVisitor.Status.STOP : StoredFieldVisitor.Status.NO;
        }

        public void stringField(FieldInfo fieldInfo, String value) throws IOException {
            if (":path".equals(fieldInfo.name)) {
                this.path = value;
                this.pathVisited = true;
            }
        }

        public String getPath() {
            return this.path;
        }
    }

    static class LucenePathCursor
    implements Cursor {
        private final Cursor pathCursor;
        private final String pathPrefix;
        LuceneResultRow currentRow;

        LucenePathCursor(final Iterator<LuceneResultRow> it, QueryIndex.IndexPlan plan, QueryEngineSettings settings) {
            this.pathPrefix = plan.getPathPrefix();
            Iterator<String> pathIterator = new Iterator<String>(){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public String next() {
                    LucenePathCursor.this.currentRow = (LuceneResultRow)it.next();
                    return LucenePathCursor.this.currentRow.path;
                }

                @Override
                public void remove() {
                    it.remove();
                }
            };
            this.pathCursor = new Cursors.PathCursor(pathIterator, true, settings);
        }

        @Override
        public boolean hasNext() {
            return this.pathCursor.hasNext();
        }

        @Override
        public void remove() {
            this.pathCursor.remove();
        }

        @Override
        public IndexRow next() {
            final IndexRow pathRow = this.pathCursor.next();
            return new IndexRow(){

                @Override
                public String getPath() {
                    String sub = pathRow.getPath();
                    if (PathUtils.isAbsolute(sub)) {
                        return LucenePathCursor.this.pathPrefix + sub;
                    }
                    return PathUtils.concat(LucenePathCursor.this.pathPrefix, sub);
                }

                @Override
                public PropertyValue getValue(String columnName) {
                    if ("jcr:score".equals(columnName)) {
                        return PropertyValues.newDouble(LucenePathCursor.this.currentRow.score);
                    }
                    if ("rep:spellcheck()".equals(columnName)) {
                        return PropertyValues.newString(Iterables.toString(LucenePathCursor.this.currentRow.suggestWords));
                    }
                    return pathRow.getValue(columnName);
                }
            };
        }
    }

    static class LuceneResultRow {
        final String path;
        final double score;
        final Iterable<String> suggestWords;

        LuceneResultRow(String path, double score) {
            this.path = path;
            this.score = score;
            this.suggestWords = Collections.emptySet();
        }

        LuceneResultRow(Iterable<String> suggestWords) {
            this.path = "/";
            this.score = 1.0;
            this.suggestWords = suggestWords;
        }

        public String toString() {
            return String.format("%s (%1.2f)", this.path, this.score);
        }
    }
}

