/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import javax.annotation.CheckForNull;
import javax.jcr.PropertyType;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.plugins.index.lucene.IndexDefinition;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.ConfigUtil;
import org.apache.jackrabbit.oak.plugins.index.lucene.util.LuceneIndexHelper;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PropertyDefinition {
    private static final Logger log = LoggerFactory.getLogger(PropertyDefinition.class);
    static final float DEFAULT_BOOST = 1.0f;
    final String name;
    private final int propertyType;
    final float boost;
    final boolean isRegexp;
    final boolean index;
    final boolean stored;
    final boolean nodeScopeIndex;
    final boolean propertyIndex;
    final boolean analyzed;
    final boolean ordered;
    final boolean nullCheckEnabled;
    final int includedPropertyTypes;
    final boolean relative;
    final boolean useInSpellcheck;
    final String[] ancestors;
    @CheckForNull
    final String nonRelativeName;

    public PropertyDefinition(IndexDefinition.IndexingRule idxDefn, String nodeName, NodeState defn) {
        this.isRegexp = ConfigUtil.getOptionalValue(defn, "isRegexp", false);
        this.name = PropertyDefinition.getName(defn, nodeName);
        this.relative = PropertyDefinition.isRelativeProperty(this.name);
        this.boost = ConfigUtil.getOptionalValue(defn, "boost", 1.0f);
        this.index = ConfigUtil.getOptionalValue(defn, "index", true);
        this.stored = ConfigUtil.getOptionalValue(defn, "useInExcerpt", false);
        this.nodeScopeIndex = ConfigUtil.getOptionalValue(defn, "nodeScopeIndex", false);
        this.analyzed = ConfigUtil.getOptionalValue(defn, "analyzed", false);
        this.propertyIndex = ConfigUtil.getOptionalValue(defn, "propertyIndex", false);
        this.ordered = ConfigUtil.getOptionalValue(defn, "ordered", false);
        this.includedPropertyTypes = IndexDefinition.getSupportedTypes(defn, "oak.experimental.includePropertyTypes", -1);
        this.propertyType = PropertyDefinition.getPropertyType(idxDefn, this.name, defn);
        this.nullCheckEnabled = ConfigUtil.getOptionalValue(defn, "nullCheckEnabled", false);
        this.nonRelativeName = this.determineNonRelativeName();
        this.ancestors = PropertyDefinition.computeAncestors(this.name);
        this.useInSpellcheck = ConfigUtil.getOptionalValue(defn, "useInSpellcheck", false);
        this.validate();
    }

    public boolean skipTokenization(String propertyName) {
        if (this.isRegexp && LuceneIndexHelper.skipTokenization(propertyName)) {
            return true;
        }
        return !this.analyzed;
    }

    public boolean fulltextEnabled() {
        return this.index && (this.analyzed || this.nodeScopeIndex);
    }

    public boolean propertyIndexEnabled() {
        return this.index && this.propertyIndex;
    }

    public boolean isTypeDefined() {
        return this.propertyType != 0;
    }

    public int getType() {
        return this.isTypeDefined() ? this.propertyType : 1;
    }

    public boolean includePropertyType(int type) {
        return IndexDefinition.includePropertyType(this.includedPropertyTypes, type);
    }

    public String toString() {
        return "PropertyDefinition{name='" + this.name + '\'' + ", propertyType=" + this.propertyType + ", boost=" + this.boost + ", isRegexp=" + this.isRegexp + ", index=" + this.index + ", stored=" + this.stored + ", nodeScopeIndex=" + this.nodeScopeIndex + ", propertyIndex=" + this.propertyIndex + ", analyzed=" + this.analyzed + ", ordered=" + this.ordered + ", nullCheckEnabled=" + this.nullCheckEnabled + ", useInSpellcheck=" + this.useInSpellcheck + '}';
    }

    static boolean isRelativeProperty(String propertyName) {
        return !PathUtils.isAbsolute(propertyName) && PathUtils.getNextSlash(propertyName, 0) > 0;
    }

    private void validate() {
        if (this.nullCheckEnabled && this.isRegexp) {
            throw new IllegalStateException(String.format("%s can be set to true for property definition using regular expression", "nullCheckEnabled"));
        }
    }

    private String determineNonRelativeName() {
        if (this.isRegexp) {
            return null;
        }
        if (!this.relative) {
            return this.name;
        }
        return PathUtils.getName(this.name);
    }

    private static String[] computeAncestors(String parentPath) {
        return (String[])Iterables.toArray((Iterable)ImmutableList.copyOf(PathUtils.elements(PathUtils.getParentPath(parentPath))), String.class);
    }

    private static String getName(NodeState definition, String defaultName) {
        PropertyState ps = definition.getProperty("name");
        return ps == null ? defaultName : ps.getValue(Type.STRING);
    }

    private static int getPropertyType(IndexDefinition.IndexingRule idxDefn, String name, NodeState defn) {
        int type = 0;
        if (defn.hasProperty("type")) {
            String typeName = defn.getString("type");
            try {
                type = PropertyType.valueFromName((String)typeName);
            }
            catch (IllegalArgumentException e) {
                log.warn("Invalid property type {} for property {} in Index {}", new Object[]{typeName, name, idxDefn});
            }
        }
        return type;
    }
}

