/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.index.lucene.util;

import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.spell.DirectSpellChecker;
import org.apache.lucene.search.spell.SuggestWord;

public class SpellcheckHelper {
    public static SuggestWord[] getSpellcheck(SpellcheckQuery spellcheckQuery) {
        try {
            DirectSpellChecker spellChecker = new DirectSpellChecker();
            return spellChecker.suggestSimilar(spellcheckQuery.getTerm(), spellcheckQuery.getCount(), spellcheckQuery.getReader());
        }
        catch (Exception e) {
            throw new RuntimeException("could not handle Spellcheck query " + spellcheckQuery, e);
        }
    }

    public static SpellcheckQuery getSpellcheckQuery(String spellcheckQueryString, IndexReader reader) {
        String text = null;
        for (String param : spellcheckQueryString.split("&")) {
            String[] keyValuePair = param.split("=");
            if (keyValuePair.length != 2 || keyValuePair[0] == null || keyValuePair[1] == null) {
                throw new RuntimeException("Unparsable native Lucene Spellcheck query: " + spellcheckQueryString);
            }
            if (!"term".equals(keyValuePair[0])) continue;
            text = keyValuePair[1];
        }
        return new SpellcheckQuery(new Term(":spellcheck", text), 10, reader);
    }

    public static class SpellcheckQuery {
        private final Term term;
        private final int count;
        private final IndexReader reader;

        public SpellcheckQuery(Term term, int count, IndexReader reader) {
            this.term = term;
            this.count = count;
            this.reader = reader;
        }

        public Term getTerm() {
            return this.term;
        }

        public int getCount() {
            return this.count;
        }

        public IndexReader getReader() {
            return this.reader;
        }

        public String toString() {
            return "SpellcheckQuery{term=" + this.term + ", count=" + this.count + '}';
        }
    }
}

