/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.memory;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.plugins.memory.ArrayBasedBlob;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeBuilder;
import org.apache.jackrabbit.oak.plugins.memory.ModifiedNodeState;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.Observable;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.jackrabbit.oak.spi.state.ConflictAnnotatingRebaseDiff;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.spi.state.NodeStoreBranch;

public class MemoryNodeStore
implements NodeStore,
Observable {
    private final AtomicReference<NodeState> root;
    private final Map<String, NodeState> checkpoints = Maps.newHashMap();
    private final Map<Closeable, Observer> observers = Maps.newHashMap();

    public MemoryNodeStore(NodeState state) {
        this.root = new AtomicReference<NodeState>(state);
    }

    public MemoryNodeStore() {
        this(EmptyNodeState.EMPTY_NODE);
    }

    public String toString() {
        return this.getRoot().toString();
    }

    @Override
    public synchronized Closeable addObserver(Observer observer) {
        observer.contentChanged(this.getRoot(), null);
        Closeable closeable = new Closeable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                MemoryNodeStore memoryNodeStore = MemoryNodeStore.this;
                synchronized (memoryNodeStore) {
                    MemoryNodeStore.this.observers.remove(this);
                }
            }
        };
        this.observers.put(closeable, observer);
        return closeable;
    }

    private synchronized void setRoot(NodeState root, CommitInfo info) {
        this.root.getAndSet(root);
        for (Observer observer : this.observers.values()) {
            observer.contentChanged(root, info);
        }
    }

    @Override
    public NodeState getRoot() {
        return this.root.get();
    }

    @Override
    public synchronized NodeState merge(@Nonnull NodeBuilder builder, @Nonnull CommitHook commitHook, @Nullable CommitInfo info) throws CommitFailedException {
        Preconditions.checkArgument((boolean)(builder instanceof MemoryNodeBuilder));
        Preconditions.checkNotNull((Object)commitHook);
        this.rebase(builder);
        MemoryNodeStoreBranch branch = new MemoryNodeStoreBranch(this, this.getRoot());
        branch.setRoot(builder.getNodeState());
        NodeState merged = branch.merge(commitHook, info);
        ((MemoryNodeBuilder)builder).reset(merged);
        return merged;
    }

    @Override
    public NodeState rebase(@Nonnull NodeBuilder builder) {
        Preconditions.checkArgument((boolean)(builder instanceof MemoryNodeBuilder));
        NodeState head = ((NodeBuilder)Preconditions.checkNotNull((Object)builder)).getNodeState();
        NodeState base = builder.getBaseState();
        NodeState newBase = this.getRoot();
        if (base != newBase) {
            ((MemoryNodeBuilder)builder).reset(newBase);
            head.compareAgainstBaseState(base, new ConflictAnnotatingRebaseDiff(builder));
            head = builder.getNodeState();
        }
        return head;
    }

    @Override
    public NodeState reset(@Nonnull NodeBuilder builder) {
        Preconditions.checkArgument((boolean)(builder instanceof MemoryNodeBuilder));
        NodeState head = this.getRoot();
        ((MemoryNodeBuilder)builder).reset(head);
        return head;
    }

    @Override
    public ArrayBasedBlob createBlob(InputStream inputStream) throws IOException {
        try {
            ArrayBasedBlob arrayBasedBlob = new ArrayBasedBlob(ByteStreams.toByteArray((InputStream)inputStream));
            return arrayBasedBlob;
        }
        finally {
            inputStream.close();
        }
    }

    @Override
    public Blob getBlob(@Nonnull String reference) {
        return null;
    }

    @Override
    @Nonnull
    public synchronized String checkpoint(long lifetime) {
        Preconditions.checkArgument((lifetime > 0L ? 1 : 0) != 0);
        String checkpoint = "checkpoint" + this.checkpoints.size();
        this.checkpoints.put(checkpoint, this.getRoot());
        return checkpoint;
    }

    @Override
    @CheckForNull
    public synchronized NodeState retrieve(@Nonnull String checkpoint) {
        return this.checkpoints.get(Preconditions.checkNotNull((Object)checkpoint));
    }

    @Override
    public synchronized boolean release(String checkpoint) {
        this.checkpoints.remove(checkpoint);
        return true;
    }

    public synchronized Set<String> listCheckpoints() {
        return this.checkpoints.keySet();
    }

    private static class MemoryNodeStoreBranch
    implements NodeStoreBranch {
        private final MemoryNodeStore store;
        private final NodeState base;
        private volatile NodeState root;

        public MemoryNodeStoreBranch(MemoryNodeStore store, NodeState base) {
            this.store = store;
            this.base = base;
            this.root = base;
        }

        @Override
        public NodeState getBase() {
            return this.base;
        }

        @Override
        public NodeState getHead() {
            this.checkNotMerged();
            return this.root;
        }

        @Override
        public void setRoot(NodeState newRoot) {
            this.checkNotMerged();
            this.root = ModifiedNodeState.squeeze(newRoot);
        }

        @Override
        public NodeState merge(@Nonnull CommitHook hook, @Nonnull CommitInfo info) throws CommitFailedException {
            Preconditions.checkNotNull((Object)hook);
            Preconditions.checkNotNull((Object)info);
            this.checkNotMerged();
            NodeState merged = ModifiedNodeState.squeeze(hook.processCommit(this.base, this.root, info));
            this.store.setRoot(merged, info);
            this.root = null;
            return merged;
        }

        @Override
        public void rebase() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.root.toString();
        }

        private void checkNotMerged() {
            Preconditions.checkState((this.root != null ? 1 : 0) != 0, (Object)"Branch has already been merged");
        }
    }
}

