/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.nodetype;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Set;
import javax.jcr.Value;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.identifier.IdentifierManager;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.nodetype.EffectiveType;
import org.apache.jackrabbit.oak.plugins.nodetype.constraint.Constraints;
import org.apache.jackrabbit.oak.plugins.value.ValueFactoryImpl;
import org.apache.jackrabbit.oak.spi.commit.DefaultEditor;
import org.apache.jackrabbit.oak.spi.commit.Editor;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TypeEditor
extends DefaultEditor {
    private static final Logger log = LoggerFactory.getLogger(TypeEditor.class);
    private final boolean strict;
    private final Set<String> typesToCheck;
    private final boolean checkThisNode;
    private final TypeEditor parent;
    private final String nodeName;
    private final NodeState types;
    private final EffectiveType effective;
    private final NodeBuilder builder;

    TypeEditor(boolean strict, Set<String> typesToCheck, NodeState types, String primary, Iterable<String> mixins, NodeBuilder builder) throws CommitFailedException {
        this.strict = strict;
        this.typesToCheck = typesToCheck;
        this.checkThisNode = typesToCheck == null || typesToCheck.contains(primary) || Iterables.any(mixins, (Predicate)Predicates.in(typesToCheck));
        this.parent = null;
        this.nodeName = null;
        this.types = (NodeState)Preconditions.checkNotNull((Object)types);
        this.effective = this.getEffectiveType(null, null, primary, mixins);
        this.builder = (NodeBuilder)Preconditions.checkNotNull((Object)builder);
    }

    private TypeEditor(TypeEditor parent, String name, String primary, Iterable<String> mixins, NodeBuilder builder) throws CommitFailedException {
        this.strict = parent.strict;
        this.typesToCheck = parent.typesToCheck;
        this.checkThisNode = this.typesToCheck == null || this.typesToCheck.contains(primary) || Iterables.any(mixins, (Predicate)Predicates.in(this.typesToCheck));
        this.parent = (TypeEditor)Preconditions.checkNotNull((Object)parent);
        this.nodeName = (String)Preconditions.checkNotNull((Object)name);
        this.types = parent.types;
        this.effective = this.getEffectiveType(parent.effective, name, primary, mixins);
        this.builder = (NodeBuilder)Preconditions.checkNotNull((Object)builder);
    }

    TypeEditor(EffectiveType effective) {
        this.strict = true;
        this.typesToCheck = null;
        this.checkThisNode = true;
        this.parent = null;
        this.nodeName = null;
        this.types = EmptyNodeState.EMPTY_NODE;
        this.effective = (EffectiveType)Preconditions.checkNotNull((Object)effective);
        this.builder = EmptyNodeState.EMPTY_NODE.builder();
    }

    private void constraintViolation(int code, String message) throws CommitFailedException {
        String path = this.getPath();
        if (this.effective != null) {
            path = path + "[" + this.effective + "]";
        }
        CommitFailedException exception = new CommitFailedException("Constraint", code, path + ": " + message);
        if (this.strict) {
            throw exception;
        }
        log.warn(exception.getMessage());
    }

    private String getPath() {
        if (this.parent == null) {
            return "/";
        }
        if (this.parent.parent == null) {
            return "/" + this.nodeName;
        }
        return this.parent.getPath() + "/" + this.nodeName;
    }

    @Override
    public void propertyAdded(PropertyState after) throws CommitFailedException {
        this.propertyChanged(null, after);
    }

    @Override
    public void propertyChanged(PropertyState before, PropertyState after) throws CommitFailedException {
        if (this.checkThisNode) {
            NodeState definition = this.effective.getDefinition(after);
            if (definition == null) {
                this.constraintViolation(4, "No matching property definition found for " + after);
            } else if ("jcr:uuid".equals(after.getName()) && this.effective.isNodeType("mix:referenceable")) {
                if (!IdentifierManager.isValidUUID(after.getValue(Type.STRING))) {
                    this.constraintViolation(12, "Invalid UUID value in the jcr:uuid property");
                }
            } else {
                this.checkValueConstraints(definition, after);
            }
        }
    }

    @Override
    public void propertyDeleted(PropertyState before) throws CommitFailedException {
        String name = before.getName();
        if (this.checkThisNode && this.effective.isMandatoryProperty(name)) {
            this.constraintViolation(22, "Mandatory property " + name + " can not be removed");
        }
    }

    @Override
    public Editor childNodeAdded(String name, NodeState after) throws CommitFailedException {
        TypeEditor editor = this.childNodeChanged(name, EmptyNodeState.MISSING_NODE, after);
        if (editor.checkThisNode) {
            for (String property : editor.effective.getMandatoryProperties()) {
                if (after.hasProperty(property)) continue;
                editor.constraintViolation(21, "Mandatory property " + property + " not found in a new node");
            }
            for (String child : editor.effective.getMandatoryChildNodes()) {
                if (after.hasChildNode(child)) continue;
                editor.constraintViolation(25, "Mandatory child node " + child + " not found in a new node");
            }
        }
        return editor;
    }

    @Override
    public TypeEditor childNodeChanged(String name, NodeState before, NodeState after) throws CommitFailedException {
        String primary = after.getName("jcr:primaryType");
        Iterable<String> mixins = after.getNames("jcr:mixinTypes");
        NodeBuilder childBuilder = this.builder.getChildNode(name);
        if (primary == null && this.effective != null) {
            primary = this.effective.getDefaultType(name);
            if (primary != null) {
                this.builder.setProperty("jcr:primaryType", primary, Type.NAME);
            } else {
                this.constraintViolation(4, "No default primary type available  for child node " + name);
            }
        }
        TypeEditor editor = new TypeEditor(this, name, primary, mixins, childBuilder);
        if (this.checkThisNode && !this.effective.isValidChildNode(name, editor.effective)) {
            this.constraintViolation(1, "No matching definition found for child node " + name + " with effective type " + editor.effective);
        }
        return editor;
    }

    @Override
    public Editor childNodeDeleted(String name, NodeState before) throws CommitFailedException {
        if (this.checkThisNode && this.effective.isMandatoryChildNode(name)) {
            this.constraintViolation(26, "Mandatory child node " + name + " can not be removed");
        }
        return null;
    }

    private EffectiveType getEffectiveType(EffectiveType parent, String name, String primary, Iterable<String> mixins) throws CommitFailedException {
        ArrayList list = Lists.newArrayList();
        NodeState type = this.types.getChildNode(primary);
        if (!type.exists()) {
            this.constraintViolation(1, "The primary type " + primary + " does not exist");
        } else if (type.getBoolean("jcr:isMixin")) {
            this.constraintViolation(2, "Mixin type " + primary + " used as the primary type");
        } else {
            if (type.getBoolean("jcr:isAbstract")) {
                if (parent != null && primary.equals(parent.getDefaultType(name))) {
                    log.warn("Abstract type " + primary + " used as the default primary type of node " + this.getPath());
                } else {
                    this.constraintViolation(2, "Abstract type " + primary + " used as the primary type");
                }
            }
            list.add(type);
        }
        for (String mixin : mixins) {
            type = this.types.getChildNode(mixin);
            if (!type.exists()) {
                this.constraintViolation(5, "The mixin type " + mixin + " does not exist");
                continue;
            }
            if (!type.getBoolean("jcr:isMixin")) {
                this.constraintViolation(6, "Primary type " + mixin + " used as a mixin type");
                continue;
            }
            if (type.getBoolean("jcr:isAbstract")) {
                this.constraintViolation(7, "Abstract type " + mixin + " used as a mixin type");
                continue;
            }
            list.add(type);
        }
        return new EffectiveType(list);
    }

    private void checkValueConstraints(NodeState definition, PropertyState property) throws CommitFailedException {
        int type;
        if (property.count() == 0) {
            return;
        }
        PropertyState constraints = definition.getProperty("jcr:valueConstraints");
        if (constraints == null || constraints.count() == 0) {
            return;
        }
        PropertyState required = definition.getProperty("jcr:requiredType");
        if (required == null) {
            return;
        }
        String value = required.getValue(Type.STRING);
        if ("BINARY".equals(value)) {
            type = 2;
        } else if ("BOOLEAN".equals(value)) {
            type = 6;
        } else if ("DATE".equals(value)) {
            type = 5;
        } else if ("DECIMAL".equals(value)) {
            type = 12;
        } else if ("DOUBLE".equals(value)) {
            type = 4;
        } else if ("LONG".equals(value)) {
            type = 3;
        } else if ("NAME".equals(value)) {
            type = 7;
        } else if ("PATH".equals(value)) {
            type = 8;
        } else if ("REFERENCE".equals(value)) {
            type = 9;
        } else if ("STRING".equals(value)) {
            type = 1;
        } else if ("URI".equals(value)) {
            type = 11;
        } else if ("WEAKREFERENCE".equals(value)) {
            type = 10;
        } else {
            return;
        }
        for (String constraint : constraints.getValue(Type.STRINGS)) {
            Predicate predicate = Constraints.valueConstraint((int)type, (String)constraint);
            for (Value v : ValueFactoryImpl.createValues(property, NamePathMapper.DEFAULT)) {
                if (!predicate.apply((Object)v)) continue;
                return;
            }
        }
        this.constraintViolation(5, "Value constraint violation in " + property);
    }
}

