/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.observation.filter;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.core.ImmutableRoot;
import org.apache.jackrabbit.oak.plugins.nodetype.TypePredicate;
import org.apache.jackrabbit.oak.plugins.observation.filter.ACFilter;
import org.apache.jackrabbit.oak.plugins.observation.filter.AddSubtreeFilter;
import org.apache.jackrabbit.oak.plugins.observation.filter.ConstantFilter;
import org.apache.jackrabbit.oak.plugins.observation.filter.DeleteSubtreeFilter;
import org.apache.jackrabbit.oak.plugins.observation.filter.EventFilter;
import org.apache.jackrabbit.oak.plugins.observation.filter.EventTypeFilter;
import org.apache.jackrabbit.oak.plugins.observation.filter.FilterProvider;
import org.apache.jackrabbit.oak.plugins.observation.filter.Filters;
import org.apache.jackrabbit.oak.plugins.observation.filter.GlobbingPathFilter;
import org.apache.jackrabbit.oak.plugins.observation.filter.MoveFilter;
import org.apache.jackrabbit.oak.plugins.observation.filter.PermissionProviderFactory;
import org.apache.jackrabbit.oak.plugins.observation.filter.PropertyPredicate;
import org.apache.jackrabbit.oak.plugins.observation.filter.UniversalFilter;
import org.apache.jackrabbit.oak.plugins.observation.filter.UuidPredicate;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public final class FilterBuilder {
    private static final int ALL_EVENTS = 127;
    private boolean includeSessionLocal;
    private boolean includeClusterExternal;
    private boolean includeClusterLocal = true;
    private final List<String> subTrees = Lists.newArrayList();
    private Condition condition = this.includeAll();

    @Nonnull
    public FilterBuilder addSubTree(@Nonnull String absPath) {
        if (absPath.endsWith("/")) {
            absPath = absPath.substring(0, absPath.length() - 1);
        }
        for (String path : this.subTrees) {
            if (!path.equals(absPath) && !PathUtils.isAncestor(path, absPath)) continue;
            return this;
        }
        this.subTrees.add((String)Preconditions.checkNotNull((Object)absPath));
        return this;
    }

    @Nonnull
    private Iterable<String> getSubTrees() {
        return this.subTrees.isEmpty() ? ImmutableList.of((Object)"/") : this.subTrees;
    }

    @Nonnull
    public FilterBuilder includeSessionLocal(boolean include) {
        this.includeSessionLocal = include;
        return this;
    }

    @Nonnull
    public FilterBuilder includeClusterExternal(boolean include) {
        this.includeClusterExternal = include;
        return this;
    }

    @Nonnull
    public FilterBuilder includeClusterLocal(boolean include) {
        this.includeClusterLocal = include;
        return this;
    }

    @Nonnull
    public FilterBuilder condition(@Nonnull Condition condition) {
        this.condition = (Condition)Preconditions.checkNotNull((Object)condition);
        return this;
    }

    @Nonnull
    public Condition includeAll() {
        return ConstantCondition.INCLUDE_ALL;
    }

    @Nonnull
    public Condition excludeAll() {
        return ConstantCondition.EXCLUDE_ALL;
    }

    @Nonnull
    public Condition accessControl(@Nonnull PermissionProviderFactory permissionProviderFactory) {
        return new ACCondition((PermissionProviderFactory)Preconditions.checkNotNull((Object)permissionProviderFactory));
    }

    @Nonnull
    public Condition path(@Nonnull String pathPattern) {
        return new PathCondition((String)Preconditions.checkNotNull((Object)pathPattern));
    }

    @Nonnull
    public Condition eventType(int eventTypes) {
        if ((0x7F & eventTypes) == 0) {
            return this.excludeAll();
        }
        if ((0x7F & eventTypes) != 127) {
            return new EventTypeCondition(eventTypes);
        }
        return this.includeAll();
    }

    @Nonnull
    public Condition nodeType(@Nonnull UniversalFilter.Selector selector, @CheckForNull String[] ntNames) {
        if (ntNames == null) {
            return this.includeAll();
        }
        if (ntNames.length == 0) {
            return this.excludeAll();
        }
        return new NodeTypeCondition((UniversalFilter.Selector)Preconditions.checkNotNull((Object)selector), ntNames);
    }

    @Nonnull
    public Condition uuid(@Nonnull UniversalFilter.Selector selector, @CheckForNull String[] uuids) {
        if (uuids == null) {
            return this.includeAll();
        }
        if (uuids.length == 0) {
            return this.excludeAll();
        }
        return new UniversalCondition((UniversalFilter.Selector)Preconditions.checkNotNull((Object)selector), new UuidPredicate(uuids));
    }

    @Nonnull
    public Condition property(@Nonnull UniversalFilter.Selector selector, @Nonnull String name, @Nonnull Predicate<PropertyState> predicate) {
        return new UniversalCondition((UniversalFilter.Selector)Preconditions.checkNotNull((Object)selector), new PropertyPredicate((String)Preconditions.checkNotNull((Object)name), (Predicate<PropertyState>)((Predicate)Preconditions.checkNotNull(predicate))));
    }

    @Nonnull
    public Condition universal(@Nonnull UniversalFilter.Selector selector, @Nonnull Predicate<NodeState> predicate) {
        return new UniversalCondition((UniversalFilter.Selector)Preconditions.checkNotNull((Object)selector), (Predicate<NodeState>)((Predicate)Preconditions.checkNotNull(predicate)));
    }

    @Nonnull
    public Condition addSubtree() {
        return new AddSubtreeTreeCondition();
    }

    @Nonnull
    public Condition deleteSubtree() {
        return new DeleteSubtreeTreeCondition();
    }

    @Nonnull
    public Condition moveSubtree() {
        return new MoveCondition();
    }

    @Nonnull
    public Condition any(Condition ... conditions) {
        return new AnyCondition((Condition[])Preconditions.checkNotNull((Object)conditions));
    }

    @Nonnull
    public Condition all(Condition ... conditions) {
        return new AllCondition((Condition[])Preconditions.checkNotNull((Object)conditions));
    }

    @Nonnull
    public Condition any(@Nonnull Iterable<Condition> conditions) {
        return new AnyCondition((Iterable)Preconditions.checkNotNull(conditions));
    }

    @Nonnull
    public Condition all(@Nonnull Iterable<Condition> conditions) {
        return new AllCondition((Iterable)Preconditions.checkNotNull(conditions));
    }

    @Nonnull
    public FilterProvider build() {
        return new FilterProvider(){
            final boolean includeSessionLocal;
            final boolean includeClusterExternal;
            final boolean includeClusterLocal;
            final Iterable<String> subTrees;
            final Condition condition;
            {
                this.includeSessionLocal = FilterBuilder.this.includeSessionLocal;
                this.includeClusterExternal = FilterBuilder.this.includeClusterExternal;
                this.includeClusterLocal = FilterBuilder.this.includeClusterLocal;
                this.subTrees = FilterBuilder.this.getSubTrees();
                this.condition = FilterBuilder.this.condition;
            }

            @Override
            public boolean includeCommit(@Nonnull String sessionId, @CheckForNull CommitInfo info) {
                return !(!this.includeSessionLocal && this.isLocal((String)Preconditions.checkNotNull((Object)sessionId), info) || !this.includeClusterExternal && this.isExternal(info) || !this.includeClusterLocal && !this.isExternal(info));
            }

            @Override
            @Nonnull
            public EventFilter getFilter(@Nonnull NodeState before, @Nonnull NodeState after) {
                return this.condition.createFilter((NodeState)Preconditions.checkNotNull((Object)before), (NodeState)Preconditions.checkNotNull((Object)after));
            }

            @Override
            @Nonnull
            public Iterable<String> getSubTrees() {
                return this.subTrees;
            }

            private boolean isLocal(String sessionId, CommitInfo info) {
                return info != null && Objects.equal((Object)info.getSessionId(), (Object)sessionId);
            }

            private boolean isExternal(CommitInfo info) {
                return info == null;
            }
        };
    }

    private static class AllCondition
    implements Condition {
        private final Iterable<Condition> conditions;

        public AllCondition(Iterable<Condition> conditions) {
            this.conditions = conditions;
        }

        public AllCondition(Condition ... conditions) {
            this(Lists.newArrayList((Object[])conditions));
        }

        @Override
        public EventFilter createFilter(NodeState before, NodeState after) {
            ArrayList filters = Lists.newArrayList();
            for (Condition condition : this.conditions) {
                if (condition == ConstantCondition.EXCLUDE_ALL) {
                    return ConstantFilter.EXCLUDE_ALL;
                }
                if (condition == ConstantCondition.INCLUDE_ALL) continue;
                filters.add(condition.createFilter(before, after));
            }
            return filters.isEmpty() ? ConstantFilter.INCLUDE_ALL : Filters.all(filters);
        }
    }

    private static class AnyCondition
    implements Condition {
        private final Iterable<Condition> conditions;

        public AnyCondition(Iterable<Condition> conditions) {
            this.conditions = conditions;
        }

        public AnyCondition(Condition ... conditions) {
            this(Lists.newArrayList((Object[])conditions));
        }

        @Override
        public EventFilter createFilter(NodeState before, NodeState after) {
            ArrayList filters = Lists.newArrayList();
            for (Condition condition : this.conditions) {
                if (condition == ConstantCondition.INCLUDE_ALL) {
                    return ConstantFilter.INCLUDE_ALL;
                }
                if (condition == ConstantCondition.EXCLUDE_ALL) continue;
                filters.add(condition.createFilter(before, after));
            }
            return filters.isEmpty() ? ConstantFilter.EXCLUDE_ALL : Filters.any(filters);
        }
    }

    protected static class MoveCondition
    implements Condition {
        protected MoveCondition() {
        }

        @Override
        @Nonnull
        public EventFilter createFilter(@Nonnull NodeState before, @Nonnull NodeState after) {
            return new MoveFilter();
        }
    }

    protected static class DeleteSubtreeTreeCondition
    implements Condition {
        protected DeleteSubtreeTreeCondition() {
        }

        @Override
        @Nonnull
        public EventFilter createFilter(@Nonnull NodeState before, @Nonnull NodeState after) {
            return DeleteSubtreeFilter.getInstance();
        }
    }

    protected static class AddSubtreeTreeCondition
    implements Condition {
        protected AddSubtreeTreeCondition() {
        }

        @Override
        @Nonnull
        public EventFilter createFilter(@Nonnull NodeState before, @Nonnull NodeState after) {
            return AddSubtreeFilter.getInstance();
        }
    }

    private static class UniversalCondition
    implements Condition {
        private final UniversalFilter.Selector selector;
        private final Predicate<NodeState> predicate;

        public UniversalCondition(UniversalFilter.Selector selector, Predicate<NodeState> predicate) {
            this.selector = selector;
            this.predicate = predicate;
        }

        @Override
        @Nonnull
        public EventFilter createFilter(NodeState before, NodeState after) {
            return new UniversalFilter(before, after, this.selector, this.predicate);
        }
    }

    private static class NodeTypeCondition
    implements Condition {
        private final UniversalFilter.Selector selector;
        private final String[] ntNames;

        public NodeTypeCondition(UniversalFilter.Selector selector, String[] ntNames) {
            this.selector = selector;
            this.ntNames = ntNames;
        }

        @Override
        public EventFilter createFilter(NodeState before, NodeState after) {
            TypePredicate predicate = new TypePredicate(after.exists() ? after : before, this.ntNames);
            return new UniversalFilter(before, after, this.selector, predicate);
        }
    }

    private static class EventTypeCondition
    implements Condition {
        private final int eventTypes;

        public EventTypeCondition(int eventTypes) {
            this.eventTypes = eventTypes;
        }

        @Override
        public EventFilter createFilter(NodeState before, NodeState after) {
            return new EventTypeFilter(this.eventTypes);
        }
    }

    private static class PathCondition
    implements Condition {
        private final String pathGlob;

        public PathCondition(String pathGlob) {
            this.pathGlob = pathGlob;
        }

        @Override
        public EventFilter createFilter(NodeState before, NodeState after) {
            return new GlobbingPathFilter(this.pathGlob);
        }
    }

    private static class ACCondition
    implements Condition {
        private final PermissionProviderFactory permissionProviderFactory;

        public ACCondition(PermissionProviderFactory permissionProviderFactory) {
            this.permissionProviderFactory = permissionProviderFactory;
        }

        @Override
        public EventFilter createFilter(NodeState before, NodeState after) {
            return new ACFilter(before, after, this.permissionProviderFactory.create((Root)new ImmutableRoot(after)));
        }
    }

    private static class ConstantCondition
    implements Condition {
        public static final ConstantCondition INCLUDE_ALL = new ConstantCondition(true);
        public static final ConstantCondition EXCLUDE_ALL = new ConstantCondition(false);
        private final boolean value;

        public ConstantCondition(boolean value) {
            this.value = value;
        }

        @Override
        public EventFilter createFilter(NodeState before, NodeState after) {
            return this.value ? Filters.includeAll() : Filters.excludeAll();
        }
    }

    public static interface Condition {
        @Nonnull
        public EventFilter createFilter(@Nonnull NodeState var1, @Nonnull NodeState var2);
    }
}

