/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment;

import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;

public class MergeDiff
implements NodeStateDiff {
    private final NodeBuilder builder;

    public MergeDiff(NodeBuilder builder) {
        this.builder = builder;
    }

    @Override
    public boolean propertyAdded(PropertyState after) {
        if (!this.builder.hasProperty(after.getName())) {
            this.builder.setProperty(after);
        }
        return true;
    }

    @Override
    public boolean propertyChanged(PropertyState before, PropertyState after) {
        PropertyState other = this.builder.getProperty(before.getName());
        if (other != null && other.equals(before)) {
            this.builder.setProperty(after);
        }
        return true;
    }

    @Override
    public boolean propertyDeleted(PropertyState before) {
        PropertyState other = this.builder.getProperty(before.getName());
        if (other != null && other.equals(before)) {
            this.builder.removeProperty(before.getName());
        }
        return true;
    }

    @Override
    public boolean childNodeAdded(String name, NodeState after) {
        if (!this.builder.hasChildNode(name)) {
            this.builder.setChildNode(name, after);
        }
        return true;
    }

    @Override
    public boolean childNodeChanged(String name, NodeState before, NodeState after) {
        if (this.builder.hasChildNode(name)) {
            after.compareAgainstBaseState(before, new MergeDiff(this.builder.child(name)));
        }
        return true;
    }

    @Override
    public boolean childNodeDeleted(String name, NodeState before) {
        if (this.builder.hasChildNode(name) && before.equals(this.builder.child(name).getNodeState())) {
            this.builder.getChildNode(name).remove();
        }
        return true;
    }
}

