/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment;

import java.util.UUID;
import org.apache.jackrabbit.oak.plugins.segment.Segment;
import org.apache.jackrabbit.oak.plugins.segment.SegmentTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentId
implements Comparable<SegmentId> {
    private static final Logger log = LoggerFactory.getLogger(SegmentId.class);
    private final SegmentTracker tracker;
    private final long msb;
    private final long lsb;
    private final long creationTime;
    private volatile Segment segment;

    public static boolean isDataSegmentId(long lsb) {
        return lsb >>> 60 == 10L;
    }

    private SegmentId(SegmentTracker tracker, long msb, long lsb, Segment segment, long creationTime) {
        this.tracker = tracker;
        this.msb = msb;
        this.lsb = lsb;
        this.segment = segment;
        this.creationTime = creationTime;
    }

    public SegmentId(SegmentTracker tracker, long msb, long lsb) {
        this(tracker, msb, lsb, null, System.currentTimeMillis());
    }

    public boolean isDataSegmentId() {
        return SegmentId.isDataSegmentId(this.lsb);
    }

    public boolean isBulkSegmentId() {
        return this.lsb >>> 60 == 11L;
    }

    public boolean equals(long msb, long lsb) {
        return this.msb == msb && this.lsb == lsb;
    }

    public long getMostSignificantBits() {
        return this.msb;
    }

    public long getLeastSignificantBits() {
        return this.lsb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Segment getSegment() {
        Segment segment = this.segment;
        if (segment == null) {
            SegmentId segmentId = this;
            synchronized (segmentId) {
                segment = this.segment;
                if (segment == null) {
                    log.debug("Loading segment {}", (Object)this);
                    segment = this.tracker.getSegment(this);
                }
            }
        }
        segment.access();
        return segment;
    }

    synchronized void setSegment(Segment segment) {
        this.segment = segment;
    }

    public SegmentTracker getTracker() {
        return this.tracker;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public int compareTo(SegmentId that) {
        int d = Long.valueOf(this.msb).compareTo(that.msb);
        if (d == 0) {
            d = Long.valueOf(this.lsb).compareTo(that.lsb);
        }
        return d;
    }

    public String toString() {
        return new UUID(this.msb, this.lsb).toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof SegmentId) {
            SegmentId that = (SegmentId)object;
            return this.msb == that.msb && this.lsb == that.lsb;
        }
        return false;
    }

    public int hashCode() {
        return (int)this.lsb;
    }
}

