/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment;

import java.io.IOException;
import java.io.InputStream;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeBuilder;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.plugins.segment.SegmentWriter;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public class SegmentNodeBuilder
extends MemoryNodeBuilder {
    private static final int UPDATE_LIMIT = Integer.getInteger("update.limit", 10000);
    private final SegmentWriter writer;
    private long updateCount;

    SegmentNodeBuilder(SegmentNodeState base) {
        this(base, base.getTracker().getWriter());
    }

    SegmentNodeBuilder(SegmentNodeState base, SegmentWriter writer) {
        super(base);
        this.writer = writer;
        this.updateCount = 0L;
    }

    SegmentNodeBuilder(SegmentNodeBuilder parent, String name, SegmentWriter writer) {
        super(parent, name);
        this.writer = writer;
        this.updateCount = -1L;
    }

    @Override
    protected void updated() {
        if (this.isChildBuilder()) {
            super.updated();
        } else {
            ++this.updateCount;
            if (this.updateCount > (long)UPDATE_LIMIT) {
                this.getNodeState();
            }
        }
    }

    private boolean isChildBuilder() {
        return this.updateCount < 0L;
    }

    @Override
    public SegmentNodeState getNodeState() {
        SegmentNodeState sstate;
        NodeState state = super.getNodeState();
        if (state != (sstate = this.writer.writeNode(state))) {
            this.set(sstate);
            this.updateCount = 0L;
        }
        return sstate;
    }

    @Override
    protected MemoryNodeBuilder createChildBuilder(String name) {
        return new SegmentNodeBuilder(this, name, this.writer);
    }

    @Override
    public Blob createBlob(InputStream stream) throws IOException {
        SegmentNodeState sns = this.getNodeState();
        return sns.getTracker().getWriter().writeStream(stream);
    }
}

