/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment;

public enum SegmentVersion {
    V_10(10),
    V_11(11);

    private final byte version;

    private SegmentVersion(byte version) {
        this.version = version;
    }

    public boolean onOrAfter(SegmentVersion other) {
        return this.compareTo(other) >= 0;
    }

    public static byte asByte(SegmentVersion v) {
        return v.version;
    }

    public static SegmentVersion fromByte(byte v) {
        if (v == SegmentVersion.V_11.version) {
            return V_11;
        }
        if (v == SegmentVersion.V_10.version) {
            return V_10;
        }
        throw new IllegalArgumentException("Unknown version " + v);
    }

    public static boolean isValid(byte v) {
        return v == SegmentVersion.V_10.version || v == SegmentVersion.V_11.version;
    }
}

