/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jackrabbit.oak.api.Blob;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.plugins.memory.ModifiedNodeState;
import org.apache.jackrabbit.oak.plugins.segment.MapEntry;
import org.apache.jackrabbit.oak.plugins.segment.MapRecord;
import org.apache.jackrabbit.oak.plugins.segment.PropertyTemplate;
import org.apache.jackrabbit.oak.plugins.segment.RecordId;
import org.apache.jackrabbit.oak.plugins.segment.RecordType;
import org.apache.jackrabbit.oak.plugins.segment.Segment;
import org.apache.jackrabbit.oak.plugins.segment.SegmentBlob;
import org.apache.jackrabbit.oak.plugins.segment.SegmentId;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.plugins.segment.SegmentOverflowException;
import org.apache.jackrabbit.oak.plugins.segment.SegmentPropertyState;
import org.apache.jackrabbit.oak.plugins.segment.SegmentStore;
import org.apache.jackrabbit.oak.plugins.segment.SegmentStream;
import org.apache.jackrabbit.oak.plugins.segment.SegmentTracker;
import org.apache.jackrabbit.oak.plugins.segment.SegmentVersion;
import org.apache.jackrabbit.oak.plugins.segment.Template;
import org.apache.jackrabbit.oak.spi.blob.BlobStore;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.DefaultNodeStateDiff;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentWriter {
    private static final Logger log = LoggerFactory.getLogger(SegmentWriter.class);
    static final int BLOCK_SIZE = 4096;
    private final SegmentTracker tracker;
    private final SegmentStore store;
    private final Map<Object, RecordId> records = new LinkedHashMap<Object, RecordId>(15000, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Object, RecordId> e) {
            return this.size() > 10000;
        }
    };
    private final Map<RecordId, RecordType> roots = Maps.newLinkedHashMap();
    private final List<RecordId> blobrefs = Lists.newArrayList();
    private byte[] buffer;
    private int length = 0;
    private int position;
    private Segment segment;
    private final SegmentVersion version;

    static byte[] createNewBuffer(SegmentVersion v) {
        byte[] buffer = new byte[262144];
        buffer[0] = 48;
        buffer[1] = 97;
        buffer[2] = 75;
        buffer[3] = SegmentVersion.asByte(v);
        buffer[4] = 0;
        buffer[5] = 0;
        return buffer;
    }

    private static int align(int value) {
        return SegmentWriter.align(value, 4);
    }

    private static int align(int value, int boundary) {
        return value + boundary - 1 & ~(boundary - 1);
    }

    public SegmentWriter(SegmentStore store, SegmentTracker tracker, SegmentVersion version) {
        this.store = store;
        this.tracker = tracker;
        this.version = version;
        this.buffer = SegmentWriter.createNewBuffer(version);
        this.segment = new Segment(tracker, this.buffer);
        this.segment.getSegmentId().setSegment(this.segment);
    }

    public synchronized Segment getCurrentSegment(SegmentId id) {
        if (id == this.segment.getSegmentId()) {
            return this.segment;
        }
        return null;
    }

    public synchronized void flush() {
        if (this.length > 0) {
            ByteBuffer data;
            int offset;
            int refcount = this.segment.getRefCount();
            int rootcount = this.roots.size();
            this.buffer[Segment.ROOT_COUNT_OFFSET] = (byte)(rootcount >> 8);
            this.buffer[Segment.ROOT_COUNT_OFFSET + 1] = (byte)rootcount;
            int blobrefcount = this.blobrefs.size();
            this.buffer[Segment.BLOBREF_COUNT_OFFSET] = (byte)(blobrefcount >> 8);
            this.buffer[Segment.BLOBREF_COUNT_OFFSET + 1] = (byte)blobrefcount;
            this.length = SegmentWriter.align(refcount * 16 + rootcount * 3 + blobrefcount * 2 + this.length, 16);
            Preconditions.checkState((this.length <= this.buffer.length ? 1 : 0) != 0);
            int pos = refcount * 16;
            if (pos + this.length <= this.buffer.length) {
                System.arraycopy(this.buffer, 0, this.buffer, this.buffer.length - this.length, pos);
                pos += this.buffer.length - this.length;
            } else {
                this.length = this.buffer.length;
            }
            for (Map.Entry<RecordId, RecordType> entry : this.roots.entrySet()) {
                offset = entry.getKey().getOffset();
                this.buffer[pos++] = (byte)entry.getValue().ordinal();
                this.buffer[pos++] = (byte)(offset >> 10);
                this.buffer[pos++] = (byte)(offset >> 2);
            }
            for (RecordId blobref : this.blobrefs) {
                offset = blobref.getOffset();
                this.buffer[pos++] = (byte)(offset >> 10);
                this.buffer[pos++] = (byte)(offset >> 2);
            }
            SegmentId id = this.segment.getSegmentId();
            log.debug("Writing data segment {} ({} bytes)", (Object)id, (Object)this.length);
            this.store.writeSegment(id, this.buffer, this.buffer.length - this.length, this.length);
            if (this.buffer.length - this.length > 4096) {
                data = ByteBuffer.allocate(this.length);
                data.put(this.buffer, this.buffer.length - this.length, this.length);
                data.rewind();
            } else {
                data = ByteBuffer.wrap(this.buffer, this.buffer.length - this.length, this.length);
            }
            this.tracker.setSegment(id, new Segment(this.tracker, id, data));
            this.buffer = SegmentWriter.createNewBuffer(this.version);
            this.roots.clear();
            this.blobrefs.clear();
            this.length = 0;
            this.position = this.buffer.length;
            this.segment = new Segment(this.tracker, this.buffer);
            this.segment.getSegmentId().setSegment(this.segment);
        }
    }

    private RecordId prepare(RecordType type, int size) {
        return this.prepare(type, size, Collections.<RecordId>emptyList());
    }

    private RecordId prepare(RecordType type, int size, Collection<RecordId> ids) {
        int recordSize;
        int headerSize;
        int segmentSize;
        Preconditions.checkArgument((size >= 0 ? 1 : 0) != 0);
        Preconditions.checkNotNull(ids);
        int blobrefcount = this.blobrefs.size() + 1;
        int rootcount = this.roots.size() + 1;
        int refcount = this.segment.getRefCount();
        Set segmentIds = Sets.newIdentityHashSet();
        HashSet<RecordId> notRoots = new HashSet<RecordId>();
        for (RecordId recordId : ids) {
            SegmentId segmentId = recordId.getSegmentId();
            if (segmentId != this.segment.getSegmentId()) {
                segmentIds.add(segmentId);
                continue;
            }
            if (!this.roots.containsKey(recordId)) continue;
            notRoots.add(recordId);
        }
        rootcount -= notRoots.size();
        if (!segmentIds.isEmpty()) {
            for (int refid = 1; refid < refcount; ++refid) {
                segmentIds.remove(this.segment.getRefId(refid));
            }
            refcount += segmentIds.size();
        }
        if ((segmentSize = SegmentWriter.align((headerSize = refcount * 16 + rootcount * 3 + blobrefcount * 2) + (recordSize = SegmentWriter.align(size + ids.size() * 3)) + this.length, 16)) > this.buffer.length - 1 || blobrefcount > 65535 || rootcount > 65535 || refcount > 255) {
            this.flush();
        }
        this.length += recordSize;
        this.position = this.buffer.length - this.length;
        Preconditions.checkState((this.position >= 0 ? 1 : 0) != 0);
        RecordId id = new RecordId(this.segment.getSegmentId(), this.position);
        this.roots.put(id, type);
        return id;
    }

    private synchronized int getSegmentRef(SegmentId segmentId) {
        int refcount = this.segment.getRefCount();
        if (refcount > 255) {
            throw new SegmentOverflowException("Segment cannot have more than 255 references " + this.segment.getSegmentId());
        }
        for (int index = 0; index < refcount; ++index) {
            if (segmentId != this.segment.getRefId(index)) continue;
            return index;
        }
        ByteBuffer.wrap(this.buffer, refcount * 16, 16).putLong(segmentId.getMostSignificantBits()).putLong(segmentId.getLeastSignificantBits());
        this.buffer[Segment.REF_COUNT_OFFSET] = (byte)refcount;
        return refcount;
    }

    private synchronized void writeRecordId(RecordId recordId) {
        Preconditions.checkNotNull((Object)recordId);
        this.roots.remove(recordId);
        int offset = recordId.getOffset();
        Preconditions.checkState((0 <= offset && offset < 262144 ? 1 : 0) != 0);
        Preconditions.checkState((offset == SegmentWriter.align(offset) ? 1 : 0) != 0);
        this.buffer[this.position++] = (byte)this.getSegmentRef(recordId.getSegmentId());
        this.buffer[this.position++] = (byte)(offset >> 10);
        this.buffer[this.position++] = (byte)(offset >> 2);
    }

    private void writeInt(int value) {
        this.buffer[this.position++] = (byte)(value >> 24);
        this.buffer[this.position++] = (byte)(value >> 16);
        this.buffer[this.position++] = (byte)(value >> 8);
        this.buffer[this.position++] = (byte)value;
    }

    private void writeLong(long value) {
        this.writeInt((int)(value >> 32));
        this.writeInt((int)value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MapRecord writeMapLeaf(int level, Collection<MapEntry> entries) {
        Preconditions.checkNotNull(entries);
        int size = entries.size();
        Preconditions.checkElementIndex((int)size, (int)MapRecord.MAX_SIZE);
        Preconditions.checkPositionIndex((int)level, (int)7);
        Preconditions.checkArgument((size != 0 || level == 7 ? 1 : 0) != 0);
        ArrayList ids = Lists.newArrayListWithCapacity((int)(2 * size));
        for (MapEntry entry : entries) {
            ids.add(entry.getKey());
            ids.add(entry.getValue());
        }
        Object[] array = entries.toArray(new MapEntry[entries.size()]);
        Arrays.sort(array);
        SegmentWriter segmentWriter = this;
        synchronized (segmentWriter) {
            RecordId id = this.prepare(RecordType.LEAF, 4 + size * 4, ids);
            this.writeInt(level << MapRecord.SIZE_BITS | size);
            for (Object entry : array) {
                this.writeInt(((MapEntry)entry).getHash());
            }
            for (Object entry : array) {
                this.writeRecordId(((MapEntry)entry).getKey());
                this.writeRecordId(((MapEntry)entry).getValue());
            }
            return new MapRecord(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MapRecord writeMapBranch(int level, int size, MapRecord[] buckets) {
        int bitmap = 0;
        ArrayList ids = Lists.newArrayListWithCapacity((int)buckets.length);
        for (int i = 0; i < buckets.length; ++i) {
            if (buckets[i] == null) continue;
            bitmap = (int)((long)bitmap | 1L << i);
            ids.add(buckets[i].getRecordId());
        }
        SegmentWriter segmentWriter = this;
        synchronized (segmentWriter) {
            RecordId mapId = this.prepare(RecordType.BRANCH, 8, ids);
            this.writeInt(level << MapRecord.SIZE_BITS | size);
            this.writeInt(bitmap);
            for (RecordId id : ids) {
                this.writeRecordId(id);
            }
            return new MapRecord(mapId);
        }
    }

    private synchronized RecordId writeListBucket(List<RecordId> bucket) {
        Preconditions.checkArgument((bucket.size() > 1 ? 1 : 0) != 0);
        RecordId bucketId = this.prepare(RecordType.BUCKET, 0, bucket);
        for (RecordId id : bucket) {
            this.writeRecordId(id);
        }
        return bucketId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized MapRecord writeMapBucket(MapRecord base, Collection<MapEntry> entries, int level) {
        int i;
        if (entries == null || entries.isEmpty()) {
            if (base != null) {
                return base;
            }
            if (level == 0) {
                SegmentWriter segmentWriter = this;
                synchronized (segmentWriter) {
                    RecordId id = this.prepare(RecordType.LEAF, 4);
                    this.writeInt(0);
                    return new MapRecord(id);
                }
            }
            return null;
        }
        if (base == null) {
            if (entries.size() <= 32 || level == 7) {
                return this.writeMapLeaf(level, entries);
            }
            MapRecord[] buckets = new MapRecord[32];
            List<List<MapEntry>> changes = SegmentWriter.splitToBuckets(entries, level);
            for (int i2 = 0; i2 < 32; ++i2) {
                buckets[i2] = this.writeMapBucket(null, (Collection<MapEntry>)changes.get(i2), level + 1);
            }
            return this.writeMapBranch(level, entries.size(), buckets);
        }
        if (base.isLeaf()) {
            HashMap map = Maps.newHashMap();
            for (MapEntry entry : base.getEntries()) {
                map.put(entry.getName(), entry);
            }
            for (MapEntry entry : entries) {
                if (entry.getValue() != null) {
                    map.put(entry.getName(), entry);
                    continue;
                }
                map.remove(entry.getName());
            }
            return this.writeMapBucket(null, map.values(), level);
        }
        int newSize = 0;
        int newCount = 0;
        MapRecord[] buckets = base.getBuckets();
        List<List<MapEntry>> changes = SegmentWriter.splitToBuckets(entries, level);
        for (i = 0; i < 32; ++i) {
            buckets[i] = this.writeMapBucket(buckets[i], (Collection<MapEntry>)changes.get(i), level + 1);
            if (buckets[i] == null) continue;
            newSize += buckets[i].size();
            ++newCount;
        }
        if (newSize > 32) {
            return this.writeMapBranch(level, newSize, buckets);
        }
        if (newCount <= 1) {
            for (i = 0; i < buckets.length; ++i) {
                if (buckets[i] == null) continue;
                return buckets[i];
            }
            return this.writeMapBucket(null, null, level);
        }
        ArrayList list = Lists.newArrayList();
        for (int i3 = 0; i3 < buckets.length; ++i3) {
            if (buckets[i3] == null) continue;
            Iterables.addAll((Collection)list, buckets[i3].getEntries());
        }
        return this.writeMapLeaf(level, list);
    }

    private static List<List<MapEntry>> splitToBuckets(Collection<MapEntry> entries, int level) {
        Object empty = null;
        int mask = 31;
        int shift = 32 - (level + 1) * 5;
        ArrayList buckets = Lists.newArrayList(Collections.nCopies(32, empty));
        for (MapEntry entry : entries) {
            int index = entry.getHash() >> shift & mask;
            List bucket = (List)buckets.get(index);
            if (bucket == null) {
                bucket = Lists.newArrayList();
                buckets.set(index, bucket);
            }
            bucket.add(entry);
        }
        return buckets;
    }

    private synchronized RecordId writeValueRecord(long length, RecordId blocks) {
        RecordId valueId = this.prepare(RecordType.VALUE, 8, Collections.singleton(blocks));
        this.writeLong(length - 16512L | 0xC000000000000000L);
        this.writeRecordId(blocks);
        return valueId;
    }

    private synchronized RecordId writeValueRecord(int length, byte[] data) {
        RecordId id;
        Preconditions.checkArgument((length < 16512 ? 1 : 0) != 0);
        if (length < 128) {
            id = this.prepare(RecordType.VALUE, 1 + length);
            this.buffer[this.position++] = (byte)length;
        } else {
            id = this.prepare(RecordType.VALUE, 2 + length);
            int len = length - 128 | 0x8000;
            this.buffer[this.position++] = (byte)(len >> 8);
            this.buffer[this.position++] = (byte)len;
        }
        System.arraycopy(data, 0, this.buffer, this.position, length);
        this.position += length;
        return id;
    }

    private synchronized RecordId writeValueRecord(String reference) {
        byte[] data = reference.getBytes(Charsets.UTF_8);
        int length = data.length;
        Preconditions.checkArgument((length < 8192 ? 1 : 0) != 0);
        RecordId id = this.prepare(RecordType.VALUE, 2 + length);
        int len = length | 0xE000;
        this.buffer[this.position++] = (byte)(len >> 8);
        this.buffer[this.position++] = (byte)len;
        System.arraycopy(data, 0, this.buffer, this.position, length);
        this.position += length;
        this.blobrefs.add(id);
        return id;
    }

    public synchronized RecordId writeBlock(byte[] bytes, int offset, int length) {
        Preconditions.checkNotNull((Object)bytes);
        Preconditions.checkPositionIndexes((int)offset, (int)(offset + length), (int)bytes.length);
        RecordId blockId = this.prepare(RecordType.BLOCK, length);
        System.arraycopy(bytes, offset, this.buffer, this.position, length);
        this.position += length;
        return blockId;
    }

    public RecordId writeList(List<RecordId> list) {
        Preconditions.checkNotNull(list);
        Preconditions.checkArgument((list.size() > 0 ? 1 : 0) != 0);
        ArrayList thisLevel = list;
        while (thisLevel.size() > 1) {
            ArrayList nextLevel = Lists.newArrayList();
            for (List bucket : Lists.partition(thisLevel, (int)255)) {
                if (bucket.size() > 1) {
                    nextLevel.add(this.writeListBucket(bucket));
                    continue;
                }
                nextLevel.add(bucket.get(0));
            }
            thisLevel = nextLevel;
        }
        return thisLevel.iterator().next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapRecord writeMap(MapRecord base, Map<String, RecordId> changes) {
        MapEntry mapEntry;
        Map.Entry<String, RecordId> change;
        RecordId value;
        if (base != null && base.isDiff()) {
            RecordId key;
            Segment segment = base.getSegment();
            String string = segment.readString(key = segment.readRecordId(base.getOffset(8)));
            if (!changes.containsKey(string)) {
                changes.put(string, segment.readRecordId(base.getOffset(8, 1)));
            }
            base = new MapRecord(segment.readRecordId(base.getOffset(8, 2)));
        }
        if (base != null && changes.size() == 1 && (value = (change = changes.entrySet().iterator().next()).getValue()) != null && (mapEntry = base.getEntry(change.getKey())) != null) {
            if (value.equals(mapEntry.getValue())) {
                return base;
            }
            SegmentWriter segmentWriter = this;
            synchronized (segmentWriter) {
                RecordId id = this.prepare(RecordType.BRANCH, 8, Arrays.asList(mapEntry.getKey(), value, base.getRecordId()));
                this.writeInt(-1);
                this.writeInt(mapEntry.getHash());
                this.writeRecordId(mapEntry.getKey());
                this.writeRecordId(value);
                this.writeRecordId(base.getRecordId());
                return new MapRecord(id);
            }
        }
        ArrayList entries = Lists.newArrayList();
        for (Map.Entry<String, RecordId> entry : changes.entrySet()) {
            MapEntry e;
            String key = entry.getKey();
            RecordId keyId = null;
            if (base != null && (e = base.getEntry(key)) != null) {
                keyId = e.getKey();
            }
            if (keyId == null) {
                keyId = this.writeString(key);
            }
            entries.add(new MapEntry(key, keyId, entry.getValue()));
        }
        return this.writeMapBucket(base, entries, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordId writeString(String string) {
        Object id;
        SegmentWriter segmentWriter = this;
        synchronized (segmentWriter) {
            id = this.records.get(string);
            if (id != null) {
                return id;
            }
        }
        byte[] data = string.getBytes(Charsets.UTF_8);
        if (data.length < 16512) {
            id = this;
            synchronized (id) {
                RecordId id2 = this.records.get(string);
                if (id2 == null) {
                    id2 = this.writeValueRecord(data.length, data);
                    this.records.put(string, id2);
                }
                return id2;
            }
        }
        int pos = 0;
        ArrayList blockIds = Lists.newArrayListWithExpectedSize((int)(data.length / 4096 + 1));
        while (pos + 262144 <= data.length) {
            SegmentId bulkId = this.store.getTracker().newBulkSegmentId();
            this.store.writeSegment(bulkId, data, pos, 262144);
            for (int i = 0; i < 262144; i += 4096) {
                blockIds.add(new RecordId(bulkId, i));
            }
            pos += 262144;
        }
        while (pos < data.length) {
            int len = Math.min(4096, data.length - pos);
            blockIds.add(this.writeBlock(data, pos, len));
            pos += len;
        }
        return this.writeValueRecord((long)data.length, this.writeList(blockIds));
    }

    public SegmentBlob writeBlob(Blob blob) throws IOException {
        if (blob instanceof SegmentBlob && this.store.containsSegment(((SegmentBlob)blob).getRecordId().getSegmentId())) {
            return (SegmentBlob)blob;
        }
        String reference = blob.getReference();
        if (reference != null && this.store.getBlobStore() != null) {
            String blobId = this.store.getBlobStore().getBlobId(reference);
            if (blobId != null) {
                RecordId id = this.writeValueRecord(blobId);
                return new SegmentBlob(id);
            }
            log.debug("No blob found for reference {}, inlining...", (Object)reference);
        }
        return this.writeStream(blob.getNewStream());
    }

    SegmentBlob writeExternalBlob(String blobId) throws IOException {
        RecordId id = this.writeValueRecord(blobId);
        return new SegmentBlob(id);
    }

    SegmentBlob writeLargeBlob(long length, List<RecordId> list) {
        RecordId id = this.writeValueRecord(length, this.writeList(list));
        return new SegmentBlob(id);
    }

    public synchronized void dropCache() {
        this.records.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SegmentBlob writeStream(InputStream stream) throws IOException {
        boolean threw = true;
        try {
            RecordId id = SegmentStream.getRecordIdIfAvailable(stream, this.store);
            if (id == null) {
                id = this.internalWriteStream(stream);
            }
            threw = false;
            SegmentBlob segmentBlob = new SegmentBlob(id);
            return segmentBlob;
        }
        finally {
            Closeables.close((Closeable)stream, (boolean)threw);
        }
    }

    private RecordId internalWriteStream(InputStream stream) throws IOException {
        BlobStore blobStore = this.store.getBlobStore();
        byte[] data = new byte[262144];
        int n = ByteStreams.read((InputStream)stream, (byte[])data, (int)0, (int)data.length);
        if (n < 16512) {
            return this.writeValueRecord(n, data);
        }
        if (blobStore != null) {
            String blobId = blobStore.writeBlob(new SequenceInputStream(new ByteArrayInputStream(data, 0, n), stream));
            return this.writeValueRecord(blobId);
        }
        long length = n;
        ArrayList blockIds = Lists.newArrayListWithExpectedSize((int)(2 * n / 4096));
        while (n != 0) {
            SegmentId bulkId = this.store.getTracker().newBulkSegmentId();
            int len = SegmentWriter.align(n);
            log.debug("Writing bulk segment {} ({} bytes)", (Object)bulkId, (Object)n);
            this.store.writeSegment(bulkId, data, 0, len);
            for (int i = 0; i < n; i += 4096) {
                blockIds.add(new RecordId(bulkId, data.length - len + i));
            }
            n = ByteStreams.read((InputStream)stream, (byte[])data, (int)0, (int)data.length);
            length += (long)n;
        }
        return this.writeValueRecord(length, this.writeList(blockIds));
    }

    private RecordId writeProperty(PropertyState state) {
        Map<String, RecordId> previousValues = Collections.emptyMap();
        return this.writeProperty(state, previousValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RecordId writeProperty(PropertyState state, Map<String, RecordId> previousValues) {
        Type<?> type = state.getType();
        int count = state.count();
        ArrayList valueIds = Lists.newArrayList();
        for (int i = 0; i < count; ++i) {
            if (type.tag() == 2) {
                try {
                    SegmentBlob blob = this.writeBlob(state.getValue(Type.BINARY, i));
                    valueIds.add(blob.getRecordId());
                    continue;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unexpected IOException", e);
                }
            }
            String value = state.getValue(Type.STRING, i);
            RecordId valueId = previousValues.get(value);
            if (valueId == null) {
                valueId = this.writeString(value);
            }
            valueIds.add(valueId);
        }
        if (!type.isArray()) {
            return (RecordId)valueIds.iterator().next();
        }
        if (count == 0) {
            SegmentWriter i = this;
            synchronized (i) {
                RecordId propertyId = this.prepare(RecordType.LIST, 4);
                this.writeInt(0);
                return propertyId;
            }
        }
        RecordId listId = this.writeList(valueIds);
        SegmentWriter segmentWriter = this;
        synchronized (segmentWriter) {
            RecordId propertyId = this.prepare(RecordType.LIST, 4, Collections.singleton(listId));
            this.writeInt(count);
            this.writeRecordId(listId);
            return propertyId;
        }
    }

    public synchronized RecordId writeTemplate(Template template) {
        Preconditions.checkNotNull((Object)template);
        RecordId id = this.records.get(template);
        if (id != null) {
            return id;
        }
        ArrayList ids = Lists.newArrayList();
        int head = 0;
        RecordId primaryId = null;
        PropertyState primaryType = template.getPrimaryType();
        if (primaryType != null) {
            head |= Integer.MIN_VALUE;
            primaryId = this.writeString(primaryType.getValue(Type.NAME));
            ids.add(primaryId);
        }
        ArrayList mixinIds = null;
        PropertyState mixinTypes = template.getMixinTypes();
        if (mixinTypes != null) {
            head |= 0x40000000;
            mixinIds = Lists.newArrayList();
            for (String mixin : mixinTypes.getValue(Type.NAMES)) {
                mixinIds.add(this.writeString(mixin));
            }
            ids.addAll(mixinIds);
            Preconditions.checkState((mixinIds.size() < 1024 ? 1 : 0) != 0);
            head |= mixinIds.size() << 18;
        }
        RecordId childNameId = null;
        String childName = template.getChildName();
        if (childName == Template.ZERO_CHILD_NODES) {
            head |= 0x20000000;
        } else if (childName == "") {
            head |= 0x10000000;
        } else {
            childNameId = this.writeString(childName);
            ids.add(childNameId);
        }
        PropertyTemplate[] properties = template.getPropertyTemplates();
        RecordId[] propertyNames = new RecordId[properties.length];
        byte[] propertyTypes = new byte[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            propertyNames[i] = this.writeString(properties[i].getName());
            Type<?> type = properties[i].getType();
            propertyTypes[i] = type.isArray() ? (byte)(-type.tag()) : (byte)type.tag();
        }
        RecordId propNamesId = null;
        if (this.segment.getSegmentVersion().onOrAfter(SegmentVersion.V_11)) {
            if (propertyNames.length > 0) {
                propNamesId = this.writeList(Arrays.asList(propertyNames));
                ids.add(propNamesId);
            }
        } else {
            ids.addAll(Arrays.asList(propertyNames));
        }
        Preconditions.checkState((propertyNames.length < 262144 ? 1 : 0) != 0);
        id = this.prepare(RecordType.TEMPLATE, 4 + propertyTypes.length, ids);
        this.writeInt(head |= propertyNames.length);
        if (primaryId != null) {
            this.writeRecordId(primaryId);
        }
        if (mixinIds != null) {
            for (RecordId mixinId : mixinIds) {
                this.writeRecordId(mixinId);
            }
        }
        if (childNameId != null) {
            this.writeRecordId(childNameId);
        }
        if (this.segment.getSegmentVersion().onOrAfter(SegmentVersion.V_11) && propNamesId != null) {
            this.writeRecordId(propNamesId);
        }
        for (int i = 0; i < propertyNames.length; ++i) {
            if (!this.segment.getSegmentVersion().onOrAfter(SegmentVersion.V_11)) {
                this.writeRecordId(propertyNames[i]);
            }
            this.buffer[this.position++] = propertyTypes[i];
        }
        this.records.put(template, id);
        return id;
    }

    private SegmentNodeState uncompact(SegmentNodeState state) {
        RecordId id = this.tracker.getCompactionMap().get(state.getRecordId());
        if (id != null) {
            return new SegmentNodeState(id);
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public SegmentNodeState writeNode(NodeState state) {
        void var12_18;
        SegmentNodeState sns;
        NodeState base;
        SegmentNodeState sns2;
        if (state instanceof SegmentNodeState && ((sns2 = this.uncompact((SegmentNodeState)state)) != state || this.store.containsSegment(sns2.getRecordId().getSegmentId()))) {
            return sns2;
        }
        SegmentNodeState before = null;
        Template beforeTemplate = null;
        ModifiedNodeState after = null;
        if (state instanceof ModifiedNodeState && (base = (after = (ModifiedNodeState)state).getBaseState()) instanceof SegmentNodeState && ((sns = this.uncompact((SegmentNodeState)base)) != base || this.store.containsSegment(sns.getRecordId().getSegmentId()))) {
            before = sns;
            beforeTemplate = before.getTemplate();
        }
        Template template = new Template(state);
        RecordId templateId = before != null && template.equals(beforeTemplate) ? before.getTemplateId() : this.writeTemplate(template);
        ArrayList ids = Lists.newArrayList();
        ids.add(templateId);
        String childName = template.getChildName();
        if (childName == "") {
            MapRecord base2;
            final HashMap object = Maps.newHashMap();
            if (before != null && before.getChildNodeCount(2L) > 1L && after.getChildNodeCount(2L) > 1L) {
                MapRecord base3 = before.getChildNodeMap();
                after.compareAgainstBaseState(before, new DefaultNodeStateDiff(){

                    @Override
                    public boolean childNodeAdded(String name, NodeState after) {
                        object.put(name, SegmentWriter.this.writeNode(after).getRecordId());
                        return true;
                    }

                    @Override
                    public boolean childNodeChanged(String name, NodeState before, NodeState after) {
                        object.put(name, SegmentWriter.this.writeNode(after).getRecordId());
                        return true;
                    }

                    @Override
                    public boolean childNodeDeleted(String name, NodeState before) {
                        object.put(name, null);
                        return true;
                    }
                });
            } else {
                base2 = null;
                for (ChildNodeEntry childNodeEntry : state.getChildNodeEntries()) {
                    object.put(childNodeEntry.getName(), this.writeNode(childNodeEntry.getNodeState()).getRecordId());
                }
            }
            ids.add(this.writeMap(base2, object).getRecordId());
        } else if (childName != Template.ZERO_CHILD_NODES) {
            ids.add(this.writeNode(state.getChildNode(template.getChildName())).getRecordId());
        }
        ArrayList pIds = Lists.newArrayList();
        PropertyTemplate[] propertyTemplateArray = template.getPropertyTemplates();
        int n = propertyTemplateArray.length;
        boolean bl = false;
        while (var12_18 < n) {
            PropertyTemplate pt = propertyTemplateArray[var12_18];
            String name = pt.getName();
            PropertyState property = state.getProperty(name);
            if (property instanceof SegmentPropertyState && this.store.containsSegment(((SegmentPropertyState)property).getRecordId().getSegmentId())) {
                pIds.add(((SegmentPropertyState)property).getRecordId());
            } else if (before == null || !this.store.containsSegment(before.getRecordId().getSegmentId())) {
                pIds.add(this.writeProperty(property));
            } else {
                PropertyTemplate bt = beforeTemplate.getPropertyTemplate(name);
                if (bt == null) {
                    pIds.add(this.writeProperty(property));
                } else {
                    SegmentPropertyState bp = beforeTemplate.getProperty(before.getRecordId(), bt.getIndex());
                    if (property.equals(bp)) {
                        pIds.add(bp.getRecordId());
                    } else if (bp.isArray() && bp.getType() != Type.BINARIES) {
                        pIds.add(this.writeProperty(property, bp.getValueRecords()));
                    } else {
                        pIds.add(this.writeProperty(property));
                    }
                }
            }
            ++var12_18;
        }
        if (!pIds.isEmpty()) {
            if (this.segment.getSegmentVersion().onOrAfter(SegmentVersion.V_11)) {
                ids.add(this.writeList(pIds));
            } else {
                ids.addAll(pIds);
            }
        }
        SegmentWriter segmentWriter = this;
        synchronized (segmentWriter) {
            RecordId recordId = this.prepare(RecordType.NODE, 0, ids);
            for (RecordId id : ids) {
                this.writeRecordId(id);
            }
            return new SegmentNodeState(recordId);
        }
    }

    public SegmentTracker getTracker() {
        return this.tracker;
    }
}

