/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment.file;

import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BackgroundThread
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(BackgroundThread.class);
    private final String name;
    private final long interval;
    private boolean alive = true;
    private long iterations = 0L;
    private long sumDuration = 0L;
    private long maxDuration = 0L;

    BackgroundThread(String name, long interval, Runnable target) {
        super(target, name);
        this.name = name;
        this.interval = interval;
        this.setDaemon(true);
        this.setPriority(1);
        this.start();
    }

    @Override
    public void run() {
        try {
            while (this.waitUntilNextIteration()) {
                this.setName(this.name + ", active since " + new Date() + ", previous max duration " + this.maxDuration + "ms");
                long start = System.currentTimeMillis();
                super.run();
                long duration = System.currentTimeMillis() - start;
                ++this.iterations;
                this.sumDuration += duration;
                this.maxDuration = Math.max(this.maxDuration, duration);
                this.setName(this.name + ", avg " + this.sumDuration / this.iterations + "ms" + ", max " + this.maxDuration + "ms");
            }
        }
        catch (InterruptedException e) {
            log.error(this.name + " interrupted", (Throwable)e);
        }
    }

    void trigger() {
        this.trigger(false);
    }

    void close() {
        try {
            this.trigger(true);
            this.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error(this.name + " join interrupted", (Throwable)e);
        }
    }

    private synchronized void trigger(boolean close) {
        if (close) {
            this.alive = false;
        }
        this.notify();
    }

    private synchronized boolean waitUntilNextIteration() throws InterruptedException {
        if (this.alive) {
            if (this.interval < 0L) {
                this.wait();
            } else {
                this.wait(this.interval);
            }
        }
        return this.alive;
    }
}

