/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment.file;

import com.google.common.base.Preconditions;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.management.openmbean.CompositeData;
import org.apache.jackrabbit.oak.plugins.segment.file.GCMonitorMBean;
import org.apache.jackrabbit.oak.spi.gc.GCMonitor;
import org.apache.jackrabbit.oak.stats.Clock;
import org.apache.jackrabbit.oak.stats.TimeSeriesStatsUtil;
import org.apache.jackrabbit.stats.TimeSeriesRecorder;
import org.slf4j.helpers.MessageFormatter;

public class FileStoreGCMonitor
implements GCMonitor,
GCMonitorMBean,
Runnable {
    private final TimeSeriesRecorder gcCount = new TimeSeriesRecorder(true);
    private final TimeSeriesRecorder repositorySize = new TimeSeriesRecorder(false);
    private final TimeSeriesRecorder reclaimedSize = new TimeSeriesRecorder(true);
    private final Clock clock;
    private long lastCompaction;
    private long lastCleanup;
    private String lastError;
    private String status = "NA";

    public FileStoreGCMonitor(@Nonnull Clock clock) {
        this.clock = (Clock)Preconditions.checkNotNull((Object)clock);
    }

    @Override
    public void run() {
        this.gcCount.recordOneSecond();
        this.repositorySize.recordOneSecond();
        this.reclaimedSize.recordOneSecond();
    }

    @Override
    public void info(String message, Object ... arguments) {
        this.status = MessageFormatter.arrayFormat((String)message, (Object[])arguments).getMessage();
    }

    @Override
    public void warn(String message, Object ... arguments) {
        this.status = MessageFormatter.arrayFormat((String)message, (Object[])arguments).getMessage();
    }

    @Override
    public void error(String message, Exception exception) {
        StringWriter sw = new StringWriter();
        sw.write(message + ": ");
        exception.printStackTrace(new PrintWriter(sw));
        this.lastError = sw.toString();
    }

    @Override
    public void skipped(String reason, Object ... arguments) {
        this.status = MessageFormatter.arrayFormat((String)reason, (Object[])arguments).getMessage();
    }

    @Override
    public void compacted() {
        this.lastCompaction = this.clock.getTime();
    }

    @Override
    public void cleaned(long reclaimed, long current) {
        this.lastCleanup = this.clock.getTime();
        this.gcCount.getCounter().addAndGet(1L);
        this.repositorySize.getCounter().set(current);
        this.reclaimedSize.getCounter().addAndGet(reclaimed);
    }

    @Override
    public String getLastCompaction() {
        return FileStoreGCMonitor.toString(this.lastCompaction);
    }

    @Override
    public String getLastCleanup() {
        return FileStoreGCMonitor.toString(this.lastCleanup);
    }

    private static String toString(long timestamp) {
        if (timestamp != 0L) {
            return DateFormat.getDateTimeInstance().format(new Date(timestamp));
        }
        return null;
    }

    @Override
    public String getLastError() {
        return this.lastError;
    }

    @Override
    @Nonnull
    public String getStatus() {
        return this.status;
    }

    @Override
    @Nonnull
    public CompositeData getRepositorySize() {
        return TimeSeriesStatsUtil.asCompositeData(this.repositorySize, "RepositorySize");
    }

    @Override
    @Nonnull
    public CompositeData getReclaimedSize() {
        return TimeSeriesStatsUtil.asCompositeData(this.reclaimedSize, "ReclaimedSize");
    }
}

