/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.jackrabbit.oak.api.PropertyValue;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.namepath.JcrPathParser;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.query.ExecutionContext;
import org.apache.jackrabbit.oak.query.FilterIterators;
import org.apache.jackrabbit.oak.query.Query;
import org.apache.jackrabbit.oak.query.QueryEngineSettings;
import org.apache.jackrabbit.oak.query.ResultImpl;
import org.apache.jackrabbit.oak.query.ResultRowImpl;
import org.apache.jackrabbit.oak.query.ast.AndImpl;
import org.apache.jackrabbit.oak.query.ast.AstVisitorBase;
import org.apache.jackrabbit.oak.query.ast.BindVariableValueImpl;
import org.apache.jackrabbit.oak.query.ast.ChildNodeImpl;
import org.apache.jackrabbit.oak.query.ast.ChildNodeJoinConditionImpl;
import org.apache.jackrabbit.oak.query.ast.ColumnImpl;
import org.apache.jackrabbit.oak.query.ast.ComparisonImpl;
import org.apache.jackrabbit.oak.query.ast.ConstraintImpl;
import org.apache.jackrabbit.oak.query.ast.DescendantNodeImpl;
import org.apache.jackrabbit.oak.query.ast.DescendantNodeJoinConditionImpl;
import org.apache.jackrabbit.oak.query.ast.DynamicOperandImpl;
import org.apache.jackrabbit.oak.query.ast.EquiJoinConditionImpl;
import org.apache.jackrabbit.oak.query.ast.FullTextSearchImpl;
import org.apache.jackrabbit.oak.query.ast.FullTextSearchScoreImpl;
import org.apache.jackrabbit.oak.query.ast.InImpl;
import org.apache.jackrabbit.oak.query.ast.JoinConditionImpl;
import org.apache.jackrabbit.oak.query.ast.JoinImpl;
import org.apache.jackrabbit.oak.query.ast.JoinType;
import org.apache.jackrabbit.oak.query.ast.LengthImpl;
import org.apache.jackrabbit.oak.query.ast.LiteralImpl;
import org.apache.jackrabbit.oak.query.ast.LowerCaseImpl;
import org.apache.jackrabbit.oak.query.ast.NativeFunctionImpl;
import org.apache.jackrabbit.oak.query.ast.NodeLocalNameImpl;
import org.apache.jackrabbit.oak.query.ast.NodeNameImpl;
import org.apache.jackrabbit.oak.query.ast.NotImpl;
import org.apache.jackrabbit.oak.query.ast.OrImpl;
import org.apache.jackrabbit.oak.query.ast.OrderingImpl;
import org.apache.jackrabbit.oak.query.ast.PropertyExistenceImpl;
import org.apache.jackrabbit.oak.query.ast.PropertyInexistenceImpl;
import org.apache.jackrabbit.oak.query.ast.PropertyValueImpl;
import org.apache.jackrabbit.oak.query.ast.SameNodeImpl;
import org.apache.jackrabbit.oak.query.ast.SameNodeJoinConditionImpl;
import org.apache.jackrabbit.oak.query.ast.SelectorImpl;
import org.apache.jackrabbit.oak.query.ast.SimilarImpl;
import org.apache.jackrabbit.oak.query.ast.SourceImpl;
import org.apache.jackrabbit.oak.query.ast.SpellcheckImpl;
import org.apache.jackrabbit.oak.query.ast.UpperCaseImpl;
import org.apache.jackrabbit.oak.query.index.FilterImpl;
import org.apache.jackrabbit.oak.query.index.TraversingIndex;
import org.apache.jackrabbit.oak.query.plan.ExecutionPlan;
import org.apache.jackrabbit.oak.query.plan.SelectorExecutionPlan;
import org.apache.jackrabbit.oak.spi.query.Filter;
import org.apache.jackrabbit.oak.spi.query.PropertyValues;
import org.apache.jackrabbit.oak.spi.query.QueryIndex;
import org.apache.jackrabbit.oak.spi.query.QueryIndexProvider;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryImpl
implements Query {
    public static final String JCR_PATH = "jcr:path";
    public static final String JCR_SCORE = "jcr:score";
    public static final String REP_EXCERPT = "rep:excerpt";
    public static final String REP_SPELLCHECK = "rep:spellcheck()";
    private static final Logger LOG = LoggerFactory.getLogger(QueryImpl.class);
    SourceImpl source;
    final String statement;
    final HashMap<String, PropertyValue> bindVariableMap = new HashMap();
    final HashMap<String, Integer> selectorIndexes = new HashMap();
    final ArrayList<SelectorImpl> selectors = new ArrayList();
    ConstraintImpl constraint;
    private boolean traversalEnabled = true;
    private OrderingImpl[] orderings;
    private ColumnImpl[] columns;
    private boolean[] distinctColumns;
    private boolean explain;
    private boolean measure;
    private boolean distinct;
    private long limit = Long.MAX_VALUE;
    private long offset;
    private long size = -1L;
    private boolean prepared;
    private ExecutionContext context;
    private final NamePathMapper namePathMapper;
    private double estimatedCost;
    private final QueryEngineSettings settings;
    private boolean warnedHidden;

    QueryImpl(String statement, SourceImpl source, ConstraintImpl constraint, ColumnImpl[] columns, NamePathMapper mapper, QueryEngineSettings settings) {
        this.statement = statement;
        this.source = source;
        this.constraint = constraint;
        this.columns = columns;
        this.namePathMapper = mapper;
        this.settings = settings;
    }

    @Override
    public void init() {
        final QueryImpl query = this;
        new AstVisitorBase(){

            public boolean visit(BindVariableValueImpl node) {
                node.setQuery(query);
                QueryImpl.this.bindVariableMap.put(node.getBindVariableName(), null);
                return true;
            }

            public boolean visit(ChildNodeImpl node) {
                node.setQuery(query);
                node.bindSelector(QueryImpl.this.source);
                return true;
            }

            public boolean visit(ChildNodeJoinConditionImpl node) {
                node.setQuery(query);
                node.bindSelector(QueryImpl.this.source);
                return true;
            }

            public boolean visit(ColumnImpl node) {
                node.setQuery(query);
                return true;
            }

            public boolean visit(DescendantNodeImpl node) {
                node.setQuery(query);
                node.bindSelector(QueryImpl.this.source);
                return true;
            }

            public boolean visit(DescendantNodeJoinConditionImpl node) {
                node.setQuery(query);
                node.bindSelector(QueryImpl.this.source);
                return true;
            }

            public boolean visit(EquiJoinConditionImpl node) {
                node.setQuery(query);
                node.bindSelector(QueryImpl.this.source);
                return true;
            }

            public boolean visit(FullTextSearchImpl node) {
                node.setQuery(query);
                node.bindSelector(QueryImpl.this.source);
                return super.visit(node);
            }

            public boolean visit(NativeFunctionImpl node) {
                node.setQuery(query);
                node.bindSelector(QueryImpl.this.source);
                return super.visit(node);
            }

            public boolean visit(SimilarImpl node) {
                node.setQuery(query);
                node.bindSelector(QueryImpl.this.source);
                return super.visit(node);
            }

            public boolean visit(SpellcheckImpl node) {
                node.setQuery(query);
                node.bindSelector(QueryImpl.this.source);
                return super.visit(node);
            }

            public boolean visit(FullTextSearchScoreImpl node) {
                node.setQuery(query);
                node.bindSelector(QueryImpl.this.source);
                return true;
            }

            public boolean visit(LiteralImpl node) {
                node.setQuery(query);
                return true;
            }

            public boolean visit(NodeLocalNameImpl node) {
                node.setQuery(query);
                node.bindSelector(QueryImpl.this.source);
                return true;
            }

            public boolean visit(NodeNameImpl node) {
                node.setQuery(query);
                node.bindSelector(QueryImpl.this.source);
                return true;
            }

            public boolean visit(PropertyExistenceImpl node) {
                node.setQuery(query);
                node.bindSelector(QueryImpl.this.source);
                return true;
            }

            public boolean visit(PropertyInexistenceImpl node) {
                node.setQuery(query);
                node.bindSelector(QueryImpl.this.source);
                return true;
            }

            public boolean visit(PropertyValueImpl node) {
                node.setQuery(query);
                node.bindSelector(QueryImpl.this.source);
                return true;
            }

            public boolean visit(SameNodeImpl node) {
                node.setQuery(query);
                node.bindSelector(QueryImpl.this.source);
                return true;
            }

            public boolean visit(SameNodeJoinConditionImpl node) {
                node.setQuery(query);
                node.bindSelector(QueryImpl.this.source);
                return true;
            }

            public boolean visit(SelectorImpl node) {
                String name = node.getSelectorName();
                if (QueryImpl.this.selectorIndexes.put(name, QueryImpl.this.selectors.size()) != null) {
                    throw new IllegalArgumentException("Two selectors with the same name: " + name);
                }
                QueryImpl.this.selectors.add(node);
                node.setQuery(query);
                return true;
            }

            public boolean visit(LengthImpl node) {
                node.setQuery(query);
                return super.visit(node);
            }

            public boolean visit(UpperCaseImpl node) {
                node.setQuery(query);
                return super.visit(node);
            }

            public boolean visit(LowerCaseImpl node) {
                node.setQuery(query);
                return super.visit(node);
            }

            public boolean visit(ComparisonImpl node) {
                node.setQuery(query);
                return super.visit(node);
            }

            public boolean visit(InImpl node) {
                node.setQuery(query);
                return super.visit(node);
            }

            public boolean visit(AndImpl node) {
                node.setQuery(query);
                return super.visit(node);
            }

            public boolean visit(OrImpl node) {
                node.setQuery(query);
                return super.visit(node);
            }

            public boolean visit(NotImpl node) {
                node.setQuery(query);
                return super.visit(node);
            }
        }.visit(this);
        if (this.constraint != null) {
            this.constraint = this.constraint.simplify();
        }
        this.source.setQueryConstraint(this.constraint);
        for (ColumnImpl column : this.columns) {
            column.bindSelector(this.source);
        }
        this.distinctColumns = new boolean[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            ColumnImpl c = this.columns[i];
            boolean distinct = true;
            if (JCR_SCORE.equals(c.getPropertyName())) {
                distinct = false;
            }
            this.distinctColumns[i] = distinct;
        }
    }

    @Override
    public ColumnImpl[] getColumns() {
        return this.columns;
    }

    public ConstraintImpl getConstraint() {
        return this.constraint;
    }

    public OrderingImpl[] getOrderings() {
        return this.orderings;
    }

    public SourceImpl getSource() {
        return this.source;
    }

    @Override
    public void bindValue(String varName, PropertyValue value) {
        this.bindVariableMap.put(varName, value);
    }

    @Override
    public void setLimit(long limit) {
        this.limit = limit;
    }

    @Override
    public void setOffset(long offset) {
        this.offset = offset;
    }

    @Override
    public void setExplain(boolean explain) {
        this.explain = explain;
    }

    @Override
    public void setMeasure(boolean measure) {
        this.measure = measure;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    @Override
    public ResultImpl executeQuery() {
        return new ResultImpl(this);
    }

    @Override
    public Iterator<ResultRowImpl> getRows() {
        List<QueryIndex.OrderEntry> list;
        QueryIndex.IndexPlan plan;
        this.prepare();
        if (this.explain) {
            String plan2 = this.getPlan();
            this.columns = new ColumnImpl[]{new ColumnImpl("explain", "plan", "plan")};
            ResultRowImpl r = new ResultRowImpl(this, Tree.EMPTY_ARRAY, new PropertyValue[]{PropertyValues.newString(plan2)}, null, null);
            return Arrays.asList(r).iterator();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("query execute {} ", (Object)this.statement);
            LOG.debug("query plan {}", (Object)this.getPlan());
        }
        RowIterator rowIt = new RowIterator(this.context.getBaseState());
        boolean sortUsingIndex = false;
        if (this.orderings != null && this.selectors.size() == 1 && (plan = this.selectors.get(0).getExecutionPlan().getIndexPlan()) != null && (list = plan.getSortOrder()) != null && list.size() == this.orderings.length) {
            sortUsingIndex = true;
            for (int i = 0; i < list.size(); ++i) {
                QueryIndex.OrderEntry e = list.get(i);
                OrderingImpl o = this.orderings[i];
                DynamicOperandImpl op = o.getOperand();
                if (!(op instanceof PropertyValueImpl)) {
                    sortUsingIndex = false;
                    break;
                }
                String pn = ((PropertyValueImpl)op).getPropertyName();
                if (!pn.equals(e.getPropertyName())) {
                    sortUsingIndex = false;
                    break;
                }
                if (o.isDescending() == (e.getOrder() == QueryIndex.OrderEntry.Order.DESCENDING)) continue;
                sortUsingIndex = false;
                break;
            }
        }
        Comparator<ResultRowImpl> orderBy = sortUsingIndex ? null : ResultRowImpl.getComparator(this.orderings);
        Iterator<ResultRowImpl> it = FilterIterators.newCombinedFilter(rowIt, this.distinct, this.limit, this.offset, orderBy, this.settings);
        if (this.measure) {
            while (it.hasNext()) {
                it.next();
            }
            this.columns = new ColumnImpl[]{new ColumnImpl("measure", "selector", "selector"), new ColumnImpl("measure", "scanCount", "scanCount")};
            list = new ArrayList<QueryIndex.OrderEntry>();
            ResultRowImpl r = new ResultRowImpl(this, Tree.EMPTY_ARRAY, new PropertyValue[]{PropertyValues.newString("query"), PropertyValues.newLong(rowIt.getReadCount())}, null, null);
            ((ArrayList)list).add((QueryIndex.OrderEntry)((Object)r));
            for (SelectorImpl selector : this.selectors) {
                r = new ResultRowImpl(this, Tree.EMPTY_ARRAY, new PropertyValue[]{PropertyValues.newString(selector.getSelectorName()), PropertyValues.newLong(selector.getScanCount())}, null, null);
                ((ArrayList)list).add((QueryIndex.OrderEntry)((Object)r));
            }
            it = ((ArrayList)list).iterator();
        }
        return it;
    }

    @Override
    public String getPlan() {
        return this.source.getPlan(this.context.getBaseState());
    }

    @Override
    public double getEstimatedCost() {
        return this.estimatedCost;
    }

    @Override
    public void prepare() {
        if (this.prepared) {
            return;
        }
        this.prepared = true;
        List sources = this.source.getInnerJoinSelectors();
        List conditions = this.source.getInnerJoinConditions();
        if (sources.size() <= 1) {
            this.estimatedCost = this.source.prepare().getEstimatedCost();
            return;
        }
        SourceImpl result = null;
        HashSet available = new HashSet();
        while (sources.size() > 0) {
            int bestIndex = 0;
            double bestCost = Double.POSITIVE_INFINITY;
            ExecutionPlan bestPlan = null;
            SourceImpl best = null;
            for (int i = 0; i < sources.size(); ++i) {
                SourceImpl test = QueryImpl.buildJoin(result, (SourceImpl)sources.get(i), conditions);
                if (test == null) continue;
                ExecutionPlan testPlan = test.prepare();
                double cost = testPlan.getEstimatedCost();
                if (best == null || cost < bestCost) {
                    bestPlan = testPlan;
                    bestCost = cost;
                    bestIndex = i;
                    best = test;
                }
                test.unprepare();
            }
            available.add(sources.remove(bestIndex));
            result = best;
            best.prepare(bestPlan);
        }
        this.estimatedCost = result.prepare().getEstimatedCost();
        this.source = result;
    }

    private static SourceImpl buildJoin(SourceImpl result, SourceImpl last, List<JoinConditionImpl> conditions) {
        if (result == null) {
            return last;
        }
        List selectors = result.getInnerJoinSelectors();
        HashSet oldSelectors = new HashSet();
        oldSelectors.addAll(selectors);
        HashSet<SourceImpl> newSelectors = new HashSet<SourceImpl>();
        newSelectors.addAll(selectors);
        newSelectors.add(last);
        for (JoinConditionImpl j : conditions) {
            if (j.canEvaluate(oldSelectors) || !j.canEvaluate(newSelectors)) continue;
            JoinImpl join = new JoinImpl(result, last, JoinType.INNER, j);
            return join;
        }
        return null;
    }

    Filter createFilter(boolean preparing) {
        return this.source.createFilter(preparing);
    }

    ResultRowImpl currentRow() {
        PropertyValue[] orderValues;
        int selectorCount = this.selectors.size();
        Tree[] trees = new Tree[selectorCount];
        for (int i = 0; i < selectorCount; ++i) {
            SelectorImpl s = this.selectors.get(i);
            trees[i] = s.currentTree();
        }
        int columnCount = this.columns.length;
        PropertyValue[] values = new PropertyValue[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            ColumnImpl c = this.columns[i];
            values[i] = c.currentProperty();
        }
        if (this.orderings == null) {
            orderValues = null;
        } else {
            int size = this.orderings.length;
            orderValues = new PropertyValue[size];
            for (int i = 0; i < size; ++i) {
                orderValues[i] = this.orderings[i].getOperand().currentProperty();
            }
        }
        return new ResultRowImpl(this, trees, values, this.distinctColumns, orderValues);
    }

    @Override
    public int getSelectorIndex(String selectorName) {
        Integer index = this.selectorIndexes.get(selectorName);
        if (index == null) {
            throw new IllegalArgumentException("Unknown selector: " + selectorName);
        }
        return index;
    }

    @Override
    public int getColumnIndex(String columnName) {
        return QueryImpl.getColumnIndex(this.columns, columnName);
    }

    static int getColumnIndex(ColumnImpl[] columns, String columnName) {
        int size = columns.length;
        for (int i = 0; i < size; ++i) {
            ColumnImpl c = columns[i];
            String cn = c.getColumnName();
            if (cn == null || !cn.equals(columnName)) continue;
            return i;
        }
        return -1;
    }

    public PropertyValue getBindVariableValue(String bindVariableName) {
        PropertyValue v = this.bindVariableMap.get(bindVariableName);
        if (v == null) {
            throw new IllegalArgumentException("Bind variable value not set: " + bindVariableName);
        }
        return v;
    }

    @Override
    public String[] getSelectorNames() {
        String[] list = new String[this.selectors.size()];
        for (int i = 0; i < list.length; ++i) {
            list[i] = this.selectors.get(i).getSelectorName();
        }
        return list;
    }

    @Override
    public List<String> getBindVariableNames() {
        return new ArrayList<String>(this.bindVariableMap.keySet());
    }

    @Override
    public void setTraversalEnabled(boolean traversalEnabled) {
        this.traversalEnabled = traversalEnabled;
    }

    public SelectorExecutionPlan getBestSelectorExecutionPlan(FilterImpl filter) {
        return this.getBestSelectorExecutionPlan(this.context.getBaseState(), filter, this.context.getIndexProvider(), this.traversalEnabled);
    }

    private SelectorExecutionPlan getBestSelectorExecutionPlan(NodeState rootState, FilterImpl filter, QueryIndexProvider indexProvider, boolean traversalEnabled) {
        Object bestIndex = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("cost using filter " + filter);
        }
        double bestCost = Double.POSITIVE_INFINITY;
        QueryIndex.IndexPlan bestPlan = null;
        for (QueryIndex queryIndex : indexProvider.getQueryIndexes(rootState)) {
            double cost;
            QueryIndex.IndexPlan indexPlan = null;
            if (queryIndex instanceof QueryIndex.AdvancedQueryIndex) {
                QueryIndex.AdvancedQueryIndex advIndex = (QueryIndex.AdvancedQueryIndex)((Object)queryIndex);
                ArrayList<QueryIndex.OrderEntry> sortOrder = null;
                if (this.orderings != null) {
                    OrderingImpl o;
                    DynamicOperandImpl op;
                    sortOrder = new ArrayList<QueryIndex.OrderEntry>();
                    OrderingImpl[] orderingImplArray = this.orderings;
                    int n = orderingImplArray.length;
                    for (int i = 0; i < n && (op = (o = orderingImplArray[i]).getOperand()) instanceof PropertyValueImpl; ++i) {
                        PropertyValueImpl p = (PropertyValueImpl)op;
                        SelectorImpl s = (SelectorImpl)p.getSelectors().iterator().next();
                        if (!s.equals((Object)filter.getSelector())) continue;
                        QueryIndex.OrderEntry e = new QueryIndex.OrderEntry(p.getPropertyName(), Type.UNDEFINED, o.isDescending() ? QueryIndex.OrderEntry.Order.DESCENDING : QueryIndex.OrderEntry.Order.ASCENDING);
                        sortOrder.add(e);
                    }
                    if (sortOrder.size() == 0) {
                        sortOrder = null;
                    }
                }
                long maxEntryCount = this.limit;
                if (this.offset > 0L) {
                    maxEntryCount = this.offset + this.limit < 0L ? Long.MAX_VALUE : this.offset + this.limit;
                }
                List<QueryIndex.IndexPlan> ipList = advIndex.getPlans((Filter)filter, sortOrder, rootState);
                cost = Double.POSITIVE_INFINITY;
                for (QueryIndex.IndexPlan p : ipList) {
                    long entryCount = Math.min(maxEntryCount, p.getEstimatedEntryCount());
                    double c = p.getCostPerExecution() + (double)entryCount * p.getCostPerEntry();
                    if (!(c < cost)) continue;
                    cost = c;
                    indexPlan = p;
                }
            } else {
                cost = queryIndex.getCost((Filter)filter, rootState);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("cost for " + queryIndex.getIndexName() + " is " + cost);
            }
            if (cost < 0.0) {
                LOG.error("cost below 0 for " + queryIndex.getIndexName() + " is " + cost);
            }
            if (!(cost < bestCost)) continue;
            bestCost = cost;
            bestIndex = queryIndex;
            bestPlan = indexPlan;
        }
        if (traversalEnabled) {
            TraversingIndex traversal = new TraversingIndex();
            double d = traversal.getCost((Filter)filter, rootState);
            if (LOG.isDebugEnabled()) {
                LOG.debug("cost for " + traversal.getIndexName() + " is " + d);
            }
            if (d < bestCost || bestCost == Double.POSITIVE_INFINITY) {
                bestCost = d;
                bestPlan = null;
                bestIndex = traversal;
            }
        }
        return new SelectorExecutionPlan(filter.getSelector(), bestIndex, bestPlan, bestCost);
    }

    @Override
    public void setExecutionContext(ExecutionContext context) {
        this.context = context;
    }

    @Override
    public void setOrderings(OrderingImpl[] orderings) {
        this.orderings = orderings;
    }

    public NamePathMapper getNamePathMapper() {
        return this.namePathMapper;
    }

    @Override
    public Tree getTree(String path) {
        if (NodeStateUtils.isHiddenPath(path)) {
            if (!this.warnedHidden) {
                this.warnedHidden = true;
                LOG.warn("Hidden tree traversed: {}", (Object)path);
            }
            return null;
        }
        return this.context.getRoot().getTree(path);
    }

    @Override
    public boolean isMeasureOrExplainEnabled() {
        return this.explain || this.measure;
    }

    public String getOakPath(String path) {
        if (path == null) {
            return null;
        }
        if (!JcrPathParser.validate(path)) {
            throw new IllegalArgumentException("Invalid path: " + path);
        }
        String p = this.namePathMapper.getOakPath(path);
        if (p == null) {
            throw new IllegalArgumentException("Invalid path or namespace prefix: " + path);
        }
        return p;
    }

    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append("select ");
        int i = 0;
        for (ColumnImpl columnImpl : this.columns) {
            if (i++ > 0) {
                buff.append(", ");
            }
            buff.append(columnImpl);
        }
        buff.append(" from ").append(this.source);
        if (this.constraint != null) {
            buff.append(" where ").append(this.constraint);
        }
        if (this.orderings != null) {
            buff.append(" order by ");
            i = 0;
            for (ColumnImpl columnImpl : this.orderings) {
                if (i++ > 0) {
                    buff.append(", ");
                }
                buff.append(columnImpl);
            }
        }
        return buff.toString();
    }

    @Override
    public long getSize() {
        return this.size;
    }

    public String getStatement() {
        return this.statement;
    }

    public QueryEngineSettings getSettings() {
        return this.settings;
    }

    public ExecutionContext getExecutionContext() {
        return this.context;
    }

    class RowIterator
    implements Iterator<ResultRowImpl> {
        private final NodeState rootState;
        private ResultRowImpl current;
        private boolean started;
        private boolean end;
        private long rowIndex;

        RowIterator(NodeState rootState) {
            this.rootState = rootState;
        }

        public long getReadCount() {
            return this.rowIndex;
        }

        private void fetchNext() {
            block3: {
                if (this.end) {
                    return;
                }
                if (!this.started) {
                    QueryImpl.this.source.execute(this.rootState);
                    this.started = true;
                }
                while (QueryImpl.this.source.next()) {
                    if (QueryImpl.this.constraint != null && !QueryImpl.this.constraint.evaluate()) continue;
                    this.current = QueryImpl.this.currentRow();
                    ++this.rowIndex;
                    break block3;
                }
                this.current = null;
                this.end = true;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.end) {
                return false;
            }
            if (this.current == null) {
                this.fetchNext();
            }
            return !this.end;
        }

        @Override
        public ResultRowImpl next() {
            if (this.end) {
                return null;
            }
            if (this.current == null) {
                this.fetchNext();
            }
            ResultRowImpl r = this.current;
            this.current = null;
            return r;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

