/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.query.fulltext;

public class LikePattern {
    private static final int MATCH = 0;
    private static final int ONE = 1;
    private static final int ANY = 2;
    private String patternString;
    private boolean invalidPattern;
    private char[] patternChars;
    private int[] patternTypes;
    private int patternLength;
    private String lowerBounds;
    private String upperBound;

    public LikePattern(String pattern) {
        this.initPattern(pattern);
        this.initBounds();
    }

    public boolean matches(String value) {
        return !this.invalidPattern && this.compareAt(value, 0, 0, value.length(), this.patternChars, this.patternTypes);
    }

    private static boolean compare(char[] pattern, String s, int pi, int si) {
        return pattern[pi] == s.charAt(si);
    }

    private boolean compareAt(String s, int pi, int si, int sLen, char[] pattern, int[] types) {
        while (pi < this.patternLength) {
            int type = types[pi];
            switch (type) {
                case 0: {
                    if (si < sLen && LikePattern.compare(pattern, s, pi, si++)) break;
                    return false;
                }
                case 1: {
                    if (si++ < sLen) break;
                    return false;
                }
                case 2: {
                    if (++pi >= this.patternLength) {
                        return true;
                    }
                    while (si < sLen) {
                        if (LikePattern.compare(pattern, s, pi, si) && this.compareAt(s, pi, si, sLen, pattern, types)) {
                            return true;
                        }
                        ++si;
                    }
                    return false;
                }
                default: {
                    throw new IllegalArgumentException("Internal error: " + type);
                }
            }
            ++pi;
        }
        return si == sLen;
    }

    private void initPattern(String p) {
        int i;
        this.patternLength = 0;
        if (p == null) {
            this.patternTypes = null;
            this.patternChars = null;
            return;
        }
        int len = p.length();
        this.patternChars = new char[len];
        this.patternTypes = new int[len];
        boolean lastAny = false;
        for (i = 0; i < len; ++i) {
            int type;
            char c = p.charAt(i);
            if (c == '\\') {
                if (i >= len - 1) {
                    this.invalidPattern = true;
                    return;
                }
                c = p.charAt(++i);
                type = 0;
                lastAny = false;
            } else if (c == '%') {
                if (lastAny) continue;
                type = 2;
                lastAny = true;
            } else if (c == '_') {
                type = 1;
            } else {
                type = 0;
                lastAny = false;
            }
            this.patternTypes[this.patternLength] = type;
            this.patternChars[this.patternLength++] = c;
        }
        for (i = 0; i < this.patternLength - 1; ++i) {
            if (this.patternTypes[i] != 2 || this.patternTypes[i + 1] != 1) continue;
            this.patternTypes[i] = 1;
            this.patternTypes[i + 1] = 2;
        }
        this.patternString = new String(this.patternChars, 0, this.patternLength);
    }

    public String toString() {
        return this.patternString;
    }

    public String getLowerBound() {
        return this.lowerBounds;
    }

    public String getUpperBound() {
        return this.upperBound;
    }

    private void initBounds() {
        if (this.invalidPattern) {
            return;
        }
        if (this.patternLength <= 0 || this.patternTypes[0] != 0) {
            return;
        }
        int maxMatch = 0;
        StringBuilder buff = new StringBuilder();
        while (maxMatch < this.patternLength && this.patternTypes[maxMatch] == 0) {
            buff.append(this.patternChars[maxMatch++]);
        }
        String lower = buff.toString();
        if (lower.isEmpty()) {
            return;
        }
        if (maxMatch == this.patternLength) {
            this.lowerBounds = this.upperBound = lower;
            return;
        }
        this.lowerBounds = lower;
        char next = lower.charAt(lower.length() - 1);
        for (int i = 1; i < 2000; ++i) {
            String upper = lower.substring(0, lower.length() - 1) + (char)(next + i);
            if (upper.compareTo(lower) <= 0) continue;
            this.upperBound = upper;
            return;
        }
    }
}

