/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.authentication.external;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.util.Text;

public class ExternalIdentityRef {
    private final String id;
    private final String providerName;
    private final String string;

    public ExternalIdentityRef(@Nonnull String id, @CheckForNull String providerName) {
        this.id = id;
        this.providerName = providerName;
        StringBuilder b = new StringBuilder();
        this.escape(b, id);
        if (providerName != null && providerName.length() > 0) {
            b.append(';');
            this.escape(b, providerName);
        }
        this.string = b.toString();
    }

    @CheckForNull
    public String getProviderName() {
        return this.providerName;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    @Nonnull
    public String getString() {
        return this.string;
    }

    public static ExternalIdentityRef fromString(@Nonnull String str) {
        int idx = str.indexOf(59);
        if (idx < 0) {
            return new ExternalIdentityRef(Text.unescape(str), null);
        }
        return new ExternalIdentityRef(Text.unescape(str.substring(0, idx)), Text.unescape(str.substring(idx + 1)));
    }

    private void escape(StringBuilder builder, CharSequence str) {
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c == '%') {
                builder.append("%25");
                continue;
            }
            if (c == ';') {
                builder.append("%3b");
                continue;
            }
            builder.append(c);
        }
    }

    public String toString() {
        return "ExternalIdentityRef{id='" + this.id + '\'' + ", providerName='" + this.providerName + '\'' + '}';
    }

    public boolean equals(Object o) {
        try {
            return this == o || this.string.equals(((ExternalIdentityRef)o).string);
        }
        catch (Exception e) {
            return false;
        }
    }

    public int hashCode() {
        return this.string.hashCode();
    }
}

