/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security.principal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.security.Principal;
import java.security.acl.Group;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.jackrabbit.oak.spi.security.principal.PrincipalProvider;

public class CompositePrincipalProvider
implements PrincipalProvider {
    private final List<PrincipalProvider> providers;

    public CompositePrincipalProvider(List<PrincipalProvider> providers) {
        this.providers = (List)Preconditions.checkNotNull(providers);
    }

    @Override
    public Principal getPrincipal(String principalName) {
        Principal principal = null;
        for (int i = 0; i < this.providers.size() && principal == null; ++i) {
            principal = this.providers.get(i).getPrincipal(principalName);
        }
        return principal;
    }

    @Override
    public Set<Group> getGroupMembership(Principal principal) {
        HashSet<Group> groups = new HashSet<Group>();
        for (PrincipalProvider provider : this.providers) {
            groups.addAll(provider.getGroupMembership(principal));
        }
        return groups;
    }

    public Set<Principal> getPrincipals(String userID) {
        HashSet<Principal> principals = new HashSet<Principal>();
        for (PrincipalProvider provider : this.providers) {
            principals.addAll(provider.getPrincipals(userID));
        }
        return principals;
    }

    public Iterator<Principal> findPrincipals(String nameHint, int searchType) {
        Iterator[] iterators = new Iterator[this.providers.size()];
        int i = 0;
        for (PrincipalProvider provider : this.providers) {
            if (nameHint == null) {
                iterators[i++] = provider.findPrincipals(searchType);
                continue;
            }
            iterators[i++] = provider.findPrincipals(nameHint, searchType);
        }
        return Iterators.concat((Iterator[])iterators);
    }

    @Override
    public Iterator<? extends Principal> findPrincipals(int searchType) {
        return this.findPrincipals(null, searchType);
    }
}

