/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.state;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.CommitFailedException;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.spi.commit.ChangeDispatcher;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.state.ConflictAnnotatingRebaseDiff;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStore;
import org.apache.jackrabbit.oak.spi.state.NodeStoreBranch;
import org.apache.jackrabbit.oak.util.PerfLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNodeStoreBranch<S extends NodeStore, N extends NodeState>
implements NodeStoreBranch {
    private static final Logger log = LoggerFactory.getLogger(AbstractNodeStoreBranch.class);
    private static final PerfLogger perfLogger = new PerfLogger(LoggerFactory.getLogger((String)(AbstractNodeStoreBranch.class.getName() + ".perf")));
    private static final Random RANDOM = new Random();
    private static final long MIN_BACKOFF = 50L;
    protected static final ConcurrentMap<Thread, AbstractNodeStoreBranch> BRANCHES = Maps.newConcurrentMap();
    protected final S store;
    protected final ChangeDispatcher dispatcher;
    protected final long maximumBackoff;
    protected final long maxLockTryTimeMS;
    private final Lock mergeLock;
    private BranchState branchState;

    public AbstractNodeStoreBranch(S kernelNodeStore, ChangeDispatcher dispatcher, Lock mergeLock, N base) {
        this(kernelNodeStore, dispatcher, mergeLock, base, null, TimeUnit.MILLISECONDS.convert(10L, TimeUnit.SECONDS), Integer.MAX_VALUE);
    }

    public AbstractNodeStoreBranch(S kernelNodeStore, ChangeDispatcher dispatcher, Lock mergeLock, N base, N head, long maximumBackoff, long maxLockTryTimeMS) {
        this.store = (NodeStore)Preconditions.checkNotNull(kernelNodeStore);
        this.dispatcher = dispatcher;
        this.mergeLock = (Lock)Preconditions.checkNotNull((Object)mergeLock);
        this.branchState = head == null ? new Unmodified(this, (NodeState)Preconditions.checkNotNull(base)) : new Persisted(this, (NodeState)Preconditions.checkNotNull(base), head);
        this.maximumBackoff = Math.max(maximumBackoff, 50L);
        this.maxLockTryTimeMS = maxLockTryTimeMS;
    }

    protected abstract N getRoot();

    protected abstract N createBranch(N var1);

    protected abstract N rebase(N var1, N var2);

    protected abstract N merge(N var1, CommitInfo var2) throws CommitFailedException;

    @Nonnull
    protected abstract N reset(@Nonnull N var1, @Nonnull N var2);

    protected abstract N persist(NodeState var1, N var2, CommitInfo var3);

    protected abstract N copy(String var1, String var2, N var3);

    protected abstract N move(String var1, String var2, N var3);

    protected abstract CommitFailedException convertUnchecked(Exception var1, String var2);

    public String toString() {
        return this.branchState.toString();
    }

    @Override
    @Nonnull
    public NodeState getBase() {
        return this.branchState.getBase();
    }

    @Override
    @Nonnull
    public NodeState getHead() {
        return this.branchState.getHead();
    }

    @Override
    public void setRoot(NodeState newRoot) {
        this.branchState.setRoot((NodeState)Preconditions.checkNotNull((Object)newRoot));
    }

    public boolean move(String source, String target) {
        if (PathUtils.isAncestor((String)Preconditions.checkNotNull((Object)source), (String)Preconditions.checkNotNull((Object)target))) {
            return false;
        }
        if (source.equals(target)) {
            return true;
        }
        if (!this.getNode(source).exists()) {
            return false;
        }
        NodeState destParent = this.getNode(PathUtils.getParentPath(target));
        if (!destParent.exists()) {
            return false;
        }
        if (destParent.getChildNode(PathUtils.getName(target)).exists()) {
            return false;
        }
        this.branchState.persist().move(source, target);
        return true;
    }

    public boolean copy(String source, String target) {
        if (!this.getNode((String)Preconditions.checkNotNull((Object)source)).exists()) {
            return false;
        }
        NodeState destParent = this.getNode(PathUtils.getParentPath((String)Preconditions.checkNotNull((Object)target)));
        if (!destParent.exists()) {
            return false;
        }
        if (destParent.getChildNode(PathUtils.getName(target)).exists()) {
            return false;
        }
        this.branchState.persist().copy(source, target);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nonnull
    public NodeState merge(@Nonnull CommitHook hook, @Nonnull CommitInfo info) throws CommitFailedException {
        Throwable ex = null;
        long time = System.currentTimeMillis();
        int numRetries = 0;
        long backoff = 50L;
        while (true) {
            long start;
            if (backoff > this.maximumBackoff) {
                time = System.currentTimeMillis() - time;
                String msg = ex.getMessage() + " (retries " + numRetries + ", " + time + " ms)";
                throw new CommitFailedException(((CommitFailedException)ex).getSource(), ((CommitFailedException)ex).getType(), ((CommitFailedException)ex).getCode(), msg, ex.getCause());
            }
            if (ex != null) {
                try {
                    start = perfLogger.start();
                    Thread.sleep(backoff + (long)RANDOM.nextInt((int)Math.min(backoff, Integer.MAX_VALUE)));
                    perfLogger.end(start, 1L, "Merge - Retry attempt [{}]", (Object)(++numRetries));
                }
                catch (InterruptedException e) {
                    throw new CommitFailedException("Merge", 3, "Merge interrupted", e);
                }
            }
            try {
                start = perfLogger.start();
                boolean acquired = this.mergeLock.tryLock(this.maxLockTryTimeMS, TimeUnit.MILLISECONDS);
                perfLogger.end(start, 1L, "Merge - Acquired lock", new Object[0]);
                try {
                    NodeState nodeState = this.branchState.merge((CommitHook)Preconditions.checkNotNull((Object)hook), (CommitInfo)Preconditions.checkNotNull((Object)info));
                    return nodeState;
                }
                catch (CommitFailedException e) {
                    log.trace("Merge Error", (Throwable)e);
                    ex = e;
                    if (!e.isOfType("Merge")) {
                        throw e;
                    }
                }
                finally {
                    if (acquired) {
                        this.mergeLock.unlock();
                    }
                }
            }
            catch (InterruptedException e) {
                throw new CommitFailedException("Oak", 1, "Unable to acquire merge lock", e);
            }
            backoff *= 2L;
        }
    }

    @Override
    public void rebase() {
        this.branchState.rebase();
    }

    private NodeState getNode(String path) {
        NodeState node = this.getHead();
        for (String name : PathUtils.elements(path)) {
            node = node.getChildNode(name);
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T withCurrentBranch(Callable<T> callable) throws Exception {
        Thread t = Thread.currentThread();
        AbstractNodeStoreBranch previous = BRANCHES.putIfAbsent(t, this);
        try {
            T t2 = callable.call();
            return t2;
        }
        finally {
            if (previous == null) {
                BRANCHES.remove(t, this);
            }
        }
    }

    private static class ResetFailed
    extends BranchState {
        private final CommitFailedException ex;
        final /* synthetic */ AbstractNodeStoreBranch this$0;

        protected ResetFailed(N base, CommitFailedException e) {
            this.this$0 = var1_1;
            super((AbstractNodeStoreBranch)var1_1, base);
            this.ex = e;
        }

        @Override
        @Nonnull
        NodeState getHead() {
            throw new IllegalStateException("Branch with failed reset");
        }

        @Override
        void setRoot(NodeState root) {
            throw new IllegalStateException("Branch with failed reset");
        }

        @Override
        void rebase() {
            throw new IllegalStateException("Branch with failed reset");
        }

        @Override
        @Nonnull
        NodeState merge(@Nonnull CommitHook hook, @Nonnull CommitInfo info) throws CommitFailedException {
            throw this.ex;
        }
    }

    private static class Merged
    extends BranchState {
        final /* synthetic */ AbstractNodeStoreBranch this$0;

        protected Merged(N base) {
            this.this$0 = var1_1;
            super((AbstractNodeStoreBranch)var1_1, base);
        }

        public String toString() {
            return "Merged[" + this.base + ']';
        }

        @Override
        @Nonnull
        NodeState getHead() {
            throw new IllegalStateException("Branch has already been merged");
        }

        @Override
        void setRoot(NodeState root) {
            throw new IllegalStateException("Branch has already been merged");
        }

        @Override
        void rebase() {
            throw new IllegalStateException("Branch has already been merged");
        }

        @Override
        @Nonnull
        NodeState merge(@Nonnull CommitHook hook, @Nonnull CommitInfo info) {
            throw new IllegalStateException("Branch has already been merged");
        }
    }

    private static class Persisted
    extends BranchState {
        private N head;
        final /* synthetic */ AbstractNodeStoreBranch this$0;

        public String toString() {
            return "Persisted[" + this.base + ", " + this.head + ']';
        }

        Persisted(N base) {
            this.this$0 = var1_1;
            super((AbstractNodeStoreBranch)var1_1, base);
            this.head = var1_1.createBranch(base);
        }

        Persisted(N base, N head) {
            this.this$0 = var1_1;
            super((AbstractNodeStoreBranch)var1_1, base);
            var1_1.createBranch(base);
            this.head = head;
        }

        void move(String source, String target) {
            this.head = this.this$0.move(source, target, this.head);
        }

        void copy(String source, String target) {
            this.head = this.this$0.copy(source, target, this.head);
        }

        @Override
        @Nonnull
        NodeState getHead() {
            return this.head;
        }

        @Override
        void setRoot(NodeState root) {
            if (!this.head.equals(root)) {
                this.persistTransientHead(root);
            }
        }

        @Override
        void rebase() {
            Object root = this.this$0.getRoot();
            this.head = this.this$0.rebase(this.head, root);
            this.base = root;
        }

        @Override
        @Nonnull
        NodeState merge(final @Nonnull CommitHook hook, final @Nonnull CommitInfo info) throws CommitFailedException {
            boolean success = false;
            Object previousHead = this.head;
            try {
                this.rebase();
                previousHead = this.head;
                this.this$0.dispatcher.contentChanged(this.base, null);
                NodeState newRoot = (NodeState)this.this$0.withCurrentBranch(new Callable<N>(){

                    @Override
                    public N call() throws Exception {
                        NodeState toCommit = ((CommitHook)Preconditions.checkNotNull((Object)hook)).processCommit(Persisted.this.base, Persisted.this.head, info);
                        Persisted.this.head = Persisted.this.this$0.persist(toCommit, Persisted.this.head, info);
                        return Persisted.this.this$0.merge(Persisted.this.head, info);
                    }
                });
                this.this$0.branchState = new Merged(this.this$0, this.base);
                success = true;
                this.this$0.dispatcher.contentChanged(newRoot, info);
                NodeState nodeState = newRoot;
                return nodeState;
            }
            catch (Exception e) {
                if (e instanceof CommitFailedException) {
                    throw (CommitFailedException)e;
                }
                throw new CommitFailedException("Merge", 1, "Failed to merge changes to the underlying store", e);
            }
            finally {
                if (!success) {
                    this.resetBranch(this.head, previousHead);
                }
                this.this$0.dispatcher.contentChanged((NodeState)this.this$0.getRoot(), null);
            }
        }

        private void persistTransientHead(NodeState newHead) {
            this.head = this.this$0.persist(newHead, this.head, null);
        }

        private void resetBranch(N branchHead, N ancestor) {
            try {
                this.head = this.this$0.reset(branchHead, ancestor);
            }
            catch (Exception e) {
                CommitFailedException ex = new CommitFailedException("Oak", 100, "Branch reset failed", e);
                this.this$0.branchState = new ResetFailed(this.this$0, this.base, ex);
            }
        }
    }

    private static class InMemory
    extends BranchState {
        private NodeState head;
        final /* synthetic */ AbstractNodeStoreBranch this$0;

        public String toString() {
            return "InMemory[" + this.base + ", " + this.head + ']';
        }

        InMemory(N base, NodeState head) {
            this.this$0 = var1_1;
            super((AbstractNodeStoreBranch)var1_1, base);
            this.head = head;
        }

        @Override
        @Nonnull
        NodeState getHead() {
            return this.head;
        }

        @Override
        void setRoot(NodeState root) {
            if (this.base.equals(root)) {
                this.this$0.branchState = new Unmodified(this.this$0, this.base);
            } else if (!this.head.equals(root)) {
                this.head = root;
                this.persist();
            }
        }

        @Override
        void rebase() {
            Object root = this.this$0.getRoot();
            NodeBuilder builder = root.builder();
            this.head.compareAgainstBaseState(this.base, new ConflictAnnotatingRebaseDiff(builder));
            this.head = builder.getNodeState();
            this.base = root;
        }

        @Override
        @Nonnull
        NodeState merge(@Nonnull CommitHook hook, @Nonnull CommitInfo info) throws CommitFailedException {
            Preconditions.checkNotNull((Object)hook);
            Preconditions.checkNotNull((Object)info);
            try {
                this.rebase();
                this.this$0.dispatcher.contentChanged(this.base, null);
                NodeState toCommit = hook.processCommit(this.base, this.head, info);
                try {
                    NodeState newHead = this.this$0.persist(toCommit, this.base, info);
                    this.this$0.dispatcher.contentChanged(newHead, info);
                    this.this$0.branchState = new Merged(this.this$0, this.base);
                    NodeState nodeState = newHead;
                    return nodeState;
                }
                catch (Exception e) {
                    throw this.this$0.convertUnchecked(e, "Failed to merge changes to the underlying store");
                }
            }
            finally {
                this.this$0.dispatcher.contentChanged((NodeState)this.this$0.getRoot(), null);
            }
        }
    }

    private static class Unmodified
    extends BranchState {
        final /* synthetic */ AbstractNodeStoreBranch this$0;

        Unmodified(N base) {
            this.this$0 = var1_1;
            super((AbstractNodeStoreBranch)var1_1, base);
        }

        public String toString() {
            return "Unmodified[" + this.base + ']';
        }

        @Override
        @Nonnull
        NodeState getHead() {
            return this.base;
        }

        @Override
        void setRoot(NodeState root) {
            if (!this.base.equals(root)) {
                this.this$0.branchState = new InMemory(this.this$0, this.base, root);
            }
        }

        @Override
        void rebase() {
            this.base = this.this$0.getRoot();
        }

        @Override
        @Nonnull
        NodeState merge(@Nonnull CommitHook hook, @Nonnull CommitInfo info) {
            this.this$0.branchState = new Merged(this.this$0, this.base);
            return this.base;
        }
    }

    private static abstract class BranchState {
        protected N base;
        final /* synthetic */ AbstractNodeStoreBranch this$0;

        protected BranchState(N base) {
            this.this$0 = var1_1;
            this.base = base;
        }

        Persisted persist() {
            Persisted p = new Persisted(this.this$0, this.base);
            p.persistTransientHead(this.getHead());
            this.this$0.branchState = p;
            return p;
        }

        N getBase() {
            return this.base;
        }

        @Nonnull
        abstract NodeState getHead();

        abstract void setRoot(NodeState var1);

        abstract void rebase();

        @Nonnull
        abstract NodeState merge(@Nonnull CommitHook var1, @Nonnull CommitInfo var2) throws CommitFailedException;
    }
}

