/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.whiteboard;

import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.security.AccessControlException;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.CompositeRestrictionProvider;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.Restriction;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionDefinition;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionPattern;
import org.apache.jackrabbit.oak.spi.security.authorization.restriction.RestrictionProvider;
import org.apache.jackrabbit.oak.spi.whiteboard.AbstractServiceTracker;

public class WhiteboardRestrictionProvider
extends AbstractServiceTracker<RestrictionProvider>
implements RestrictionProvider {
    public WhiteboardRestrictionProvider() {
        super(RestrictionProvider.class);
    }

    @Override
    @Nonnull
    public Set<RestrictionDefinition> getSupportedRestrictions(@Nullable String oakPath) {
        return this.getProvider().getSupportedRestrictions(oakPath);
    }

    @Override
    @Nonnull
    public Restriction createRestriction(@Nullable String oakPath, @Nonnull String oakName, @Nonnull Value value) throws AccessControlException, RepositoryException {
        return this.getProvider().createRestriction(oakPath, oakName, value);
    }

    @Override
    @Nonnull
    public Restriction createRestriction(@Nullable String oakPath, @Nonnull String oakName, Value ... values) throws AccessControlException, RepositoryException {
        return this.getProvider().createRestriction(oakPath, oakName, values);
    }

    @Override
    @Nonnull
    public Set<Restriction> readRestrictions(@Nullable String oakPath, @Nonnull Tree aceTree) {
        return this.getProvider().readRestrictions(oakPath, aceTree);
    }

    @Override
    public void writeRestrictions(String oakPath, Tree aceTree, Set<Restriction> restrictions) throws RepositoryException {
        this.getProvider().writeRestrictions(oakPath, aceTree, restrictions);
    }

    @Override
    public void validateRestrictions(@Nullable String oakPath, @Nonnull Tree aceTree) throws AccessControlException, RepositoryException {
        this.getProvider().validateRestrictions(oakPath, aceTree);
    }

    @Override
    @Nonnull
    public RestrictionPattern getPattern(@Nullable String oakPath, @Nonnull Tree tree) {
        return this.getProvider().getPattern(oakPath, tree);
    }

    @Override
    @Nonnull
    public RestrictionPattern getPattern(@Nullable String oakPath, @Nonnull Set<Restriction> restrictions) {
        return this.getProvider().getPattern(oakPath, restrictions);
    }

    private RestrictionProvider getProvider() {
        return CompositeRestrictionProvider.newInstance(this.getServices());
    }
}

