/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.xml;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ImportBehavior {
    private static final Logger log = LoggerFactory.getLogger(ImportBehavior.class);
    public static final int IGNORE = 1;
    public static final int BESTEFFORT = 2;
    public static final int ABORT = 3;
    public static final String NAME_IGNORE = "ignore";
    public static final String NAME_BESTEFFORT = "besteffort";
    public static final String NAME_ABORT = "abort";

    private ImportBehavior() {
    }

    public static int valueFromString(String behaviorString) {
        if (NAME_IGNORE.equalsIgnoreCase(behaviorString)) {
            return 1;
        }
        if (NAME_BESTEFFORT.equalsIgnoreCase(behaviorString)) {
            return 2;
        }
        if (NAME_ABORT.equalsIgnoreCase(behaviorString)) {
            return 3;
        }
        log.error("Invalid behavior " + behaviorString + " -> Using default: ABORT.");
        return 3;
    }

    public static String nameFromValue(int importBehavior) {
        switch (importBehavior) {
            case 1: {
                return NAME_IGNORE;
            }
            case 3: {
                return NAME_ABORT;
            }
            case 2: {
                return NAME_BESTEFFORT;
            }
        }
        throw new IllegalArgumentException("Invalid import behavior: " + importBehavior);
    }
}

