/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputStreamPump
extends InputStream {
    private static final Logger log = LoggerFactory.getLogger(InputStreamPump.class);
    private final InputStream source;
    private final PipedOutputStream out;
    private final PipedInputStream in;
    private Thread pumpThread;
    private Exception error;

    public InputStreamPump(InputStream source, final Pump pump) throws IOException {
        this.source = source;
        this.out = new PipedOutputStream();
        this.in = new PipedInputStream(this.out, 8192);
        this.pumpThread = new Thread(new Runnable(){

            public void run() {
                try {
                    pump.run((InputStream)new CloseShieldInputStream((InputStream)InputStreamPump.this.in));
                    byte[] buffer = new byte[8192];
                    while (InputStreamPump.this.in.read(buffer) >= 0) {
                    }
                }
                catch (Exception e) {
                    InputStreamPump.this.error = e;
                    log.error("Error while processing input stream", (Throwable)e);
                }
            }
        });
        this.pumpThread.start();
    }

    public Exception getError() {
        return this.error;
    }

    public int read() throws IOException {
        int b = this.source.read();
        if (b >= 0) {
            this.out.write(b);
        }
        return b;
    }

    public int read(byte[] b) throws IOException {
        int len = this.source.read(b);
        if (len > 0) {
            this.out.write(b, 0, len);
        }
        return len;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.source.read(b, off, len);
        if (read > 0) {
            this.out.write(b, off, read);
        }
        return read;
    }

    public long skip(long n) throws IOException {
        return this.source.skip(n);
    }

    public int available() throws IOException {
        return this.source.available();
    }

    public void close() throws IOException {
        this.source.close();
        this.out.flush();
        try {
            this.out.close();
            this.pumpThread.join();
            this.in.close();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public void mark(int readlimit) {
    }

    public void reset() throws IOException {
    }

    public boolean markSupported() {
        return false;
    }

    public static interface Pump {
        public void run(InputStream var1) throws Exception;
    }
}

