/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.api.wrappers;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeepReadValueMapDecorator
extends ValueMapDecorator {
    private final String pathPrefix;
    private final ResourceResolver resolver;
    private final ValueMap base;

    public DeepReadValueMapDecorator(Resource resource, ValueMap base) {
        super(base);
        this.pathPrefix = resource.getPath() + "/";
        this.resolver = resource.getResourceResolver();
        this.base = base;
    }

    private ValueMap getValueMap(String name) {
        ValueMap vm;
        int pos = name.lastIndexOf("/");
        if (pos == -1) {
            return this.base;
        }
        Resource rsrc = this.resolver.getResource(this.pathPrefix + name.substring(0, pos));
        if (rsrc != null && (vm = rsrc.adaptTo(ValueMap.class)) != null) {
            return vm;
        }
        return ValueMap.EMPTY;
    }

    private String getPropertyName(String name) {
        int pos = name.lastIndexOf("/");
        if (pos == -1) {
            return name;
        }
        return name.substring(pos + 1);
    }

    @Override
    public <T> T get(String name, Class<T> type) {
        return (T)this.getValueMap(name).get(this.getPropertyName(name), type);
    }

    @Override
    public <T> T get(String name, T defaultValue) {
        return this.getValueMap(name).get(this.getPropertyName(name), defaultValue);
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        String name = key.toString();
        return this.getValueMap(name).containsKey(this.getPropertyName(name));
    }

    @Override
    public Object get(Object key) {
        if (key == null) {
            return null;
        }
        String name = key.toString();
        return this.getValueMap(name).get(this.getPropertyName(name));
    }
}

