/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.api;

import java.io.InputStream;
import java.util.Dictionary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallableResource {
    public static final String TYPE_PROPERTIES = "properties";
    public static final String TYPE_FILE = "file";
    public static final String TYPE_BUNDLE = "bundle";
    public static final String TYPE_CONFIG = "config";
    public static final String BUNDLE_START_LEVEL = "bundle.startlevel";
    public static final String INSTALLATION_HINT = "installation.hint";
    public static final String RESOURCE_URI_HINT = "resource.uri.hint";
    public static final int DEFAULT_PRIORITY = 100;
    private final String id;
    private final String digest;
    private final InputStream inputStream;
    private final Dictionary<String, Object> dictionary;
    private final int priority;
    private final String resourceType;

    public InstallableResource(String id, InputStream is, Dictionary<String, Object> dict, String digest, String type, Integer priority) {
        if (id == null) {
            throw new IllegalArgumentException("id must not be null.");
        }
        if (is == null && dict == null) {
            throw new IllegalArgumentException("dictionary must not be null (or input stream must not be null).");
        }
        this.id = id;
        this.inputStream = is;
        this.dictionary = dict;
        this.digest = digest;
        this.priority = priority != null ? priority : 100;
        this.resourceType = type;
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.resourceType;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public Dictionary<String, Object> getDictionary() {
        return this.dictionary;
    }

    public String getDigest() {
        return this.digest;
    }

    public int getPriority() {
        return this.priority;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ", priority=" + this.priority + ", id=" + this.id;
    }
}

