/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.jsp.taglib;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyContent;
import org.apache.commons.io.IOUtils;
import org.apache.sling.scripting.jsp.taglib.AbstractDispatcherTagHandler;

public class IncludeTagHandler
extends AbstractDispatcherTagHandler {
    private static final long serialVersionUID = 2835586777145471683L;
    private boolean flush = false;
    private String var = null;
    private Integer scope = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispatch(RequestDispatcher dispatcher, ServletRequest request, ServletResponse response) throws IOException, ServletException {
        if (this.flush && !(this.pageContext.getOut() instanceof BodyContent)) {
            this.pageContext.getOut().flush();
        }
        if (this.var == null) {
            dispatcher.include(request, response);
        } else {
            String encoding = response.getCharacterEncoding();
            BufferedServletOutputStream bsops = new BufferedServletOutputStream(encoding);
            try {
                CaptureResponseWrapper wrapper = new CaptureResponseWrapper((HttpServletResponse)response, bsops);
                dispatcher.include(request, (ServletResponse)wrapper);
                if (!wrapper.isBinaryResponse()) {
                    wrapper.flushBuffer();
                    this.pageContext.setAttribute(this.var, (Object)bsops.getBuffer(), this.scope.intValue());
                }
            }
            finally {
                IOUtils.closeQuietly((OutputStream)((Object)bsops));
            }
        }
    }

    public void setPageContext(PageContext pageContext) {
        super.setPageContext(pageContext);
        this.flush = false;
        this.var = null;
        this.scope = 1;
    }

    public void setFlush(boolean flush) {
        this.flush = flush;
    }

    public void setVar(String var) {
        if (var != null && var.trim().length() > 0) {
            this.var = var;
        }
    }

    public void setScope(String scope) {
        this.scope = this.validScope(scope);
    }

    private Integer validScope(String scope) {
        String string = scope = scope != null && scope.trim().length() > 0 ? scope.trim().toUpperCase() : null;
        if (scope == null) {
            return 1;
        }
        String[] scopes = new String[]{"PAGE", "REQUEST", "SESSION", "APPLICATION"};
        Integer[] iaScopes = new Integer[]{1, 2, 3, 4};
        int len = scopes.length;
        for (int ndx = 0; ndx < len; ++ndx) {
            if (!scopes[ndx].equals(scope)) continue;
            return iaScopes[ndx];
        }
        return 1;
    }

    private static final class BufferedServletOutputStream
    extends ServletOutputStream {
        private final ByteArrayOutputStream baops = new ByteArrayOutputStream();
        private final String encoding;

        public BufferedServletOutputStream(String encoding) {
            this.encoding = encoding;
        }

        public String getBuffer() throws IOException {
            return this.baops.toString(this.encoding);
        }

        public void close() throws IOException {
            this.baops.reset();
            super.close();
        }

        public void write(int b) throws IOException {
            this.baops.write(b);
        }
    }

    private static final class CaptureResponseWrapper
    extends HttpServletResponseWrapper {
        private final String encoding;
        private final ServletOutputStream ops;
        private boolean isBinaryResponse = false;
        private PrintWriter writer = null;

        CaptureResponseWrapper(HttpServletResponse response, ServletOutputStream ops) {
            super(response);
            this.encoding = response.getCharacterEncoding();
            this.ops = ops;
        }

        public boolean isBinaryResponse() {
            return this.isBinaryResponse;
        }

        public void flushBuffer() throws IOException {
            if (this.isBinaryResponse()) {
                this.getResponse().getOutputStream().flush();
            } else {
                this.writer.flush();
            }
        }

        public ServletOutputStream getOutputStream() throws IOException {
            if (this.writer != null) {
                throw new IOException("'getWriter()' has already been invoked for a character data response.");
            }
            this.isBinaryResponse = true;
            return this.getResponse().getOutputStream();
        }

        public PrintWriter getWriter() throws IOException {
            if (this.writer != null) {
                return this.writer;
            }
            if (this.isBinaryResponse) {
                throw new IOException("'getOutputStream()' has already been invoked for a binary data response.");
            }
            this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.ops, this.encoding));
            return this.writer;
        }
    }
}

