/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.ui.clientlibs;

import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.SlingHttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum LibraryType {
    JS(".js", "application/x-javascript"),
    CSS(".css", "text/css");

    public final String extension;
    public final String contentType;

    private LibraryType(String extension, String contentType) {
        this.extension = extension;
        this.contentType = contentType;
    }

    public static LibraryType fromRequest(SlingHttpServletRequest request) {
        String ext = request.getRequestPathInfo().getExtension();
        if (ext == null || ext.length() == 0) {
            ext = Text.getName(request.getRequestPathInfo().getResourcePath(), '.');
        }
        if (!ext.startsWith(".")) {
            ext = "." + ext;
        }
        if (ext.equals(LibraryType.JS.extension)) {
            return JS;
        }
        if (ext.equals(LibraryType.CSS.extension)) {
            return CSS;
        }
        return null;
    }
}

