/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.workflow;

import com.day.cq.security.Authorizable;
import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowService;
import com.day.cq.workflow.collection.util.ResultSet;
import com.day.cq.workflow.exec.HistoryItem;
import com.day.cq.workflow.exec.Route;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.exec.Workflow;
import com.day.cq.workflow.exec.WorkflowData;
import com.day.cq.workflow.exec.filter.WorkItemFilter;
import com.day.cq.workflow.model.WorkflowModel;
import com.day.cq.workflow.model.WorkflowModelFilter;
import java.security.AccessControlException;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import javax.jcr.Session;
import javax.jcr.version.VersionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface WorkflowSession {
    public WorkflowService getWorkflowService();

    public Session getSession();

    public Authorizable getUser();

    public boolean evaluate(WorkflowData var1, String var2);

    public void deployModel(WorkflowModel var1) throws WorkflowException;

    public WorkflowModel createNewModel(String var1) throws WorkflowException;

    public WorkflowModel createNewModel(String var1, String var2) throws WorkflowException;

    public void deleteModel(String var1) throws WorkflowException;

    public WorkflowModel[] getModels() throws WorkflowException;

    public WorkflowModel[] getModels(WorkflowModelFilter var1) throws WorkflowException;

    public ResultSet<WorkflowModel> getModels(long var1, long var3) throws WorkflowException;

    public ResultSet<WorkflowModel> getModels(long var1, long var3, WorkflowModelFilter var5) throws WorkflowException;

    public WorkflowModel getModel(String var1) throws WorkflowException;

    public WorkflowModel getModel(String var1, String var2) throws WorkflowException, VersionException;

    public Workflow startWorkflow(WorkflowModel var1, WorkflowData var2) throws WorkflowException;

    public Workflow startWorkflow(WorkflowModel var1, WorkflowData var2, Dictionary<String, String> var3) throws WorkflowException;

    public Workflow startWorkflow(WorkflowModel var1, WorkflowData var2, Map<String, Object> var3) throws WorkflowException;

    public void terminateWorkflow(Workflow var1) throws WorkflowException;

    public void resumeWorkflow(Workflow var1) throws WorkflowException;

    public void suspendWorkflow(Workflow var1) throws WorkflowException;

    public WorkItem[] getActiveWorkItems() throws WorkflowException;

    public ResultSet<WorkItem> getActiveWorkItems(long var1, long var3) throws WorkflowException;

    public ResultSet<WorkItem> getActiveWorkItems(long var1, long var3, WorkItemFilter var5) throws WorkflowException;

    public WorkItem[] getAllWorkItems() throws WorkflowException;

    public ResultSet<WorkItem> getAllWorkItems(long var1, long var3) throws WorkflowException;

    public WorkItem getWorkItem(String var1) throws WorkflowException;

    public Workflow[] getWorkflows(String[] var1) throws WorkflowException;

    public ResultSet<Workflow> getWorkflows(String[] var1, long var2, long var4) throws WorkflowException;

    public Workflow[] getAllWorkflows() throws WorkflowException;

    public Workflow getWorkflow(String var1) throws WorkflowException;

    public void complete(WorkItem var1, Route var2) throws WorkflowException;

    public List<Route> getRoutes(WorkItem var1) throws WorkflowException;

    public List<Route> getRoutes(WorkItem var1, boolean var2) throws WorkflowException;

    public List<Route> getBackRoutes(WorkItem var1) throws WorkflowException;

    public List<Route> getBackRoutes(WorkItem var1, boolean var2) throws WorkflowException;

    public WorkflowData newWorkflowData(String var1, Object var2);

    public List<Authorizable> getDelegatees(WorkItem var1) throws WorkflowException;

    public void delegateWorkItem(WorkItem var1, Authorizable var2) throws WorkflowException, AccessControlException;

    public List<HistoryItem> getHistory(Workflow var1) throws WorkflowException;

    public void updateWorkflowData(Workflow var1, WorkflowData var2);

    public void logout();

    public boolean isSuperuser();

    public void restartWorkflow(Workflow var1) throws WorkflowException;
}

