/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment.file;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;

abstract class FileAccess {
    FileAccess() {
        FileAccess fileAccess = this;
    }

    abstract boolean isMemoryMapped();

    abstract int length() throws IOException;

    abstract ByteBuffer read(int var1, int var2) throws IOException;

    abstract void close() throws IOException;

    static class Random
    extends FileAccess {
        private final RandomAccessFile file;

        Random(RandomAccessFile randomAccessFile) {
            Random random = this;
        }

        @Override
        boolean isMemoryMapped() {
            Random random = this;
            return false;
        }

        @Override
        public int length() throws IOException {
            Random random = this;
            return 0;
        }

        @Override
        public synchronized ByteBuffer read(int n, int n2) throws IOException {
            Random random = this;
            return null;
        }

        @Override
        public synchronized void close() throws IOException {
            Random random = this;
        }
    }

    static class Mapped
    extends FileAccess {
        private final MappedByteBuffer buffer;

        Mapped(RandomAccessFile randomAccessFile) throws IOException {
            Mapped mapped = this;
        }

        @Override
        boolean isMemoryMapped() {
            Mapped mapped = this;
            return false;
        }

        @Override
        public int length() {
            Mapped mapped = this;
            return 0;
        }

        @Override
        public ByteBuffer read(int n, int n2) {
            Mapped mapped = this;
            return null;
        }

        @Override
        public void close() {
            Mapped mapped = this;
        }
    }
}

